/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.sdk.module.account.login.ui;

import android.app.Activity;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProvider;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import androidx.navigation.NavController;
import androidx.navigation.NavGraph;
import androidx.navigation.NavInflater;
import androidx.navigation.Navigation;
import androidx.navigation.fragment.NavHostFragment;
import com.bytedance.ttgame.channel.R;
import com.bytedance.ttgame.framework.module.callback.ICallback;
import com.bytedance.ttgame.framework.module.network.Resource;
import com.bytedance.ttgame.framework.module.spi.ServiceManager;
import com.bytedance.ttgame.module.secure.api.ISecureService;
import com.bytedance.ttgame.sdk.module.account.api.LoginStatusEvent;
import com.bytedance.ttgame.sdk.module.account.api.TTUserInfoResult;
import com.bytedance.ttgame.sdk.module.account.login.ui.fragment.BindGuestFragment;
import com.bytedance.ttgame.sdk.module.account.login.ui.fragment.LoginMainFragment;
import com.bytedance.ttgame.sdk.module.account.login.ui.fragment.LoginMoreFragment;
import com.bytedance.ttgame.sdk.module.account.login.ui.fragment.SwitchAccountFragment;
import com.bytedance.ttgame.sdk.module.account.login.viewmodel.LoginViewModel;
import com.bytedance.ttgame.sdk.module.account.login.viewmodel.LoginWithoutUIViewModel;
import com.bytedance.ttgame.sdk.module.account.login.viewmodel.SecondaryLoginViewModel;
import com.bytedance.ttgame.sdk.module.account.pojo.UserInfoData;
import com.bytedance.ttgame.sdk.module.account.pojo.UserInfoResponse;
import com.bytedance.ttgame.sdk.module.account.utils.PlatformDebug;
import com.bytedance.ttgame.sdk.module.core.internal.GameSdkConfig;
import com.bytedance.ttgame.sdk.module.core.internal.SdkCoreData;
import com.bytedance.ttgame.sdk.module.ui.I18nBaseActivity;
import g.main.awa;
import g.main.azr;
import g.main.baa;
import g.main.bao;
import g.main.bbm;
import g.toutiao.rf;
import g.toutiao.rw;
import g.toutiao.vp;
import g.toutiao.vq;
import g.toutiao.vr;
import g.toutiao.vv;
import g.toutiao.wn;
import g.toutiao.wq;
import g.toutiao.wt;
import g.toutiao.wu;
import g.toutiao.xb;
import g.toutiao.xc;
import g.toutiao.xl;
import g.toutiao.xv;
import g.toutiao.xw;
import g.toutiao.yp;
import g.toutiao.yw;
import g.toutiao.zc;
import g.toutiao.ze;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.greenrobot.eventbus.EventBus;
import timber.log.Timber;

public class LoginActivity
extends I18nBaseActivity {
    private static final String TAG = "LoginActivity";
    private ViewModelProvider.Factory sv;
    private SecondaryLoginViewModel sw;
    NavGraph beX;
    NavController beY;
    List<UserInfoData> sx = new ArrayList<UserInfoData>();
    private xb pY;
    private ViewModelProvider.Factory sy;
    private LoginWithoutUIViewModel sz;
    private LoginViewModel sA;
    public static int authType;
    public static boolean ISCNAuthLoginCancel;

    @Override
    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.ar();
        this.setContentView(R.layout.activity_login);
        this.getWindow().setFlags(1024, 1024);
        yp.initSpManager(this.getApplicationContext());
        vq.provideAuthorizeService().init(this.getApplicationContext());
        PlatformDebug.init((Context)this.getApplicationContext());
        this.pY = new xb();
        this.sy = new xv(this.pY);
        this.sA = (LoginViewModel)ViewModelProviders.of((FragmentActivity)this, (ViewModelProvider.Factory)this.sy).get(LoginViewModel.class);
        NavHostFragment navHostFragment = (NavHostFragment)this.getSupportFragmentManager().findFragmentById(R.id.my_nav_host_fragment);
        if (navHostFragment != null) {
            this.beY = navHostFragment.getNavController();
            NavInflater navInflater = this.beY.getNavInflater();
            this.beX = navInflater.inflate(R.navigation.nav_not_login_graph);
            if (this.as()) {
                if (this.getIntent() != null) {
                    int n2 = this.getIntent().getIntExtra("connect_auth_type", -1);
                    new wq().connectThreeAccount((Activity)this, n2);
                }
            } else if (this.av()) {
                this.ax();
            } else if (this.ae()) {
                int n3 = this.getIntent().getIntExtra("without_ui_type", -1);
                this.sz = (LoginWithoutUIViewModel)ViewModelProviders.of((FragmentActivity)this).get(LoginWithoutUIViewModel.class);
                if (!this.sz.isDealed()) {
                    if (n3 == 1) {
                        boolean bl2 = this.at();
                        GameSdkConfig.setLoginWay((String)zc.getPlatformNameByUserType(1));
                        GameSdkConfig.setIsCreateVisitor((boolean)bl2);
                        this.sA.visitorLoginInfo().observe((LifecycleOwner)this, this::visitorLoginResult);
                        this.sA.startVisitorLogin(bl2);
                        this.sz.setDealed(true);
                        Timber.tag((String)TAG).d("onCreate -> start visitor login, isCreateVisitor:%b", new Object[]{bl2});
                    } else if (this.as()) {
                        if (this.getIntent() != null) {
                            int n4 = this.getIntent().getIntExtra("connect_auth_type", -1);
                            new wq().connectThreeAccount((Activity)this, n4);
                            this.sz.setDealed(true);
                        }
                    } else {
                        wn wn2 = zc.getPlatformByUserType(n3);
                        yw.sendLogin(zc.getPlatformNameByUserType(n3), 0, "", false, "", "home");
                        this.a(wn2);
                        this.sz.setDealed(true);
                    }
                }
            } else if (this.isLogin()) {
                this.aw();
            } else {
                this.r("is_login");
            }
        }
        this.sA.getLoginLiveData().observe((LifecycleOwner)this, userInfoResponse -> {
            this.dismissLoadingDialog();
            if (null == userInfoResponse) {
                return;
            }
            if (userInfoResponse.code == 0 && null != userInfoResponse.data) {
                UserInfoData userInfoData = userInfoResponse.data;
                GameSdkConfig.setsUserId((long)userInfoData.userId);
                bao.JK();
                vr.getInstance().setTTUserInfo(vr.getInstance().adapt(userInfoData));
                TTUserInfoResult tTUserInfoResult = new TTUserInfoResult();
                tTUserInfoResult.data = vr.getInstance().getTTUserInfo();
                tTUserInfoResult.code = userInfoResponse.code;
                tTUserInfoResult.message = userInfoResponse.message;
                LoginStatusEvent loginStatusEvent = new LoginStatusEvent(tTUserInfoResult, this.getType());
                EventBus.getDefault().post((Object)loginStatusEvent);
                this.finish();
            } else if (xl.isNeedBindVisitor(userInfoResponse.code)) {
                UserInfoData userInfoData = userInfoResponse.data;
                if (userInfoData != null) {
                    this.b(userInfoData.ttUserId, authType);
                }
            } else {
                GameSdkConfig.resetUserInfo();
                bao.JK();
                vr.getInstance().setTTUserInfo(null);
                if (this.ae()) {
                    this.a((UserInfoResponse)userInfoResponse);
                } else {
                    PlatformDebug.t((Context)SdkCoreData.getInstance().getAppContext(), (String)userInfoResponse.message);
                }
            }
        });
    }

    protected void onActivityResult(int n2, int n3, @Nullable Intent intent) {
        super.onActivityResult(n2, n3, intent);
        vq.provideAuthorizeService().onActivityResult(n2, n3, intent);
    }

    private void ar() {
        if (this.ae() || this.as()) {
            this.setTheme(R.style.Theme_BackgroundDimDisabledActivityDialogStyle);
        }
    }

    private boolean as() {
        if (this.getIntent() != null) {
            return this.getIntent().getBooleanExtra("is_connect_account", false);
        }
        return false;
    }

    private boolean isLogin() {
        return awa.a((String)"is_auto_login", (Context)this.getApplicationContext(), (boolean)false);
    }

    private boolean at() {
        return this.getIntent().getBooleanExtra("is_create_visitor", false);
    }

    private boolean av() {
        return this.getIntent().getBooleanExtra("is_switch", false);
    }

    private boolean ae() {
        return this.getIntent().getBooleanExtra("is_without_ui", false) && -1 != this.getIntent().getIntExtra("without_ui_type", -1);
    }

    private void a(final UserInfoResponse userInfoResponse) {
        if (userInfoResponse == null) {
            Timber.tag((String)TAG).d("withoutUIHandler -> status is null", new Object[0]);
            return;
        }
        if (userInfoResponse.code == -1007 && userInfoResponse.data != null) {
            vv vv2 = new vv();
            vv2.switchAccount(userInfoResponse.data, new ICallback<TTUserInfoResult>(){

                public void onSuccess(@Nullable TTUserInfoResult tTUserInfoResult) {
                    LoginStatusEvent loginStatusEvent = new LoginStatusEvent(tTUserInfoResult, LoginActivity.this.getType());
                    EventBus.getDefault().post((Object)loginStatusEvent);
                    LoginActivity.this.finish();
                }

                public void onFailed(@Nullable TTUserInfoResult tTUserInfoResult) {
                    if (null != userInfoResponse.data) {
                        wn wn2 = zc.getPlatformByUserType(userInfoResponse.data.userType);
                        LoginActivity.this.a(wn2);
                    }
                }
            });
        } else {
            this.b(userInfoResponse);
            TTUserInfoResult tTUserInfoResult = new TTUserInfoResult();
            tTUserInfoResult.data = vr.getInstance().getTTUserInfo();
            tTUserInfoResult.code = userInfoResponse.code;
            tTUserInfoResult.message = userInfoResponse.message;
            LoginStatusEvent loginStatusEvent = new LoginStatusEvent(tTUserInfoResult, this.getType());
            EventBus.getDefault().post((Object)loginStatusEvent);
            this.finish();
        }
    }

    private void b(UserInfoResponse userInfoResponse) {
        UserInfoData userInfoData = userInfoResponse.data;
        if (userInfoData != null) {
            yw.sendLogin(zc.getPlatformNameByUserType(userInfoData.userType), 0, "", false, "", "home");
            yw.sendLoginFail(zc.getPlatformNameByUserType(userInfoData.userType), userInfoResponse.code, userInfoResponse.message, "", "", "home");
        } else {
            yw.sendLogin(zc.getPlatformNameByUserType(1), 0, "", false, "", "home");
            yw.sendLoginFail(zc.getPlatformNameByUserType(1), userInfoResponse.code, userInfoResponse.message, "", "", "home");
        }
    }

    private void aw() {
        this.sv = new xw(new xc());
        this.sw = (SecondaryLoginViewModel)ViewModelProviders.of((FragmentActivity)this, (ViewModelProvider.Factory)this.sv).get(SecondaryLoginViewModel.class);
        this.showLoading();
        this.r("is_auto_login");
    }

    private void ax() {
        awa.a((String)"is_auto_login", (boolean)false, (Context)this.getApplicationContext());
        this.r("is_switch");
    }

    private void a(wn wn2) {
        if (null == wn2) {
            return;
        }
        vq.provideAuthorizeService().authorize((Activity)this, wn2, new wt.b(){

            @Override
            public void onSuccess(UserInfoResponse userInfoResponse) {
                ((LoginViewModel)ViewModelProviders.of((FragmentActivity)LoginActivity.this).get(LoginViewModel.class)).getLoginLiveData().setValue((Object)userInfoResponse);
                awa.a((String)"is_auto_login", (boolean)true, (Context)SdkCoreData.getInstance().getAppContext());
                awa.a((String)"is_guest_entrance", (boolean)false, (Context)SdkCoreData.getInstance().getAppContext());
            }

            @Override
            public void onFailed(int n2, String string2, String string3) {
                UserInfoResponse userInfoResponse = new UserInfoResponse();
                userInfoResponse.code = n2;
                userInfoResponse.message = string2;
                ((LoginViewModel)ViewModelProviders.of((FragmentActivity)LoginActivity.this).get(LoginViewModel.class)).getLoginLiveData().setValue((Object)userInfoResponse);
                awa.a((String)"is_auto_login", (boolean)false, (Context)SdkCoreData.getInstance().getAppContext());
            }
        }, null);
    }

    private void m(int n2) {
        this.beX.setStartDestination(n2);
        this.beY.setGraph(this.beX);
        this.dismissLoadingDialog();
    }

    private void r(final String string2) {
        final LiveData liveData = azr.IM().IN().IK().IO();
        liveData.observe((LifecycleOwner)this, (Observer)new Observer<List<UserInfoData>>(){

            public void onChanged(@Nullable List<UserInfoData> list) {
                if (vr.getInstance().getTTUserInfo() != null && vr.getInstance().getTTUserInfo().getUserId() != 0L) {
                    yw.sendAccountStatus("1", list != null ? String.valueOf(list.size()) : "0");
                } else {
                    yw.sendAccountStatus("2", list != null ? String.valueOf(list.size()) : "0");
                }
                LoginActivity.this.sx = list;
                liveData.removeObserver((Observer)this);
                if (LoginActivity.this.sx != null && LoginActivity.this.sx.size() > 0) {
                    switch (string2) {
                        case "is_switch": {
                            LoginActivity.this.m(R.id.switch_account);
                            break;
                        }
                        case "is_auto_login": {
                            UserInfoData userInfoData = LoginActivity.this.sx.get(0);
                            if (userInfoData == null) break;
                            GameSdkConfig.setLoginType((String)"auto");
                            GameSdkConfig.setLoginWay((String)zc.getPlatformNameByUserType(userInfoData.userType));
                            yw.sendLogin(GameSdkConfig.getLoginWay(), 1, "", false, "", "auto");
                            LoginActivity.this.sw.secondLoginResult().observe((LifecycleOwner)LoginActivity.this, resource -> this.b(userInfoData, (Resource<UserInfoResponse>)resource));
                            LoginActivity.this.sw.startSecondLogin(userInfoData);
                            break;
                        }
                        case "is_login": {
                            if (list != null && !list.isEmpty()) {
                                LoginActivity.this.beX.setStartDestination(R.id.switch_account);
                                LoginActivity.this.beY.setGraph(LoginActivity.this.beX);
                                break;
                            }
                            LoginActivity.this.beX.setStartDestination(R.id.main);
                            LoginActivity.this.beY.setGraph(LoginActivity.this.beX);
                        }
                    }
                } else {
                    LoginActivity.this.m(R.id.main);
                }
            }

            private void b(UserInfoData userInfoData, Resource<UserInfoResponse> resource) {
                LoginActivity.this.a(userInfoData, (Resource<UserInfoResponse>)resource);
            }
        });
    }

    private void a(UserInfoData userInfoData, Resource<UserInfoResponse> resource) {
        long l2 = System.currentTimeMillis();
        if (resource != null) {
            if (Resource.Status.LOADING != resource.status) {
                ((LoginViewModel)ViewModelProviders.of((FragmentActivity)this).get(LoginViewModel.class)).getLoginLiveData().setValue(resource.data);
            }
            switch (resource.status) {
                case SUCCESS: {
                    UserInfoResponse userInfoResponse = (UserInfoResponse)resource.data;
                    if (null != userInfoResponse) {
                        if (userInfoResponse.isSuccess()) {
                            this.dismissLoadingDialog();
                            long l3 = System.currentTimeMillis();
                            if (null != this.sx.get(0)) {
                                userInfoResponse.data.ttUserId = this.sx.get((int)0).ttUserId;
                                userInfoResponse.data.isScLogin = this.sx.get((int)0).isScLogin;
                            }
                            new xb().saveLoginAccount(userInfoResponse.data);
                            awa.a((String)"is_auto_login", (boolean)true, (Context)this.getApplicationContext());
                            if (userInfoResponse == null || userInfoResponse.data == null) break;
                            vp.a.multiBindStatus = userInfoResponse.data.multiBindStatus;
                            yw.sendLoginRes(null, null, zc.getPlatformNameByUserType(userInfoResponse.data.userType), "auto");
                            ze.autoLoginSuccessMonitor(userInfoResponse.data.userId, zc.getPlatformNameByUserType(userInfoResponse.data.userType), l3 - l2);
                            break;
                        }
                        awa.a((String)"is_auto_login", (boolean)false, (Context)this.getApplicationContext());
                        long l4 = ((ISecureService)ServiceManager.get().getService(ISecureService.class)).emulatorJudgmentWaitTime();
                        new Handler().postDelayed(() -> {
                            this.dismissLoadingDialog();
                            if (this.sx.size() > 0) {
                                this.m(R.id.switch_account);
                            } else {
                                this.m(R.id.main);
                            }
                        }, l4);
                        if (userInfoData != null) {
                            yw.sendLoginRes(String.valueOf(userInfoResponse.code), userInfoResponse.message, zc.getPlatformNameByUserType(userInfoData.userType), "auto");
                            yw.sendLoginFail(GameSdkConfig.getLoginWay(), userInfoResponse.code, userInfoResponse.message, null, resource.logId, "auto");
                            ze.autoLoginFailMonitor(userInfoResponse.code, userInfoResponse.message, userInfoData.userId, zc.getPlatformNameByUserType(userInfoData.userType), "bsdk_fail");
                            break;
                        }
                        yw.sendLoginRes(String.valueOf(userInfoResponse.code), userInfoResponse.message, "", "auto");
                        yw.sendLoginFail(GameSdkConfig.getLoginWay(), userInfoResponse.code, userInfoResponse.message, null, resource.logId, "auto");
                        ze.autoLoginFailMonitor(userInfoResponse.code, userInfoResponse.message, -1L, "", "bsdk_fail");
                        break;
                    }
                    this.dismissLoadingDialog();
                    break;
                }
                case ERROR: {
                    long l5 = ((ISecureService)ServiceManager.get().getService(ISecureService.class)).emulatorJudgmentWaitTime();
                    new Handler().postDelayed(() -> {
                        this.dismissLoadingDialog();
                        this.m(R.id.switch_account);
                    }, l5);
                    if (resource != null && baa.jI((String)resource.message)) {
                        bbm.H((Context)SdkCoreData.getInstance().getAppContext(), (String)SdkCoreData.getInstance().getAppContext().getResources().getString(R.string.gsdk_account_cert_date_invalid));
                    }
                    if (userInfoData != null) {
                        if (resource.data != null) {
                            yw.sendLoginRes(String.valueOf(-3000), ((UserInfoResponse)resource.data).message, zc.getPlatformNameByUserType(userInfoData.userType), "auto");
                            yw.sendLoginFail(GameSdkConfig.getLoginWay(), -3000, ((UserInfoResponse)resource.data).message, yw.q(((UserInfoResponse)resource.data).code, ((UserInfoResponse)resource.data).message), resource.logId, "auto");
                            ze.autoLoginFailMonitor(-3000, ((UserInfoResponse)resource.data).message, userInfoData.userId, zc.getPlatformNameByUserType(userInfoData.userType), "bsdk_fail");
                            break;
                        }
                        yw.sendLoginRes(String.valueOf(-3000), resource.message, zc.getPlatformNameByUserType(userInfoData.userType), "auto");
                        yw.sendLoginFail(GameSdkConfig.getLoginWay(), -3000, resource.message, yw.q(-3000, resource.message), resource.logId, "auto");
                        ze.autoLoginFailMonitor(-3000, resource.message, userInfoData.userId, zc.getPlatformNameByUserType(userInfoData.userType), "bsdk_fail");
                        break;
                    }
                    if (resource.data != null) {
                        yw.sendLoginRes(String.valueOf(-3000), ((UserInfoResponse)resource.data).message, "", "auto");
                        yw.sendLoginFail(GameSdkConfig.getLoginWay(), -3000, ((UserInfoResponse)resource.data).message, yw.q(((UserInfoResponse)resource.data).code, ((UserInfoResponse)resource.data).message), resource.logId, "auto");
                        ze.autoLoginFailMonitor(-3000, ((UserInfoResponse)resource.data).message, -1L, zc.getPlatformNameByUserType(userInfoData.userType), "bsdk_fail");
                        break;
                    }
                    yw.sendLoginRes(String.valueOf(-3000), resource.message, "", "auto");
                    yw.sendLoginFail(GameSdkConfig.getLoginWay(), -3000, resource.message, yw.q(-3000, resource.message), resource.logId, "auto");
                    ze.autoLoginFailMonitor(-3000, resource.message, -1L, zc.getPlatformNameByUserType(userInfoData.userType), "bsdk_fail");
                }
            }
        }
    }

    public void visitorLoginResult(Resource<UserInfoResponse> resource) {
        long l2 = System.currentTimeMillis();
        if (resource != null) {
            switch (resource.status) {
                case SUCCESS: {
                    UserInfoResponse userInfoResponse = (UserInfoResponse)resource.data;
                    if (userInfoResponse != null && userInfoResponse.isSuccess()) {
                        long l3 = System.currentTimeMillis();
                        final UserInfoData userInfoData = userInfoResponse.data;
                        Timber.tag((String)TAG).d("visitorLoginResult -> success, isCreateVisitor:%b, userInfoData:%s", new Object[]{this.at(), userInfoData});
                        if (this.at()) {
                            wu.deleteOldVisitor((Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(){

                                public Unit invoke(Boolean bl2) {
                                    LoginActivity.this.pY.saveLoginAccount(userInfoData);
                                    return null;
                                }
                            });
                        } else {
                            this.pY.saveLoginAccount(userInfoData);
                        }
                        wu.setLastLoginVisitorClientUUID(userInfoData);
                        awa.a((String)"is_auto_login", (boolean)true, (Context)this);
                        if (userInfoData != null) {
                            vp.a.multiBindStatus = userInfoData.multiBindStatus;
                            yw.sendLogin(GameSdkConfig.getLoginWay(), 0, "", false, "", GameSdkConfig.getLoginType());
                        }
                        awa.a((String)"is_guest_entrance", (boolean)true, (Context)this);
                        if (userInfoData == null) break;
                        ze.visitorLoginSuccessMonitor(userInfoData.userId, l3 - l2);
                        break;
                    }
                    awa.a((String)"is_auto_login", (boolean)false, (Context)this);
                    if (userInfoResponse == null) break;
                    ze.visitorLoginFailMonitor(userInfoResponse.code, userInfoResponse.message, "login_error");
                    Timber.tag((String)TAG).d("visitorLoginResult -> fail, code:%d, message:%s", new Object[]{userInfoResponse.code, userInfoResponse.message});
                    break;
                }
                case ERROR: {
                    Timber.tag((String)TAG).d("visitorLoginResult -> error, message:%s", new Object[]{resource.message});
                    xl.showNetworkErrorToast();
                    awa.a((String)"is_auto_login", (boolean)false, (Context)this);
                    this.finish();
                    ze.visitorLoginFailMonitor(-3000, resource.message, "login_error");
                }
            }
            if (Resource.Status.LOADING != resource.status) {
                ((LoginViewModel)ViewModelProviders.of((FragmentActivity)this).get(LoginViewModel.class)).getLoginLiveData().setValue(resource.data);
            }
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        rf rf2 = rw.getService(rf.class);
        if (rf2 != null) {
            rf2.onDestroy();
        }
    }

    private int getType() {
        if (this.ae()) {
            return 6;
        }
        return this.av() ? 2 : 1;
    }

    private void b(long l2, int n2) {
        try {
            NavController navController = Navigation.findNavController((View)this.findViewById(R.id.my_nav_host_fragment));
            Bundle bundle = new Bundle();
            bundle.putLong("tt_user_id", l2);
            bundle.putInt("bind_way", n2);
            navController.navigate(R.id.bind_guest, bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isPwdLogin() {
        return false;
    }

    public LoginViewModel getLoginViewModel() {
        return this.sA;
    }

    public void onBackPressed() {
        NavHostFragment navHostFragment = (NavHostFragment)this.getSupportFragmentManager().findFragmentById(R.id.my_nav_host_fragment);
        List list = navHostFragment.getChildFragmentManager().getFragments();
        if (list != null && !list.isEmpty()) {
            Fragment fragment = (Fragment)list.get(0);
            if (fragment instanceof LoginMainFragment) {
                yw.sendLoginShowClose("android_system_back", "home");
            } else if (fragment instanceof LoginMoreFragment) {
                yw.sendLoginShowClose("android_system_back", "more_options");
            } else if (fragment instanceof SwitchAccountFragment) {
                yw.sendLoginShowClose("android_system_back", "history");
            } else if (fragment instanceof BindGuestFragment) {
                String string2 = SdkCoreData.getInstance().getAppContext().getString(R.string.gsdk_account_third_login_cancel);
                yw.sendLoginFail(GameSdkConfig.getLoginWay(), -100001, string2, yw.q(-2, string2), null, "home");
            }
        }
        super.onBackPressed();
    }

    static {
        ISCNAuthLoginCancel = false;
    }
}

