/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.sdk.module.account.accountmanage.ui;

import android.app.Activity;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import androidx.navigation.NavController;
import androidx.navigation.NavGraph;
import androidx.navigation.NavInflater;
import androidx.navigation.fragment.NavHostFragment;
import com.bytedance.ttgame.channel.R;
import com.bytedance.ttgame.framework.module.network.Resource;
import com.bytedance.ttgame.sdk.module.account.accountmanager.viewmodel.AccountManagementViewModel;
import com.bytedance.ttgame.sdk.module.account.api.LoginStatusEvent;
import com.bytedance.ttgame.sdk.module.account.api.TTBindInfo;
import com.bytedance.ttgame.sdk.module.account.api.TTUserInfo;
import com.bytedance.ttgame.sdk.module.account.api.TTUserInfoResult;
import com.bytedance.ttgame.sdk.module.account.pojo.ConnectInfoData;
import com.bytedance.ttgame.sdk.module.account.pojo.TTSwitchAccountResponse;
import com.bytedance.ttgame.sdk.module.account.pojo.UserInfoData;
import com.bytedance.ttgame.sdk.module.account.pojo.UserInfoResponse;
import com.bytedance.ttgame.sdk.module.account.utils.PlatformDebug;
import com.bytedance.ttgame.sdk.module.core.internal.GameSdkConfig;
import com.bytedance.ttgame.sdk.module.core.internal.SdkCoreData;
import com.bytedance.ttgame.sdk.module.ui.I18nBaseActivity;
import g.main.awa;
import g.main.azr;
import g.main.azs;
import g.main.bae;
import g.main.bao;
import g.toutiao.dw;
import g.toutiao.ec;
import g.toutiao.eg;
import g.toutiao.iq;
import g.toutiao.re;
import g.toutiao.rf;
import g.toutiao.rw;
import g.toutiao.vp;
import g.toutiao.vq;
import g.toutiao.vr;
import g.toutiao.vx;
import g.toutiao.wt;
import g.toutiao.wu;
import g.toutiao.xb;
import g.toutiao.xl;
import g.toutiao.xo;
import g.toutiao.yw;
import g.toutiao.zc;
import g.toutiao.ze;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import timber.log.Timber;

public class AccountManagementActivity
extends I18nBaseActivity {
    private static final String TAG = "AccountManagementActivity";
    private AccountManagementViewModel qp;
    private static final String pt = "success";
    private static dw gL;
    private static UserInfoData qq;
    private static final int qr = 99;
    public UserInfoData mCurrentUserInfoData = null;
    private static UserInfoData qs;

    @Override
    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.activity_account_management);
        this.getWindow().setFlags(1024, 1024);
        PlatformDebug.init((Context)this.getApplicationContext());
        vq.provideAuthorizeService().init(this.getApplicationContext());
        azr.init((Context)this);
        final LiveData liveData = azr.IM().IN().IK().IO();
        liveData.observe((LifecycleOwner)this, (Observer)new Observer<List<UserInfoData>>(){

            public void onChanged(@Nullable List<UserInfoData> list) {
                if (list != null && !list.isEmpty()) {
                    UserInfoData userInfoData;
                    AccountManagementActivity.this.mCurrentUserInfoData = userInfoData = list.get(0);
                    liveData.removeObserver((Observer)this);
                    if (userInfoData.userType == 1 || userInfoData.isBound || !AccountManagementActivity.this.d(userInfoData)) {
                        if (AccountManagementActivity.this.ae()) {
                            if (AccountManagementActivity.this.getIntent().getBooleanExtra("is_in_bind_process", false)) {
                                AccountManagementActivity.this.authBindWithoutUI(userInfoData, AccountManagementActivity.this.getIntent().getIntExtra("without_ui_type", 1));
                            } else if (AccountManagementActivity.this.getIntent().getBooleanExtra("is_in_rebind_process", false)) {
                                int n2 = AccountManagementActivity.this.getIntent().getIntExtra("without_ui_force_rebind_type", -1);
                                int n3 = AccountManagementActivity.this.getIntent().getIntExtra("without_ui_force_rebind", -1);
                                AccountManagementActivity.this.forceRebindWithoutUI(userInfoData, n2, n3);
                            } else {
                                AccountManagementActivity.this.unBindWithoutUI(userInfoData, AccountManagementActivity.this.getIntent().getIntExtra("without_ui_unbind_type", -1));
                            }
                        } else {
                            AccountManagementActivity.this.b(userInfoData);
                        }
                    } else if (AccountManagementActivity.this.ae()) {
                        UserInfoResponse userInfoResponse = new UserInfoResponse();
                        userInfoResponse.code = -1005;
                        userInfoResponse.message = AccountManagementActivity.this.getString(R.string.gsdk_account_account_cannot_bind);
                        ((AccountManagementViewModel)ViewModelProviders.of((FragmentActivity)AccountManagementActivity.this).get(AccountManagementViewModel.class)).getBindLiveData().setValue((Object)userInfoResponse);
                    } else if (vp.a.multiBindStatus) {
                        AccountManagementActivity.this.b(userInfoData);
                    } else {
                        PlatformDebug.init((Context)AccountManagementActivity.this.getApplicationContext());
                        PlatformDebug.t((Context)AccountManagementActivity.this.getApplicationContext(), (String)AccountManagementActivity.this.getString(R.string.gsdk_account_account_cannot_bind));
                        AccountManagementActivity.this.finish();
                    }
                } else {
                    AccountManagementActivity.this.finish();
                }
            }
        });
        this.qp = (AccountManagementViewModel)ViewModelProviders.of((FragmentActivity)this).get(AccountManagementViewModel.class);
        this.qp.getBindLiveData().observe((LifecycleOwner)this, (Observer)new Observer<UserInfoResponse>(){

            public void onChanged(@Nullable UserInfoResponse userInfoResponse) {
                AccountManagementActivity.this.dismissLoadingDialog();
                if (userInfoResponse != null) {
                    if (userInfoResponse.code == 0 && userInfoResponse.data != null) {
                        UserInfoData userInfoData = userInfoResponse.data;
                        GameSdkConfig.setsUserId((long)userInfoData.userId);
                        bao.JK();
                        vr.getInstance().setTTUserInfo(vr.getInstance().adapt(userInfoData));
                        TTUserInfoResult tTUserInfoResult = new TTUserInfoResult();
                        tTUserInfoResult.data = vr.getInstance().getTTUserInfo();
                        tTUserInfoResult.code = userInfoResponse.code;
                        tTUserInfoResult.message = userInfoResponse.message;
                        LoginStatusEvent loginStatusEvent = new LoginStatusEvent(tTUserInfoResult, AccountManagementActivity.this.getType());
                        EventBus.getDefault().post((Object)loginStatusEvent);
                        AccountManagementActivity.this.finish();
                    } else if (AccountManagementActivity.this.ae()) {
                        TTUserInfoResult tTUserInfoResult = new TTUserInfoResult();
                        tTUserInfoResult.code = userInfoResponse.code;
                        tTUserInfoResult.message = userInfoResponse.message;
                        tTUserInfoResult.data = new TTUserInfo();
                        if (userInfoResponse.data != null) {
                            tTUserInfoResult.data.setConflictUserId(userInfoResponse.data.conflictUserId);
                        }
                        LoginStatusEvent loginStatusEvent = new LoginStatusEvent(tTUserInfoResult, AccountManagementActivity.this.getType());
                        EventBus.getDefault().post((Object)loginStatusEvent);
                        AccountManagementActivity.this.finish();
                    } else {
                        PlatformDebug.t((Context)SdkCoreData.getInstance().getAppContext(), (String)userInfoResponse.message);
                    }
                }
            }
        });
        this.qp.getUnBindLiveData().observe((LifecycleOwner)this, (Observer)new Observer<UserInfoResponse>(){

            public void onChanged(@Nullable UserInfoResponse userInfoResponse) {
                if (userInfoResponse != null) {
                    if (userInfoResponse.code == 0 && userInfoResponse.data != null) {
                        UserInfoData userInfoData = userInfoResponse.data;
                        GameSdkConfig.setsUserId((long)userInfoData.userId);
                        bao.JK();
                        vr.getInstance().setTTUserInfo(vr.getInstance().adapt(userInfoData));
                        TTUserInfoResult tTUserInfoResult = new TTUserInfoResult();
                        tTUserInfoResult.data = vr.getInstance().getTTUserInfo();
                        tTUserInfoResult.code = userInfoResponse.code;
                        tTUserInfoResult.message = userInfoResponse.message;
                        LoginStatusEvent loginStatusEvent = new LoginStatusEvent(tTUserInfoResult, 10);
                        EventBus.getDefault().post((Object)loginStatusEvent);
                        AccountManagementActivity.this.finish();
                    } else if (AccountManagementActivity.this.ae()) {
                        TTUserInfoResult tTUserInfoResult = new TTUserInfoResult();
                        tTUserInfoResult.code = userInfoResponse.code;
                        tTUserInfoResult.message = userInfoResponse.message;
                        LoginStatusEvent loginStatusEvent = new LoginStatusEvent(tTUserInfoResult, 10);
                        EventBus.getDefault().post((Object)loginStatusEvent);
                        AccountManagementActivity.this.finish();
                    }
                }
            }
        });
        this.qp.getForceRebindLiveData().observe((LifecycleOwner)this, (Observer)new Observer<UserInfoResponse>(){

            public void onChanged(@Nullable UserInfoResponse userInfoResponse) {
                if (userInfoResponse != null) {
                    if (userInfoResponse.code == 0 && userInfoResponse.data != null) {
                        UserInfoData userInfoData = userInfoResponse.data;
                        GameSdkConfig.setsUserId((long)userInfoData.userId);
                        bao.JK();
                        vr.getInstance().setTTUserInfo(vr.getInstance().adapt(userInfoData));
                        TTUserInfoResult tTUserInfoResult = new TTUserInfoResult();
                        tTUserInfoResult.data = vr.getInstance().getTTUserInfo();
                        tTUserInfoResult.code = userInfoResponse.code;
                        tTUserInfoResult.message = userInfoResponse.message;
                        LoginStatusEvent loginStatusEvent = new LoginStatusEvent(tTUserInfoResult, 11);
                        EventBus.getDefault().post((Object)loginStatusEvent);
                        AccountManagementActivity.this.finish();
                    } else if (AccountManagementActivity.this.ae()) {
                        TTUserInfoResult tTUserInfoResult = new TTUserInfoResult();
                        tTUserInfoResult.code = userInfoResponse.code;
                        tTUserInfoResult.message = userInfoResponse.message;
                        LoginStatusEvent loginStatusEvent = new LoginStatusEvent(tTUserInfoResult, 11);
                        EventBus.getDefault().post((Object)loginStatusEvent);
                        AccountManagementActivity.this.finish();
                    }
                }
            }
        });
    }

    private void b(UserInfoData userInfoData) {
        Bundle bundle = new Bundle();
        bundle.putSerializable(vx.CURRENT_ACCOUNT, (Serializable)userInfoData);
        NavHostFragment navHostFragment = (NavHostFragment)this.getSupportFragmentManager().findFragmentById(R.id.account_nav_host_fragment);
        if (navHostFragment != null) {
            NavController navController = navHostFragment.getNavController();
            NavInflater navInflater = navController.getNavInflater();
            NavGraph navGraph = navInflater.inflate(R.navigation.nav_bind_graph);
            navGraph.setStartDestination(R.id.account_management);
            navController.setGraph(navGraph, bundle);
        }
    }

    private boolean ae() {
        return this.getIntent().getBooleanExtra("is_without_ui", false);
    }

    public void authBindWithoutUI(final UserInfoData userInfoData, final int n2) {
        re re2;
        if (userInfoData == null) {
            return;
        }
        yw.startBind(n2);
        if (!this.canBindMore()) {
            UserInfoResponse userInfoResponse = new UserInfoResponse();
            userInfoResponse.code = -1022;
            userInfoResponse.message = SdkCoreData.getInstance().getAppContext().getResources().getString(R.string.gsdk_account_bind_limit);
            ((AccountManagementViewModel)ViewModelProviders.of((FragmentActivity)this).get(AccountManagementViewModel.class)).getBindLiveData().setValue((Object)userInfoResponse);
            if (userInfoData.userType == 1) {
                ze.authBindFailMonitor(userInfoResponse.code, userInfoResponse.message, "bsdk_fail", userInfoData.userId, zc.getPlatformNameByUserType(n2), true);
            } else {
                ze.authBindFailMonitor(userInfoResponse.code, userInfoResponse.message, "bsdk_fail", userInfoData.userId, zc.getPlatformNameByUserType(n2), false);
            }
            return;
        }
        final HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("flag", userInfoData.isBound ? 1 : 0);
        hashMap.put("bind_type", n2);
        hashMap.put("user_type", userInfoData.userType);
        hashMap.put("user_id", userInfoData.userId);
        hashMap.put("token", userInfoData.token);
        final long l2 = System.currentTimeMillis();
        if (n2 == 5 && null != SdkCoreData.getInstance().getConfig() && SdkCoreData.getInstance().getConfig().getChannelOp().equals("bsdkintl") && (re2 = rw.getService(re.class)) != null) {
            re2.googleSignOut();
        }
        vq.provideAuthorizeService().authorize((Activity)this, zc.getPlatformByUserType(n2), new wt.c(){

            @Override
            public void onSuccess(final UserInfoResponse userInfoResponse) {
                if (AccountManagementActivity.this.qp == null) {
                    return;
                }
                AccountManagementActivity.this.qp.startBind(hashMap);
                AccountManagementActivity.this.qp.getBindData().observe((LifecycleOwner)AccountManagementActivity.this, (Observer)new Observer<Resource<UserInfoResponse>>(){

                    public void onChanged(@Nullable Resource<UserInfoResponse> resource) {
                        if (resource != null) {
                            switch (resource.status) {
                                case SUCCESS: {
                                    UserInfoResponse userInfoResponse2 = (UserInfoResponse)resource.data;
                                    if (userInfoResponse2 == null) {
                                        return;
                                    }
                                    if (userInfoResponse2.isSuccess()) {
                                        long l2 = System.currentTimeMillis();
                                        if (userInfoResponse2.data != null) {
                                            userInfoResponse2.data.ttUserId = userInfoResponse.data.ttUserId;
                                            userInfoResponse2.data.isScLogin = 0;
                                        }
                                        vr.getInstance().setTTUserInfo(vr.getInstance().adapt(userInfoResponse2.data));
                                        new xb().saveLoginAccount(userInfoResponse2.data);
                                        AccountManagementActivity.this.mCurrentUserInfoData = userInfoResponse2.data;
                                        ((AccountManagementViewModel)ViewModelProviders.of((FragmentActivity)AccountManagementActivity.this).get(AccountManagementViewModel.class)).getBindLiveData().setValue((Object)userInfoResponse2);
                                        awa.a((String)"is_guest_entrance", (boolean)false, (Context)SdkCoreData.getInstance().getAppContext());
                                        if (userInfoData != null) {
                                            if (userInfoData.userType == 1) {
                                                ze.authBindSuccessMonitor(userInfoData.userId, zc.getPlatformNameByUserType(n2), true, l2 - l2);
                                            } else {
                                                ze.authBindSuccessMonitor(userInfoData.userId, zc.getPlatformNameByUserType(n2), false, l2 - l2);
                                            }
                                        }
                                        awa.a((String)"is_guest_entrance", (boolean)false, (Context)SdkCoreData.getInstance().getAppContext());
                                        break;
                                    }
                                    if (userInfoResponse2.code != -1014) {
                                        AccountManagementActivity.this.bindFailProcess(userInfoData);
                                        AccountManagementActivity.this.af();
                                    }
                                    ((AccountManagementViewModel)ViewModelProviders.of((FragmentActivity)AccountManagementActivity.this).get(AccountManagementViewModel.class)).getBindLiveData().setValue((Object)userInfoResponse2);
                                    if (userInfoData == null || userInfoData == null) break;
                                    if (userInfoData.userType == 1) {
                                        ze.authBindFailMonitor(userInfoResponse2.code, userInfoResponse2.message, "bsdk_fail", userInfoData.userId, zc.getPlatformNameByUserType(n2), true);
                                        break;
                                    }
                                    ze.authBindFailMonitor(userInfoResponse2.code, userInfoResponse2.message, "bsdk_fail", userInfoData.userId, zc.getPlatformNameByUserType(n2), false);
                                    break;
                                }
                                case ERROR: {
                                    String string2 = SdkCoreData.getInstance().getAppContext().getResources().getString(R.string.gsdk_account_network_error);
                                    AccountManagementActivity.this.bindFailProcess(userInfoData);
                                    ((AccountManagementViewModel)ViewModelProviders.of((FragmentActivity)AccountManagementActivity.this).get(AccountManagementViewModel.class)).getBindLiveData().setValue((Object)xl.failWithNetWorkError());
                                    if (userInfoData != null) {
                                        if (userInfoData.userType == 1) {
                                            ze.authBindFailMonitor(-3000, resource.message, "bsdk_fail", userInfoData.userId, zc.getPlatformNameByUserType(n2), true);
                                        } else {
                                            ze.authBindFailMonitor(-3000, resource.message, "bsdk_fail", userInfoData.userId, zc.getPlatformNameByUserType(n2), false);
                                        }
                                    }
                                    AccountManagementActivity.this.af();
                                }
                            }
                        }
                    }
                });
            }

            @Override
            public void onFailed(int n22, String string2, String string3) {
                String string4 = SdkCoreData.getInstance().getAppContext().getResources().getString(R.string.gsdk_account_authorization_failure);
                UserInfoResponse userInfoResponse = xl.authTriFailure(string4);
                ((AccountManagementViewModel)ViewModelProviders.of((FragmentActivity)AccountManagementActivity.this).get(AccountManagementViewModel.class)).getBindLiveData().setValue((Object)userInfoResponse);
            }
        }, null);
    }

    public void unBindWithoutUI(final UserInfoData userInfoData, final int n2) {
        if (userInfoData == null || n2 == -1) {
            return;
        }
        Timber.tag((String)TAG).d("unBindWithoutUI -> start unbind, userInfoData:%s, type:%d", new Object[]{userInfoData, n2});
        yw.unbindStart(n2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("unbind_type", n2);
        hashMap.put("user_type", userInfoData.userType);
        hashMap.put("token", userInfoData.token);
        final long l2 = System.currentTimeMillis();
        this.qp.startUnBind(hashMap);
        this.qp.getUnBindData().observe((LifecycleOwner)this, (Observer)new Observer<Resource<UserInfoResponse>>(){

            public void onChanged(@Nullable Resource<UserInfoResponse> resource) {
                if (resource != null) {
                    switch (resource.status) {
                        case SUCCESS: {
                            UserInfoResponse userInfoResponse = (UserInfoResponse)resource.data;
                            if (userInfoResponse == null) {
                                return;
                            }
                            if (userInfoResponse.isSuccess()) {
                                long l22 = System.currentTimeMillis();
                                if (wu.isUnbindVisitor(userInfoResponse.data)) {
                                    wu.deleteOtherVisitor(userInfoResponse.data);
                                    wu.setLastLoginVisitorClientUUID(userInfoResponse.data);
                                }
                                AccountManagementActivity.this.findBackCurrentPassportUid(userInfoResponse.data);
                                if (AccountManagementActivity.this.isUnBindCurrentAccount(n2, userInfoResponse.data)) {
                                    AccountManagementActivity.this.unbindCurrentProcess(userInfoResponse.data);
                                } else {
                                    if (userInfoResponse.data != null) {
                                        userInfoResponse.data.isScLogin = 0;
                                    }
                                    new xb().saveLoginAccount(userInfoResponse.data);
                                    AccountManagementActivity.this.mCurrentUserInfoData = userInfoResponse.data;
                                }
                                ((AccountManagementViewModel)ViewModelProviders.of((FragmentActivity)AccountManagementActivity.this).get(AccountManagementViewModel.class)).getUnBindLiveData().setValue((Object)userInfoResponse);
                                if (userInfoData == null) break;
                                ze.unBindSuccessMonitor(userInfoData.userId, zc.getPlatformNameByUserType(n2), l22 - l2);
                                break;
                            }
                            ((AccountManagementViewModel)ViewModelProviders.of((FragmentActivity)AccountManagementActivity.this).get(AccountManagementViewModel.class)).getUnBindLiveData().setValue((Object)userInfoResponse);
                            if (userInfoData == null || userInfoResponse == null) break;
                            ze.unBindFailMonitor(userInfoResponse.code, userInfoResponse.message, "bsdk_fail", userInfoData.userId, zc.getPlatformNameByUserType(n2));
                            break;
                        }
                        case ERROR: {
                            ((AccountManagementViewModel)ViewModelProviders.of((FragmentActivity)AccountManagementActivity.this).get(AccountManagementViewModel.class)).getUnBindLiveData().setValue((Object)xl.failWithNetWorkError());
                            if (userInfoData == null) break;
                            ze.unBindFailMonitor(-3000, resource.message, "bsdk_fail", userInfoData.userId, zc.getPlatformNameByUserType(n2));
                        }
                    }
                }
            }
        });
    }

    public void forceRebindWithoutUI(final UserInfoData userInfoData, final int n2, int n3) {
        if (userInfoData == null) {
            return;
        }
        yw.startForciblyBind(n2);
        if (n3 == 0) {
            this.bindFailProcess(userInfoData);
            UserInfoResponse userInfoResponse = new UserInfoResponse();
            userInfoResponse.code = 0;
            userInfoResponse.message = this.getString(R.string.gsdk_account_force_rebind_cancel_no_ui);
            userInfoResponse.data = userInfoData;
            ((AccountManagementViewModel)ViewModelProviders.of((FragmentActivity)this).get(AccountManagementViewModel.class)).getForceRebindLiveData().setValue((Object)userInfoResponse);
        } else {
            re re2;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("flag", userInfoData.isBound ? 1 : 0);
            hashMap.put("bind_type", n2);
            hashMap.put("force", 1);
            hashMap.put("user_type", userInfoData.userType);
            hashMap.put("user_id", userInfoData.userId);
            hashMap.put("token", userInfoData.token);
            if (n2 == 5 && null != SdkCoreData.getInstance().getConfig() && SdkCoreData.getInstance().getConfig().getChannelOp().equals("bsdkintl") && (re2 = rw.getService(re.class)) != null) {
                re2.googleSignOut();
            }
            final long l2 = System.currentTimeMillis();
            this.qp.startForceReBind(hashMap);
            this.qp.getForceRebindData().observe((LifecycleOwner)this, (Observer)new Observer<Resource<UserInfoResponse>>(){

                public void onChanged(@Nullable Resource<UserInfoResponse> resource) {
                    if (resource != null) {
                        switch (resource.status) {
                            case SUCCESS: {
                                UserInfoResponse userInfoResponse = (UserInfoResponse)resource.data;
                                if (userInfoResponse == null) {
                                    return;
                                }
                                if (userInfoResponse.isSuccess()) {
                                    long l22 = System.currentTimeMillis();
                                    if (userInfoResponse.data != null) {
                                        userInfoResponse.data.ttUserId = AccountManagementActivity.this.findPuidForforceReind(n2, userInfoResponse.data);
                                        userInfoResponse.data.isScLogin = 0;
                                    }
                                    vr.getInstance().setTTUserInfo(vr.getInstance().adapt(userInfoResponse.data));
                                    new xb().saveLoginAccount(userInfoResponse.data);
                                    AccountManagementActivity.this.mCurrentUserInfoData = userInfoResponse.data;
                                    ((AccountManagementViewModel)ViewModelProviders.of((FragmentActivity)AccountManagementActivity.this).get(AccountManagementViewModel.class)).getForceRebindLiveData().setValue((Object)userInfoResponse);
                                    awa.a((String)"is_guest_entrance", (boolean)false, (Context)SdkCoreData.getInstance().getAppContext());
                                    if (userInfoData != null) {
                                        if (userInfoData.userType == 1) {
                                            ze.authBindSuccessMonitor(userInfoData.userId, zc.getPlatformNameByUserType(n2), true, l22 - l2);
                                        } else {
                                            ze.authBindSuccessMonitor(userInfoData.userId, zc.getPlatformNameByUserType(n2), false, l22 - l2);
                                        }
                                    }
                                    awa.a((String)"is_guest_entrance", (boolean)false, (Context)SdkCoreData.getInstance().getAppContext());
                                    break;
                                }
                                AccountManagementActivity.this.af();
                                AccountManagementActivity.this.bindFailProcess(userInfoData);
                                ((AccountManagementViewModel)ViewModelProviders.of((FragmentActivity)AccountManagementActivity.this).get(AccountManagementViewModel.class)).getForceRebindLiveData().setValue((Object)userInfoResponse);
                                if (userInfoData == null || userInfoResponse == null) break;
                                if (userInfoData.userType == 1) {
                                    ze.authBindFailMonitor(userInfoResponse.code, userInfoResponse.message, "bsdk_fail", userInfoData.userId, zc.getPlatformNameByUserType(n2), true);
                                    break;
                                }
                                ze.authBindFailMonitor(userInfoResponse.code, userInfoResponse.message, "bsdk_fail", userInfoData.userId, zc.getPlatformNameByUserType(n2), false);
                                break;
                            }
                            case ERROR: {
                                AccountManagementActivity.this.af();
                                AccountManagementActivity.this.bindFailProcess(userInfoData);
                                ((AccountManagementViewModel)ViewModelProviders.of((FragmentActivity)AccountManagementActivity.this).get(AccountManagementViewModel.class)).getForceRebindLiveData().setValue((Object)xl.failWithNetWorkError());
                                if (userInfoData == null) break;
                                if (userInfoData.userType == 1) {
                                    ze.authBindFailMonitor(-3000, resource.message, "bsdk_fail", userInfoData.userId, zc.getPlatformNameByUserType(n2), true);
                                    break;
                                }
                                ze.authBindFailMonitor(-3000, resource.message, "bsdk_fail", userInfoData.userId, zc.getPlatformNameByUserType(n2), false);
                            }
                        }
                    }
                }
            });
        }
    }

    private void af() {
        re re2;
        if (null != SdkCoreData.getInstance().getConfig() && SdkCoreData.getInstance().getConfig().getChannelOp().equals("bsdkintl") && (re2 = rw.getService(re.class)) != null) {
            re2.googleSignOut();
        }
    }

    protected void onActivityResult(int n2, int n3, @Nullable Intent intent) {
        super.onActivityResult(n2, n3, intent);
        vq.provideAuthorizeService().onActivityResult(n2, n3, intent);
    }

    private int getType() {
        if (this.ae()) {
            return 7;
        }
        return 3;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        rf rf2 = rw.getService(rf.class);
        if (rf2 != null) {
            rf2.onDestroy();
        }
    }

    public void bindFailProcess(final UserInfoData userInfoData) {
        gL = iq.createBDAccountApi((Context)this);
        gL.logout("user_logout", null, new ec<eg>(){

            @Override
            public void onResponse(eg eg2) {
                if (eg2 != null) {
                    if (userInfoData != null && userInfoData.ttUserId != 0L) {
                        qq = userInfoData;
                        xo.startSwithAccount(userInfoData.ttUserId, new xo.a(){

                            @Override
                            public void onResult(Resource<TTSwitchAccountResponse> resource) {
                                AccountManagementActivity.this.a((Resource<TTSwitchAccountResponse>)resource);
                            }
                        });
                    } else if (!eg2.success) {
                        AccountManagementActivity.this.c(userInfoData);
                    } else {
                        new xb().saveLoginAccount(userInfoData);
                    }
                }
            }
        });
    }

    private void c(final UserInfoData userInfoData) {
        final azs azs2 = azr.IM().IN().IK();
        AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                if (null == azs2 || userInfoData == null) {
                    return;
                }
                azs2.a(userInfoData);
                awa.a((String)"is_auto_login", (boolean)false, (Context)SdkCoreData.getInstance().getAppContext());
            }
        });
    }

    public boolean isUnBindCurrentAccount(int n2, UserInfoData userInfoData) {
        TTUserInfo tTUserInfo;
        if (!this.e(userInfoData)) {
            return true;
        }
        boolean bl2 = true;
        if (userInfoData != null && (tTUserInfo = vr.getInstance().adapt(userInfoData)) != null && !tTUserInfo.getConnect_infos().isEmpty()) {
            for (int i2 = 0; i2 < tTUserInfo.getConnect_infos().size(); ++i2) {
                if (((TTBindInfo)tTUserInfo.getConnect_infos().get((int)i2)).userId != userInfoData.ttUserId || ((TTBindInfo)tTUserInfo.getConnect_infos().get((int)i2)).user_type == n2) continue;
                bl2 = false;
                break;
            }
        }
        return bl2;
    }

    public void unbindCurrentProcess(final UserInfoData userInfoData) {
        gL = iq.createBDAccountApi((Context)this);
        gL.logout("user_logout", null, new ec<eg>(){

            @Override
            public void onResponse(eg eg2) {
                TTUserInfo tTUserInfo;
                if (eg2 != null && (tTUserInfo = vr.getInstance().adapt(userInfoData)) != null) {
                    if (AccountManagementActivity.this.d(userInfoData)) {
                        if (!eg2.success) {
                            AccountManagementActivity.this.c(userInfoData);
                        } else {
                            new xb().saveLoginAccount(userInfoData);
                        }
                    } else {
                        userInfoData.ttUserId = AccountManagementActivity.this.f(userInfoData);
                        qq = userInfoData;
                        xo.startSwithAccount(userInfoData.ttUserId, new xo.a(){

                            @Override
                            public void onResult(Resource<TTSwitchAccountResponse> resource) {
                                AccountManagementActivity.this.a((Resource<TTSwitchAccountResponse>)resource);
                            }
                        });
                    }
                }
            }
        });
    }

    private boolean d(UserInfoData userInfoData) {
        if (userInfoData == null || userInfoData.connect_infos == null || userInfoData.connect_infos.isEmpty()) {
            return true;
        }
        if (userInfoData.userType == 99) {
            return false;
        }
        for (int i2 = 0; i2 < userInfoData.connect_infos.size(); ++i2) {
            if (((ConnectInfoData)userInfoData.connect_infos.get((int)i2)).user_type == 1) continue;
            return false;
        }
        return true;
    }

    private boolean e(UserInfoData userInfoData) {
        if (userInfoData == null || userInfoData.connect_infos == null || userInfoData.connect_infos.isEmpty()) {
            return false;
        }
        for (int i2 = 0; i2 < userInfoData.connect_infos.size(); ++i2) {
            if (((ConnectInfoData)userInfoData.connect_infos.get((int)i2)).user_type == 1) continue;
            return true;
        }
        return false;
    }

    public void findBackCurrentPassportUid(UserInfoData userInfoData) {
        if (this.e(userInfoData) && this.mCurrentUserInfoData != null) {
            if (userInfoData.userId == this.mCurrentUserInfoData.userId && userInfoData.ttUserId == 0L) {
                userInfoData.ttUserId = this.mCurrentUserInfoData.ttUserId;
            }
        } else {
            return;
        }
    }

    private long f(UserInfoData userInfoData) {
        if (userInfoData == null || !this.e(userInfoData)) {
            return 0L;
        }
        for (int i2 = userInfoData.connect_infos.size() - 1; i2 >= 0; --i2) {
            if (((ConnectInfoData)userInfoData.connect_infos.get((int)i2)).puid == 0L) continue;
            return ((ConnectInfoData)userInfoData.connect_infos.get((int)i2)).puid;
        }
        return 0L;
    }

    public long findPuidForforceReind(int n2, UserInfoData userInfoData) {
        if (userInfoData == null || userInfoData.connect_infos == null || userInfoData.connect_infos.isEmpty()) {
            return 0L;
        }
        for (int i2 = 0; i2 < userInfoData.connect_infos.size(); ++i2) {
            ConnectInfoData connectInfoData = (ConnectInfoData)userInfoData.connect_infos.get(i2);
            if (connectInfoData.user_type != n2) continue;
            return connectInfoData.puid;
        }
        return 0L;
    }

    private void a(Resource<TTSwitchAccountResponse> resource) {
        if (resource != null) {
            switch (resource.status) {
                case SUCCESS: {
                    TTSwitchAccountResponse tTSwitchAccountResponse = (TTSwitchAccountResponse)resource.data;
                    if (tTSwitchAccountResponse != null) {
                        if (tTSwitchAccountResponse.message.equalsIgnoreCase(pt)) {
                            new xb().saveLoginAccount(qq);
                            this.mCurrentUserInfoData = qq;
                            break;
                        }
                        this.c(qq);
                        this.mCurrentUserInfoData = null;
                        break;
                    }
                    this.c(qq);
                    this.mCurrentUserInfoData = null;
                    break;
                }
            }
        }
    }

    public boolean canBindMore() {
        int n2 = bae.IU().Jp() != 0 ? bae.IU().Jp() : vp.a.sort.size();
        int n3 = 0;
        if (this.mCurrentUserInfoData != null) {
            for (ConnectInfoData connectInfoData : this.mCurrentUserInfoData.connect_infos) {
                if (connectInfoData.user_type == 1) continue;
                ++n3;
            }
        }
        return n2 > n3;
    }

    static {
        qs = null;
    }
}

