/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.sdk.module.account;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import com.bytedance.ttgame.framework.module.callback.ICallback;
import com.bytedance.ttgame.sdk.module.account.accountmanage.ui.AccountManagementActivity;
import com.bytedance.ttgame.sdk.module.account.api.ChainPermissionResponse;
import com.bytedance.ttgame.sdk.module.account.api.IAccountAgeGateCallback;
import com.bytedance.ttgame.sdk.module.account.api.IAgeGateCallback;
import com.bytedance.ttgame.sdk.module.account.api.ILoginStatusListener;
import com.bytedance.ttgame.sdk.module.account.api.ITTAccountService;
import com.bytedance.ttgame.sdk.module.account.api.LoginStatusEvent;
import com.bytedance.ttgame.sdk.module.account.api.SdkUserInfo;
import com.bytedance.ttgame.sdk.module.account.api.TTAccountConfig;
import com.bytedance.ttgame.sdk.module.account.api.TTSuccessionCodeInfo;
import com.bytedance.ttgame.sdk.module.account.api.TTSuccessionCodeResult;
import com.bytedance.ttgame.sdk.module.account.api.TTUserInfo;
import com.bytedance.ttgame.sdk.module.account.api.TTUserInfoResult;
import com.bytedance.ttgame.sdk.module.account.login.ui.ActivationCodeActivity;
import com.bytedance.ttgame.sdk.module.account.login.ui.LoginActivity;
import com.bytedance.ttgame.sdk.module.account.pojo.UserInfoData;
import com.bytedance.ttgame.sdk.module.core.internal.ChannelConstants;
import com.bytedance.ttgame.sdk.module.core.internal.GameSdkConfig;
import com.bytedance.ttgame.sdk.module.core.internal.SdkCoreData;
import com.google.gson.Gson;
import g.main.awa;
import g.main.bbk;
import g.toutiao.aar;
import g.toutiao.abc;
import g.toutiao.abe;
import g.toutiao.dv;
import g.toutiao.iq;
import g.toutiao.vp;
import g.toutiao.vr;
import g.toutiao.vv;
import g.toutiao.wc;
import g.toutiao.wd;
import g.toutiao.wo;
import g.toutiao.wr;
import g.toutiao.ws;
import g.toutiao.wu;
import g.toutiao.xj;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

@Keep
public class TTAccountService
implements ITTAccountService {
    ICallback<TTUserInfoResult> openPanelCallback;
    ICallback<TTUserInfoResult> openPanelWithOutUICallback;
    ICallback<TTUserInfoResult> openSwitchCallback;
    ICallback<TTUserInfoResult> openBindCallback;
    private List<WeakReference<ILoginStatusListener>> mLoginListenersRef = new ArrayList<WeakReference<ILoginStatusListener>>();
    private ICallback<TTUserInfoResult> authBindWithUICallback;
    private ICallback<TTUserInfoResult> unBindWithUICallback;
    private ICallback<TTUserInfoResult> forceRebindWithUICallback;
    private ICallback<TTUserInfoResult> connectCallback;
    private ICallback<SdkUserInfo> openActivateCodePanelCallback;

    public void init(TTAccountConfig tTAccountConfig) {
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        if (tTAccountConfig != null) {
            vp.a.sGoogleAppId = tTAccountConfig.getGoogleAppId();
            vp.a.sGoogleWebAppId = tTAccountConfig.getGoogleWebAppId();
            vp.a.sLineChannelId = tTAccountConfig.getLineChannelId();
            vp.a.facebookPlatFormId = tTAccountConfig.getFacebookPlatFormId();
            vp.a.linePlatFormId = tTAccountConfig.getLinePlatFormId();
            vp.a.googlePlatFormId = tTAccountConfig.getGooglePlatFormId();
            vp.a.twitterPlatFormId = tTAccountConfig.getTwitterPlatFormId();
            vp.a.sTwitterKey = tTAccountConfig.getTwitterKey();
            vp.a.sTwitterSecret = tTAccountConfig.getTwitterSecret();
            vp.a.sort = tTAccountConfig.getSort();
            vp.a.kakaoTalkPlatFormId = tTAccountConfig.getKakaoPlatFormId();
            vp.a.vkPlatFormId = tTAccountConfig.getVkPlatFormId();
            vp.a.facebook_friend_permission = tTAccountConfig.isFacebook_friend_permission();
        }
        if (bbk.isInMainProcess((Context)SdkCoreData.getInstance().getAppContext())) {
            aar.init(new wo(SdkCoreData.getInstance().getAppContext()));
            this.syncAccountInfoToPassport();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(ChannelConstants.getTokenHosts());
            abc abc2 = new abc().setUpdateInterval(600000L).setTokenSign(true).addHostList(arrayList);
            abe.initialize(SdkCoreData.getInstance().getAppContext(), abc2);
            wu.compatOldVersionVisitor();
        }
    }

    public void openLoginPanel(Context context, ICallback<TTUserInfoResult> iCallback) {
        context.startActivity(new Intent(context, LoginActivity.class));
        this.openPanelCallback = iCallback;
    }

    public boolean isLogin() {
        TTUserInfo tTUserInfo = vr.getInstance().getTTUserInfo();
        return null != tTUserInfo && 0L != tTUserInfo.getUserId();
    }

    public TTUserInfo getUserInfo() {
        return vr.getInstance().getTTUserInfo();
    }

    public void realNameVerify(Context context, int n2, ICallback<TTUserInfoResult> iCallback) {
    }

    public int openUserCenter(Context context, ICallback<TTUserInfoResult> iCallback) {
        return 0;
    }

    public void openSwitchAccountPanel(Context context, ICallback<TTUserInfoResult> iCallback) {
        this.openSwitchCallback = iCallback;
        Intent intent = new Intent(context, LoginActivity.class);
        intent.putExtra("is_switch", true);
        context.startActivity(intent);
    }

    public void registerLoginCallback(ILoginStatusListener iLoginStatusListener) {
        if (iLoginStatusListener == null) {
            return;
        }
        if (null == this.mLoginListenersRef) {
            this.mLoginListenersRef = new ArrayList<WeakReference<ILoginStatusListener>>();
        }
        this.mLoginListenersRef.add(new WeakReference<ILoginStatusListener>(iLoginStatusListener));
    }

    public void openVisitorBindPanel(Context context, ICallback<TTUserInfoResult> iCallback) {
        this.openBindCallback = iCallback;
        Intent intent = new Intent(context, AccountManagementActivity.class);
        context.startActivity(intent);
    }

    public void loginWithoutUI(Context context, int n2, ICallback<TTUserInfoResult> iCallback) {
        GameSdkConfig.setLoginType((String)"home");
        Intent intent = new Intent(context, LoginActivity.class);
        intent.putExtra("is_without_ui", true);
        intent.putExtra("without_ui_type", n2);
        context.startActivity(intent);
        this.openPanelWithOutUICallback = iCallback;
    }

    public void createVisitor(Activity activity, ICallback<TTUserInfoResult> iCallback) {
        GameSdkConfig.setLoginType((String)"home");
        Intent intent = new Intent((Context)activity, LoginActivity.class);
        intent.putExtra("is_without_ui", true);
        intent.putExtra("without_ui_type", 1);
        intent.putExtra("is_create_visitor", true);
        activity.startActivity(intent);
        this.openPanelWithOutUICallback = iCallback;
    }

    public void getHistoryAccounts(ICallback<List<UserInfoData>> iCallback) {
        vv vv2 = new vv();
        vv2.getAccountList(iCallback);
    }

    public void deleteHistoryAccount(UserInfoData userInfoData, ICallback<Boolean> iCallback) {
        vv vv2 = new vv();
        vv2.deleteAccount(userInfoData, iCallback);
    }

    public void switchAccountWithoutUI(UserInfoData userInfoData, ICallback<TTUserInfoResult> iCallback) {
        vv vv2 = new vv();
        vv2.switchAccount(userInfoData, iCallback);
    }

    public boolean isAutoLogin() {
        if (SdkCoreData.getInstance().getAppContext() != null) {
            return awa.a((String)"is_auto_login", (Context)SdkCoreData.getInstance().getAppContext(), (boolean)false);
        }
        return false;
    }

    public void autoLoginWithoutUI(ICallback<TTUserInfoResult> iCallback) {
        GameSdkConfig.setLoginType((String)"auto");
        vv vv2 = new vv();
        vv2.autoLoginWithoutUI(iCallback, false);
    }

    public void autoLoginWithPoorNetwork(ICallback<TTUserInfoResult> iCallback) {
        GameSdkConfig.setLoginType((String)"auto");
        vv vv2 = new vv();
        vv2.autoLoginWithoutUI(iCallback, true);
    }

    public void authBindWithoutUI(Context context, int n2, ICallback<TTUserInfoResult> iCallback) {
        this.authBindWithUICallback = iCallback;
        Intent intent = new Intent(context, AccountManagementActivity.class);
        intent.putExtra("is_without_ui", true);
        intent.putExtra("without_ui_type", n2);
        intent.putExtra("is_in_bind_process", true);
        context.startActivity(intent);
    }

    public void unBindWithoutUI(Context context, int n2, ICallback<TTUserInfoResult> iCallback) {
        this.unBindWithUICallback = iCallback;
        Intent intent = new Intent(context, AccountManagementActivity.class);
        intent.putExtra("is_without_ui", true);
        intent.putExtra("without_ui_unbind_type", n2);
        intent.putExtra("is_in_bind_process", false);
        context.startActivity(intent);
    }

    public void createSuccessionCode(String string2, ICallback<TTSuccessionCodeResult> iCallback) {
        vv vv2 = new vv();
        vv2.createSuccessionCode(string2, iCallback);
    }

    public void loginNoUIWithSuccessionCode(Activity activity, @Nullable TTSuccessionCodeInfo tTSuccessionCodeInfo, ICallback<TTUserInfoResult> iCallback) {
        GameSdkConfig.setLoginType((String)"home");
        vv vv2 = new vv();
        vv2.loginNoUIWithSuccessionCode(activity, tTSuccessionCodeInfo, true, iCallback);
    }

    public void forceRebindWithoutUI(Context context, int n2, int n3, ICallback<TTUserInfoResult> iCallback) {
        this.forceRebindWithUICallback = iCallback;
        Intent intent = new Intent(context, AccountManagementActivity.class);
        intent.putExtra("is_without_ui", true);
        intent.putExtra("without_ui_force_rebind_type", n2);
        intent.putExtra("without_ui_force_rebind", n3);
        intent.putExtra("is_in_rebind_process", true);
        context.startActivity(intent);
    }

    public void querySuccessionCode(ICallback<TTSuccessionCodeResult> iCallback) {
        vv vv2 = new vv();
        vv2.querySuccessionCode(iCallback);
    }

    public void changeSuccessionCode(Activity activity, String string2, ICallback<TTSuccessionCodeResult> iCallback) {
        vv vv2 = new vv();
        vv2.changeSuccessionCode(activity, string2, iCallback);
    }

    public void lastAccountLogin(ICallback<TTUserInfoResult> iCallback) {
        ws.getInstance().lasterAccountLogin(iCallback);
    }

    public void connectAccount(Activity activity, int n2, ICallback<TTUserInfoResult> iCallback) {
        this.connectCallback = iCallback;
        Intent intent = new Intent((Context)activity, LoginActivity.class);
        intent.putExtra("is_connect_account", true);
        intent.putExtra("connect_auth_type", n2);
        activity.startActivity(intent);
    }

    @Subscribe
    public void onEvent(LoginStatusEvent loginStatusEvent) {
        if (null == loginStatusEvent) {
            return;
        }
        this.notifyLogined(loginStatusEvent.getUserInfo());
        switch (loginStatusEvent.getEventType()) {
            case 1: {
                if (this.openPanelCallback == null) {
                    return;
                }
                if (loginStatusEvent.getUserInfo() != null && loginStatusEvent.getUserInfo().data != null && loginStatusEvent.getUserInfo().code == 0) {
                    this.openPanelCallback.onSuccess((Object)loginStatusEvent.getUserInfo());
                } else {
                    this.openPanelCallback.onFailed((Object)loginStatusEvent.getUserInfo());
                }
                this.openPanelCallback = null;
                break;
            }
            case 2: {
                if (this.openSwitchCallback == null) {
                    return;
                }
                if (loginStatusEvent.getUserInfo() != null && loginStatusEvent.getUserInfo().data != null && loginStatusEvent.getUserInfo().code == 0) {
                    this.openSwitchCallback.onSuccess((Object)loginStatusEvent.getUserInfo());
                } else {
                    this.openSwitchCallback.onFailed((Object)loginStatusEvent.getUserInfo());
                }
                this.openSwitchCallback = null;
                break;
            }
            case 3: {
                if (this.openBindCallback == null) {
                    return;
                }
                if (loginStatusEvent.getUserInfo() != null && loginStatusEvent.getUserInfo().data != null && loginStatusEvent.getUserInfo().code == 0) {
                    this.openBindCallback.onSuccess((Object)loginStatusEvent.getUserInfo());
                } else {
                    this.openBindCallback.onFailed((Object)loginStatusEvent.getUserInfo());
                }
                if (vp.a.multiBindStatus) break;
                this.openBindCallback = null;
                break;
            }
            case 6: {
                if (this.openPanelWithOutUICallback == null) {
                    return;
                }
                if (loginStatusEvent.getUserInfo() != null && loginStatusEvent.getUserInfo().data != null && loginStatusEvent.getUserInfo().code == 0) {
                    this.openPanelWithOutUICallback.onSuccess((Object)loginStatusEvent.getUserInfo());
                } else {
                    this.openPanelWithOutUICallback.onFailed((Object)loginStatusEvent.getUserInfo());
                }
                this.openPanelWithOutUICallback = null;
                break;
            }
            case 7: {
                if (this.authBindWithUICallback == null) {
                    return;
                }
                if (loginStatusEvent.getUserInfo() != null && loginStatusEvent.getUserInfo().data != null && loginStatusEvent.getUserInfo().code == 0) {
                    this.authBindWithUICallback.onSuccess((Object)loginStatusEvent.getUserInfo());
                } else {
                    this.authBindWithUICallback.onFailed((Object)loginStatusEvent.getUserInfo());
                }
                this.authBindWithUICallback = null;
                break;
            }
            case 10: {
                if (this.unBindWithUICallback == null) {
                    return;
                }
                if (loginStatusEvent.getUserInfo() != null && loginStatusEvent.getUserInfo().data != null && loginStatusEvent.getUserInfo().code == 0) {
                    this.unBindWithUICallback.onSuccess((Object)loginStatusEvent.getUserInfo());
                } else {
                    this.unBindWithUICallback.onFailed((Object)loginStatusEvent.getUserInfo());
                }
                this.unBindWithUICallback = null;
                break;
            }
            case 11: {
                if (this.forceRebindWithUICallback == null) {
                    return;
                }
                if (loginStatusEvent.getUserInfo() != null && loginStatusEvent.getUserInfo().data != null && loginStatusEvent.getUserInfo().code == 0) {
                    this.forceRebindWithUICallback.onSuccess((Object)loginStatusEvent.getUserInfo());
                } else {
                    this.forceRebindWithUICallback.onFailed((Object)loginStatusEvent.getUserInfo());
                }
                this.forceRebindWithUICallback = null;
                break;
            }
            case 8: {
                if (this.connectCallback == null) {
                    return;
                }
                if (loginStatusEvent.getUserInfo() != null && loginStatusEvent.getUserInfo().data != null && loginStatusEvent.getUserInfo().code == 0) {
                    this.connectCallback.onSuccess((Object)loginStatusEvent.getUserInfo());
                } else {
                    this.connectCallback.onFailed((Object)loginStatusEvent.getUserInfo());
                }
                this.connectCallback = null;
                break;
            }
        }
    }

    @Subscribe
    public void onEvent(SdkUserInfo sdkUserInfo) {
        if (this.openActivateCodePanelCallback != null) {
            if (sdkUserInfo.getCode() == 0) {
                this.openActivateCodePanelCallback.onSuccess((Object)sdkUserInfo);
            } else {
                this.openActivateCodePanelCallback.onFailed((Object)sdkUserInfo);
            }
        }
    }

    private void notifyLogined(TTUserInfoResult tTUserInfoResult) {
        if (null != this.mLoginListenersRef && this.mLoginListenersRef.size() > 0) {
            for (int i2 = 0; i2 < this.mLoginListenersRef.size(); ++i2) {
                ILoginStatusListener iLoginStatusListener;
                WeakReference<ILoginStatusListener> weakReference = this.mLoginListenersRef.get(i2);
                if (null == weakReference || null == (iLoginStatusListener = (ILoginStatusListener)weakReference.get())) continue;
                try {
                    iLoginStatusListener.onLogin(null, tTUserInfoResult);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public boolean isFirstLogin() {
        if (SdkCoreData.getInstance().getAppContext() != null) {
            boolean bl2 = awa.a((String)"is_first_login", (Context)SdkCoreData.getInstance().getAppContext(), (boolean)true);
            awa.a((String)"is_first_login", (boolean)false, (Context)SdkCoreData.getInstance().getAppContext());
            return bl2;
        }
        return false;
    }

    private void syncAccountInfoToPassport() {
        boolean bl2 = awa.a((String)"has_sync_accountinfo_to_passport", (Context)SdkCoreData.getInstance().getAppContext(), (boolean)false);
        if (!bl2) {
            boolean bl3 = this.isAutoLogin();
            if (bl3) {
                dv dv2 = iq.instance(SdkCoreData.getInstance().getAppContext());
                dv2.setLogin(true);
                dv2.saveData();
            }
            awa.a((String)"has_sync_accountinfo_to_passport", (boolean)true, (Context)SdkCoreData.getInstance().getAppContext());
        }
    }

    public void setupFacebookAutoEnabled(boolean bl2) {
        xj.handleFacebookDelaySettings(bl2);
    }

    public void openActivationCodePanel(Context context, Map<String, Object> map, ICallback<SdkUserInfo> iCallback) {
        this.openActivateCodePanelCallback = iCallback;
        Intent intent = new Intent(context, ActivationCodeActivity.class);
        intent.putExtra("params", new Gson().toJson(map));
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    public void hasOpenFriendChainPermission(int n2, ICallback<ChainPermissionResponse> iCallback) {
        wr.hasOpenFriendChainPermission(n2, iCallback);
    }

    public boolean queryAgeGateStatus() {
        return wc.queryAgeGateNoUI();
    }

    public void modifyAgeGateStatus(boolean bl2) {
        wc.modifyAgeGateNoUI(bl2);
    }

    public void judgeAgeGate(IAccountAgeGateCallback iAccountAgeGateCallback) {
        wc.judgeAgeGateNoUI(iAccountAgeGateCallback);
    }

    public void ageGate(Activity activity, IAgeGateCallback iAgeGateCallback) {
        wd.ageGateWithUI(activity, iAgeGateCallback);
    }
}

