/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.module.pay;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bytedance.ttgame.framework.module.callback.ICallback;
import com.bytedance.ttgame.framework.module.spi.IReleasable;
import com.bytedance.ttgame.module.pay.api.I18nPayInfo;
import com.bytedance.ttgame.module.pay.api.IPayService;
import com.bytedance.ttgame.module.pay.api.PayCallback;
import com.bytedance.ttgame.module.pay.api.PayConfig;
import com.bytedance.ttgame.module.pay.api.PayInfo;
import com.bytedance.ttgame.module.pay.api.PayResult;
import com.bytedance.ttgame.module.pay.api.ProductList;
import g.toutiao.vl;
import java.util.List;
import timber.log.Timber;

public class PayService
implements IReleasable,
IPayService {
    private volatile boolean mInited;
    private vl mPayManager;
    private ICallback<PayResult> mExtraCallback;

    @Override
    public void init(Context context, PayConfig payConfig) {
        if (payConfig == null || TextUtils.isEmpty((CharSequence)payConfig.getIapKey())) {
            throw new IllegalArgumentException("payConfig = null || payConfig.getIapKey() = null.");
        }
        if (!this.mInited) {
            Timber.tag((String)"{PayService}").v("====== init ====== ", new Object[0]);
            this.mPayManager = new vl(context, payConfig);
            if (this.mExtraCallback != null) {
                this.mPayManager.setOnExtraPayCallback(this.mExtraCallback);
            }
            this.mInited = true;
        }
    }

    @Override
    public void pay(Context context, PayInfo payInfo, ICallback<PayResult> iCallback) {
        if (context == null || payInfo == null) {
            throw new IllegalArgumentException("context = null || payInfo = null.");
        }
        this.checkInited("pay");
        if (this.mInited && payInfo instanceof I18nPayInfo) {
            Timber.tag((String)"{PayService}").v("==== pay ====", new Object[0]);
            this.mPayManager.pay((Activity)context, (I18nPayInfo)payInfo, iCallback);
        }
    }

    @Override
    public void queryProductDetails(List<String> list, @Nullable ICallback<ProductList> iCallback) {
        this.checkInited("queryProductDetails");
        if (this.mInited) {
            this.mPayManager.queryProductDetails(list, iCallback);
        }
    }

    @Override
    public void querySubscriptionDetails(List<String> list, @Nullable ICallback<ProductList> iCallback) {
        this.checkInited("querySubscriptionDetails");
        if (this.mInited) {
            this.mPayManager.querySubscriptionDetails(list, iCallback);
        }
    }

    @Override
    public void setExtraPayCallback(ICallback<PayResult> iCallback) {
        this.mExtraCallback = iCallback;
        if (this.mPayManager != null) {
            this.mPayManager.setOnExtraPayCallback(this.mExtraCallback);
        }
    }

    @Override
    public void queryPreregisterAwards(PayCallback<List<String>> payCallback) {
        this.checkInited("queryPreregisterAwards");
        if (this.mInited) {
            this.mPayManager.queryPreregisterAwards(payCallback);
        }
    }

    @Override
    public void receivePreregisterAwards(I18nPayInfo i18nPayInfo, ICallback<PayResult> iCallback) {
        this.checkInited("receivePreregisterAwards");
        if (this.mInited) {
            this.mPayManager.receivePreregisterAwards(i18nPayInfo, iCallback);
        }
    }

    public void onRelease() {
        this.releaseInternal();
    }

    public void releaseInternal() {
        Timber.tag((String)"{PayService}").v("====== release ====== ", new Object[0]);
        this.mInited = false;
        vl vl2 = this.mPayManager;
        this.mPayManager = null;
        if (vl2 != null) {
            vl2.release();
        }
    }

    private void checkInited(String string2) {
        if (!this.mInited) {
            Timber.tag((String)"{PayService}").e("you must call initWithConfig() before " + string2, new Object[0]);
        }
    }
}

