/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttgame.channel;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.widget.Toast;
import com.bytedance.ttgame.channel.BaseChannel;
import com.bytedance.ttgame.channel.R;
import com.bytedance.ttgame.core.SdkEngine;
import com.bytedance.ttgame.core.SdkEngineCallback;
import com.bytedance.ttgame.framework.module.applog.AppLogContext;
import com.bytedance.ttgame.framework.module.callback.ICallback;
import com.bytedance.ttgame.framework.module.spi.IService;
import com.bytedance.ttgame.framework.module.spi.ServiceManager;
import com.bytedance.ttgame.module.pay.api.IPayService;
import com.bytedance.ttgame.module.pay.api.PayConfig;
import com.bytedance.ttgame.module.webview.WebViewService;
import com.bytedance.ttgame.module.webview.api.IWebViewService;
import com.bytedance.ttgame.rocketapi.Rocket;
import com.bytedance.ttgame.rocketapi.account.AgeGateResult;
import com.bytedance.ttgame.rocketapi.account.ChainPermissionResult;
import com.bytedance.ttgame.rocketapi.account.ExtraBindData;
import com.bytedance.ttgame.rocketapi.account.ExtraData;
import com.bytedance.ttgame.rocketapi.account.IAccountCallback;
import com.bytedance.ttgame.rocketapi.account.IAgeGateCallback;
import com.bytedance.ttgame.rocketapi.account.ISwitchCallback;
import com.bytedance.ttgame.rocketapi.account.PeerNetworkUserInfoResult;
import com.bytedance.ttgame.rocketapi.account.SuccessionCodeInfo;
import com.bytedance.ttgame.rocketapi.account.SuccessionCodeResult;
import com.bytedance.ttgame.rocketapi.account.UserInfoResult;
import com.bytedance.ttgame.rocketapi.callback.InitCallback;
import com.bytedance.ttgame.rocketapi.callback.InitResult;
import com.bytedance.ttgame.rocketapi.minors.IMinorsCallback;
import com.bytedance.ttgame.rocketapi.pay.IPayCallback;
import com.bytedance.ttgame.rocketapi.pay.IQueryProductsCallback;
import com.bytedance.ttgame.rocketapi.pay.QueryGoodsParams;
import com.bytedance.ttgame.rocketapi.pay.RocketGoods;
import com.bytedance.ttgame.rocketapi.pay.RocketPayInfo;
import com.bytedance.ttgame.rocketapi.pay.RocketPayResult;
import com.bytedance.ttgame.rocketapi.utils.ProcessUtils;
import com.bytedance.ttgame.sdk.module.account.AccountConfig;
import com.bytedance.ttgame.sdk.module.account.api.ChainPermissionResponse;
import com.bytedance.ttgame.sdk.module.account.api.ITTAccountService;
import com.bytedance.ttgame.sdk.module.account.api.TTAccountConfig;
import com.bytedance.ttgame.sdk.module.account.api.TTUserInfo;
import com.bytedance.ttgame.sdk.module.account.pojo.ConnectInfoData;
import com.bytedance.ttgame.sdk.module.account.pojo.UserInfoData;
import com.bytedance.ttgame.sdk.module.core.internal.SdkCoreData;
import com.google.gson.Gson;
import g.main.aop;
import g.main.auu;
import g.main.auy;
import g.main.avx;
import g.main.awa;
import g.main.awr;
import g.main.ayn;
import g.main.azm;
import g.main.bae;
import g.main.bay;
import g.toutiao.re;
import g.toutiao.rw;
import g.toutiao.uu;
import g.toutiao.uv;
import g.toutiao.uw;
import g.toutiao.vb;
import g.toutiao.zc;
import java.util.ArrayList;
import java.util.List;
import timber.log.Timber;

public class Channel
extends BaseChannel<uu> {
    private vb mPayDelegate;
    private uv loginDelegate;
    private boolean hasReqeustCloud;
    private boolean hasInitOnHome;
    private Handler mHandler = new Handler();
    Runnable queryProducts = new Runnable(){

        @Override
        public void run() {
            if (Channel.this.mPayDelegate != null) {
                Channel.this.mPayDelegate.fetchProducts();
            }
        }
    };

    public void init(Context context, final InitCallback initCallback, IService ... iServiceArray) {
        final InitCallback initCallback2 = new InitCallback(){

            public void onSuccess(InitResult initResult) {
                initCallback.onSuccess(initResult);
                if (!Channel.this.hasReqeustCloud && Channel.this.hasInitOnHome) {
                    Channel.this.hasReqeustCloud = true;
                    bae.IU().IW();
                }
            }

            public void onFailed(int n2, String string2) {
                initCallback.onFailed(n2, string2);
                Channel.this.hasReqeustCloud = false;
                Channel.this.hasInitOnHome = false;
            }
        };
        if (sIsInitialized) {
            Timber.tag((String)"gsdk_init").i("gsdk has already been initialized! retry get init result", new Object[0]);
            if (!ProcessUtils.isInMainProcess((Context)context)) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)this.getDeviceID(context))) {
                initCallback2.onSuccess(auu.iY((String)this.getDeviceID(context)));
            } else {
                ICallback<SdkEngineCallback> iCallback = new ICallback<SdkEngineCallback>(){

                    public void a(@Nullable SdkEngineCallback sdkEngineCallback) {
                        if (sdkEngineCallback == null || initCallback2 == null || initCallback == null) {
                            return;
                        }
                        initCallback2.onSuccess(auu.iY((String)sdkEngineCallback.did));
                    }

                    public void b(@Nullable SdkEngineCallback sdkEngineCallback) {
                        if (sdkEngineCallback == null || initCallback == null) {
                            return;
                        }
                        initCallback2.onFailed(sdkEngineCallback.code, sdkEngineCallback.message);
                    }

                    public /* synthetic */ void onFailed(@Nullable Object object) {
                        this.b((SdkEngineCallback)object);
                    }

                    public /* synthetic */ void onSuccess(@Nullable Object object) {
                        this.a((SdkEngineCallback)object);
                    }
                };
                avx.baK.a(this.config.aWa, (ICallback)iCallback, true);
            }
            return;
        }
        super.init(context, initCallback2, iServiceArray);
        this.tryAddClientUUid();
        if (this.config == null || this.config.aWb == null) {
            return;
        }
        if (ProcessUtils.isInMainProcess((Context)context)) {
            Gson gson = new Gson();
            uu uu2 = (uu)gson.fromJson(gson.toJson((Object)this.config.aWb), uu.class);
            Channel.accountInit(uu2.getAccount());
            this.loginDelegate = new uv();
            Channel.initPay(context, uu2.getPay());
            this.mPayDelegate = new vb();
            azm azm2 = new azm(){

                public String IF() {
                    ITTAccountService iTTAccountService = (ITTAccountService)ServiceManager.get().getService(ITTAccountService.class);
                    TTUserInfo tTUserInfo = iTTAccountService.getUserInfo();
                    return tTUserInfo == null ? "" : zc.getPlatformNameByUserType(tTUserInfo.getUserType());
                }

                public String getUserId() {
                    ITTAccountService iTTAccountService = (ITTAccountService)ServiceManager.get().getService(ITTAccountService.class);
                    TTUserInfo tTUserInfo = iTTAccountService.getUserInfo();
                    return tTUserInfo == null ? "" : String.valueOf(tTUserInfo.getUserId());
                }
            };
            ayn.b((azm)azm2);
            WebViewService.Companion.a(azm2);
            awr.bcz.a(azm2);
            bay.c((azm)azm2);
        }
        if (this.initWraper != null) {
            this.initWraper.aXf = true;
            if (this.initWraper.aXe) {
                initCallback.onSuccess(new InitResult());
                if (!this.hasReqeustCloud && this.hasInitOnHome) {
                    this.hasReqeustCloud = true;
                    bae.IU().IW();
                }
            }
        }
    }

    private static void accountInit(AccountConfig accountConfig) {
        TTAccountConfig tTAccountConfig = new TTAccountConfig.Builder().setGoogleAppId(accountConfig.getGoogleAppId()).setGoogleWebAppId(accountConfig.getGoogleWebAppId()).setLineChannelId(accountConfig.getLineChannelId()).setGooglePlatFormId(accountConfig.getGooglePlatFormId()).setFacebookPlatFormId(accountConfig.getFacebookPlatFormId()).setKakaoPlatFormId(accountConfig.getKakaoPlatFormId()).setVkPlatFormId(accountConfig.getVkPlatFormId()).setLinePlatFormId(accountConfig.getLinePlatFormId()).setFacebook_friend_permission(accountConfig.isFacebook_friend_permission()).setSort(accountConfig.getSort()).setTwitterPlatFormId(accountConfig.getTwitterPlatFormId()).setTwitterKey(accountConfig.getTwitterKey()).setTwitterSecret(accountConfig.getTwitterSecret()).build();
        ((ITTAccountService)Rocket.getInstance().getComponent(ITTAccountService.class)).init(tTAccountConfig);
    }

    private static void initPay(Context context, PayConfig payConfig) {
        ((IPayService)Rocket.getInstance().getComponent(IPayService.class)).init(context, payConfig);
    }

    public void login(final Activity activity, final IAccountCallback<UserInfoResult> iAccountCallback) {
        super.login(activity, iAccountCallback);
        IAccountCallback<UserInfoResult> iAccountCallback2 = new IAccountCallback<UserInfoResult>(){

            public void onSuccess(@Nullable UserInfoResult userInfoResult) {
                iAccountCallback.onSuccess((Object)userInfoResult);
            }

            public void onFailed(@Nullable UserInfoResult userInfoResult) {
                iAccountCallback.onFailed((Object)userInfoResult);
                if (userInfoResult != null && userInfoResult.code != -3000 && activity != null) {
                    awa.a((String)"is_auto_login", (boolean)false, (Context)activity.getApplicationContext());
                }
            }
        };
        if (this.loginDelegate != null) {
            this.loginDelegate.login((Context)activity, iAccountCallback2);
        }
    }

    public int bindUser(Activity activity, IAccountCallback<UserInfoResult> iAccountCallback) {
        if (!this.isLogin() && activity != null) {
            return -1;
        }
        if (this.loginDelegate != null) {
            return this.loginDelegate.bindUser((Context)activity, iAccountCallback);
        }
        return -1;
    }

    public void switchLogin(final Activity activity, final ISwitchCallback<UserInfoResult> iSwitchCallback) {
        if (!this.isLogin() && activity != null) {
            Toast.makeText((Context)activity, (CharSequence)activity.getString(R.string.gsdk_pay_not_login), (int)0).show();
            return;
        }
        super.switchLogin(activity, iSwitchCallback);
        IAccountCallback<UserInfoResult> iAccountCallback = new IAccountCallback<UserInfoResult>(){

            public void onSuccess(@Nullable UserInfoResult userInfoResult) {
                if (null != iSwitchCallback) {
                    iSwitchCallback.onLogout((Object)userInfoResult);
                    if (Channel.this.loginDelegate != null) {
                        Channel.this.loginDelegate.switchLogin((Context)activity, (ISwitchCallback<UserInfoResult>)iSwitchCallback);
                    }
                }
            }

            public void onFailed(@Nullable UserInfoResult userInfoResult) {
                if (null != iSwitchCallback) {
                    iSwitchCallback.onLogout((Object)userInfoResult);
                }
            }
        };
        this.logout((Context)activity, iAccountCallback);
    }

    public void logout(Context context, IAccountCallback<UserInfoResult> iAccountCallback) {
        re re2;
        super.logout(context, iAccountCallback);
        if (null != SdkCoreData.getInstance().getConfig() && SdkCoreData.getInstance().getConfig().getChannelOp().equals("bsdkintl") && (re2 = rw.getService(re.class)) != null) {
            re2.googleSignOut();
        }
    }

    public boolean isLogin() {
        return this.loginDelegate != null && this.loginDelegate.isLogin();
    }

    public void pay(Activity activity, RocketPayInfo rocketPayInfo, IPayCallback<RocketPayResult> iPayCallback) {
        if (rocketPayInfo == null) {
            RocketPayResult rocketPayResult = RocketPayResult.newChannelErrorPayResult((int)-1, (String)"empty request");
            if (iPayCallback != null) {
                iPayCallback.onFailed((Object)rocketPayResult);
            }
            return;
        }
        if (this.mPayDelegate != null) {
            this.mPayDelegate.pay(activity, rocketPayInfo, iPayCallback);
        }
    }

    public void registerExtraPayCallback(IPayCallback<RocketPayResult> iPayCallback) {
        if (this.mPayDelegate != null) {
            this.mPayDelegate.registerExtraPayCallback(iPayCallback);
        }
    }

    public void queryGoods(Context context, QueryGoodsParams queryGoodsParams, IPayCallback<RocketGoods> iPayCallback) {
        if (this.mPayDelegate != null) {
            this.mPayDelegate.queryGoodsWithActivity(context, queryGoodsParams, iPayCallback);
        }
    }

    public void payOnSuccess(Activity activity, String string2, IPayCallback<RocketPayResult> iPayCallback) {
    }

    public void queryProducts(List<String> list, IQueryProductsCallback iQueryProductsCallback) {
        if (this.mPayDelegate != null) {
            this.mPayDelegate.queryProductDetails(list, iQueryProductsCallback);
        }
    }

    public void receivePreregisterAwards(Context context, RocketPayInfo rocketPayInfo, IPayCallback<RocketPayResult> iPayCallback) {
        if (this.mPayDelegate != null) {
            this.mPayDelegate.receivePreregisterAwards(context, rocketPayInfo, iPayCallback);
        }
    }

    public void changeLanguage(Context context, String string2) {
        SdkEngine.getInstance().changeLanguage(context, string2);
    }

    public <T> T getComponent(Class<T> clazz) {
        return (T)SdkEngine.getInstance().getComponent(clazz);
    }

    public void loginNoUI(Activity activity, int n2, IAccountCallback<UserInfoResult> iAccountCallback) {
        super.loginNoUI(activity, n2, iAccountCallback);
        if (this.loginDelegate != null) {
            this.loginDelegate.loginWithoutUI((Context)activity, n2, iAccountCallback);
        }
    }

    public void createVisitor(Activity activity, IAccountCallback<UserInfoResult> iAccountCallback) {
        super.createVisitor(activity, iAccountCallback);
        if (this.loginDelegate != null) {
            this.loginDelegate.createVisitor(activity, iAccountCallback);
        }
    }

    public void getHistoryAccount(final IAccountCallback<List<ExtraData>> iAccountCallback) {
        if (this.loginDelegate == null) {
            return;
        }
        this.loginDelegate.getHistoryAccounts(new ICallback<List<UserInfoData>>(){

            public void onSuccess(@Nullable List<UserInfoData> list) {
                if (null != iAccountCallback) {
                    iAccountCallback.onSuccess((Object)Channel.this.dataAdapter(list));
                }
            }

            public void onFailed(@Nullable List<UserInfoData> list) {
                if (null != iAccountCallback) {
                    iAccountCallback.onFailed((Object)Channel.this.dataAdapter(list));
                }
            }
        });
    }

    public void deleteHistoryAccount(long l2, final IAccountCallback<Boolean> iAccountCallback) {
        if (this.loginDelegate == null) {
            return;
        }
        this.loginDelegate.deleteHistoryAccount(l2, new ICallback<Boolean>(){

            public void onSuccess(@Nullable Boolean bl2) {
                if (null != iAccountCallback) {
                    iAccountCallback.onSuccess((Object)bl2);
                }
            }

            public void onFailed(@Nullable Boolean bl2) {
                if (null != iAccountCallback) {
                    iAccountCallback.onFailed((Object)bl2);
                }
            }
        });
    }

    public void switchAccountNoUI(long l2, final ISwitchCallback<UserInfoResult> iSwitchCallback) {
        super.switchAccountNoUI(l2, iSwitchCallback);
        if (null != iSwitchCallback && this.loginDelegate != null) {
            this.loginDelegate.switchAccount(l2, new IAccountCallback<UserInfoResult>(){

                public void onSuccess(@Nullable UserInfoResult userInfoResult) {
                    iSwitchCallback.onSuccess((Object)userInfoResult);
                }

                public void onFailed(@Nullable UserInfoResult userInfoResult) {
                    iSwitchCallback.onFailed((Object)userInfoResult);
                }
            });
        }
    }

    public boolean isCanAutoLoginNoUI() {
        return this.loginDelegate != null && this.loginDelegate.isAutoLogin();
    }

    public void autoLoginNoUI(IAccountCallback<UserInfoResult> iAccountCallback) {
        super.autoLoginNoUI(iAccountCallback);
        if (this.loginDelegate != null) {
            this.loginDelegate.autoLoginWithoutUI(iAccountCallback);
        }
    }

    public void autoLoginWithPoorNetwork(Activity activity, IAccountCallback<PeerNetworkUserInfoResult> iAccountCallback) {
        super.autoLoginWithPoorNetwork(activity, iAccountCallback);
        if (this.loginDelegate != null) {
            this.loginDelegate.autoLoginWithPoorNetwork(activity, iAccountCallback);
        }
    }

    public void authBindNoUI(Activity activity, int n2, IAccountCallback<UserInfoResult> iAccountCallback) {
        if (!this.isLogin() && SdkCoreData.getInstance().getAppContext() != null) {
            Toast.makeText((Context)SdkCoreData.getInstance().getAppContext(), (CharSequence)SdkCoreData.getInstance().getAppContext().getString(R.string.gsdk_pay_not_login), (int)0).show();
            return;
        }
        if (this.loginDelegate != null) {
            this.loginDelegate.authBind((Context)activity, n2, iAccountCallback);
        }
    }

    public void unBindNoUI(Activity activity, int n2, IAccountCallback<UserInfoResult> iAccountCallback) {
        if (!this.isLogin() && SdkCoreData.getInstance().getAppContext() != null) {
            Toast.makeText((Context)SdkCoreData.getInstance().getAppContext(), (CharSequence)SdkCoreData.getInstance().getAppContext().getString(R.string.gsdk_pay_not_login), (int)0).show();
            return;
        }
        if (this.loginDelegate != null) {
            this.loginDelegate.unBind((Context)activity, n2, iAccountCallback);
        }
    }

    public void createSuccessionCode(String string2, IAccountCallback<SuccessionCodeResult> iAccountCallback) {
        if (this.loginDelegate != null) {
            this.loginDelegate.createSuccessionCode(string2, iAccountCallback);
        }
    }

    public void loginNoUIWithSuccessionCode(Activity activity, SuccessionCodeInfo successionCodeInfo, IAccountCallback<UserInfoResult> iAccountCallback) {
        super.loginNoUIWithSuccessionCode(activity, successionCodeInfo, iAccountCallback);
        if (this.loginDelegate != null) {
            this.loginDelegate.loginNoUIWithSuccessionCode(activity, successionCodeInfo, iAccountCallback);
        }
    }

    public void querySuccessionCode(IAccountCallback<SuccessionCodeResult> iAccountCallback) {
        super.querySuccessionCode(iAccountCallback);
        if (this.loginDelegate != null) {
            this.loginDelegate.querySuccessionCode(iAccountCallback);
        }
    }

    public void changeSuccessionCode(Activity activity, String string2, IAccountCallback<SuccessionCodeResult> iAccountCallback) {
        super.changeSuccessionCode(activity, string2, iAccountCallback);
        if (this.loginDelegate != null) {
            this.loginDelegate.changeSuccessionCode(activity, string2, iAccountCallback);
        }
    }

    public void forceRebindNoUI(Activity activity, int n2, int n3, IAccountCallback<UserInfoResult> iAccountCallback) {
        if (this.loginDelegate != null) {
            this.loginDelegate.forceRebindNoUI((Context)activity, n2, n3, iAccountCallback);
        }
    }

    public void lastAccountLogin(IAccountCallback<UserInfoResult> iAccountCallback) {
        super.lastAccountLogin(iAccountCallback);
        if (this.loginDelegate != null) {
            this.loginDelegate.lastAccountLogin(iAccountCallback);
        }
    }

    public void connectAccount(Activity activity, int n2, IAccountCallback<UserInfoResult> iAccountCallback) {
        if (this.loginDelegate != null) {
            this.loginDelegate.connectAccount(activity, n2, iAccountCallback);
        }
    }

    private List<ExtraData> dataAdapter(List<UserInfoData> list) {
        if (null == list) {
            return null;
        }
        ArrayList<ExtraData> arrayList = new ArrayList<ExtraData>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ExtraData extraData = new ExtraData();
            UserInfoData userInfoData = list.get(i2);
            extraData.setAvatarUrl(userInfoData.avatarUrl);
            extraData.setUserId(userInfoData.userId);
            extraData.setBound(userInfoData.isBound);
            extraData.setLoginTime(userInfoData.loginTime);
            extraData.setTtUserId(userInfoData.ttUserId);
            extraData.setNickname(userInfoData.nickname);
            extraData.setHasPwd(userInfoData.hasPwd);
            extraData.setToken(userInfoData.token);
            extraData.setVerified(userInfoData.isVerified);
            extraData.setUserType(userInfoData.userType);
            if (userInfoData.connect_infos != null && !userInfoData.connect_infos.isEmpty()) {
                extraData.setI18nBindData(this.getI18nBindInfos(userInfoData.connect_infos));
            }
            arrayList.add(extraData);
        }
        return arrayList;
    }

    public void setMinorLimit(String string2, String string3, String string4, IMinorsCallback iMinorsCallback) {
        uw.setMinorLimit(string2, string3, string4, iMinorsCallback);
    }

    public void getMinorLimit(String string2, String string3, IMinorsCallback iMinorsCallback) {
        uw.getMinorLimit(string2, string3, iMinorsCallback);
    }

    public void onRelease() {
        if (this.mPayDelegate != null) {
            this.mPayDelegate.release();
        }
        if (this.mHandler != null && this.queryProducts != null) {
            this.mHandler.removeCallbacks(this.queryProducts);
        }
    }

    public void initOnHomeActivity(Context context) {
        if (((Activity)context).getIntent().getData() != null && auy.iZ((String)((Activity)context).getIntent().getData().getScheme())) {
            aop.A((Context)context, (String)((Activity)context).getIntent().getData().toString()).open();
        }
        this.hasInitOnHome = true;
        if (!this.hasReqeustCloud && !TextUtils.isEmpty((CharSequence)AppLogContext.getInstance().getServerDeviceId())) {
            this.hasReqeustCloud = true;
            bae.IU().IW();
        }
        if (this.mHandler != null && this.queryProducts != null) {
            this.mHandler.postDelayed(this.queryProducts, 2000L);
        }
        ((IWebViewService)ServiceManager.get().getService(IWebViewService.class)).initBridge();
    }

    public void onNewIntent(Activity activity, Intent intent) {
        super.onNewIntent(activity, intent);
    }

    public void setupFacebookAutoEnabled(boolean bl2) {
        this.loginDelegate.setupFacebookAutoEnabled(bl2);
    }

    public void verifyActivationCodeWithoutUI(String string2, IAccountCallback<UserInfoResult> iAccountCallback) {
        this.loginDelegate.verifyActivationCodeWithoutUI(string2, iAccountCallback);
    }

    private void tryAddClientUUid() {
        Timber.tag((String)"Channel").d("tryAddClientUUid -> ", new Object[0]);
        String string2 = bay.Kn();
        if (string2 == null) {
            bay.jN((String)bay.Ko());
        }
    }

    private List<ExtraBindData> getI18nBindInfos(List<ConnectInfoData> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<ExtraBindData> arrayList = new ArrayList<ExtraBindData>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ExtraBindData extraBindData = new ExtraBindData();
            extraBindData.user_type = list.get((int)i2).user_type;
            extraBindData.userId = list.get((int)i2).puid;
            extraBindData.nickname = list.get((int)i2).nickname;
            extraBindData.avatar_url = list.get((int)i2).avatar_url;
            arrayList.add(extraBindData);
        }
        return arrayList;
    }

    public void hasOpenFriendChainPermission(int n2, final ICallback<ChainPermissionResult> iCallback) {
        final ChainPermissionResult chainPermissionResult = new ChainPermissionResult();
        if (this.loginDelegate != null && !this.loginDelegate.isLogin()) {
            chainPermissionResult.code = -1;
            chainPermissionResult.message = "please login";
            iCallback.onFailed((Object)chainPermissionResult);
            return;
        }
        ITTAccountService iTTAccountService = (ITTAccountService)SdkEngine.getInstance().getComponent(ITTAccountService.class);
        ICallback<ChainPermissionResponse> iCallback2 = new ICallback<ChainPermissionResponse>(){

            public void onSuccess(@Nullable ChainPermissionResponse chainPermissionResponse) {
                if (chainPermissionResponse != null) {
                    chainPermissionResult.code = chainPermissionResponse.code;
                    chainPermissionResult.message = chainPermissionResponse.message;
                    if (chainPermissionResponse.data != null) {
                        chainPermissionResult.hasPermission = chainPermissionResponse.data.hasPermission;
                    }
                }
                iCallback.onSuccess((Object)chainPermissionResult);
            }

            public void onFailed(@Nullable ChainPermissionResponse chainPermissionResponse) {
                int n2 = -1;
                String string2 = "fail";
                if (chainPermissionResponse != null) {
                    n2 = chainPermissionResponse.code;
                    string2 = chainPermissionResponse.message;
                    if (chainPermissionResponse.data != null) {
                        chainPermissionResult.hasPermission = chainPermissionResponse.data.hasPermission;
                    }
                }
                chainPermissionResult.code = n2;
                chainPermissionResult.message = string2;
                iCallback.onFailed((Object)chainPermissionResult);
            }
        };
        iTTAccountService.hasOpenFriendChainPermission(n2, (ICallback)iCallback2);
    }

    public boolean queryAgeGateStatus() {
        if (this.loginDelegate != null) {
            return this.loginDelegate.queryAgeGateStatus();
        }
        return false;
    }

    public void modifyAgeGateStatus(boolean bl2) {
        if (this.loginDelegate != null) {
            this.loginDelegate.modifyAgeGateStatus(bl2);
        }
    }

    public void judgeAgeGate(IAccountCallback<AgeGateResult> iAccountCallback) {
        if (this.loginDelegate != null) {
            this.loginDelegate.judgeAgeGate(iAccountCallback);
        }
    }

    public void ageGate(Activity activity, IAgeGateCallback iAgeGateCallback) {
        if (this.loginDelegate != null) {
            this.loginDelegate.ageGate(activity, iAgeGateCallback);
        }
    }
}

