/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.BillingBroadcastManager;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientNativeCallback;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.BillingResults;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.PipoBillingFlowParams;
import com.android.billingclient.api.PriceChangeConfirmationListener;
import com.android.billingclient.api.PriceChangeFlowParams;
import com.android.billingclient.api.ProxyBillingActivity;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseApiResponseChecker;
import com.android.billingclient.api.PurchaseHistoryRecord;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.RewardLoadParams;
import com.android.billingclient.api.RewardResponseListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.android.billingclient.util.BillingHelper;
import com.android.vending.billing.IInAppBillingService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;

public class PipoPayBillingClientImpl
extends BillingClient {
    private static final String TAG = "BillingClient";
    private static final long i = 5000L;
    private static final long j = 30000L;
    private static final int k = 20;
    private int l = 0;
    private static final String m = "ITEM_ID_LIST";
    private static final int n = 10;
    private static final int o = 3;
    private final String p;
    private final Handler q = new Handler(Looper.getMainLooper());
    private final BillingBroadcastManager r;
    private final Context s;
    private final int t;
    private final int u;
    private IInAppBillingService v;
    private a w;
    private boolean x;
    private boolean y;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private final boolean D;
    private ExecutorService E;
    private final ResultReceiver F = new ResultReceiver(this.q){

        public void onReceiveResult(int n2, Bundle bundle) {
            PurchasesUpdatedListener purchasesUpdatedListener = PipoPayBillingClientImpl.this.r.getListener();
            if (purchasesUpdatedListener == null) {
                BillingHelper.logWarn((String)PipoPayBillingClientImpl.TAG, (String)"PurchasesUpdatedListener is null - no way to return the response.");
                return;
            }
            List list = BillingHelper.extractPurchases((Bundle)bundle);
            BillingResult billingResult = BillingResult.newBuilder().setResponseCode(n2).setDebugMessage(BillingHelper.getDebugMessageFromBundle((Bundle)bundle, (String)PipoPayBillingClientImpl.TAG)).build();
            purchasesUpdatedListener.onPurchasesUpdated(billingResult, list);
        }
    };

    @VisibleForTesting
    void setExecutorService(ExecutorService executorService) {
        this.E = executorService;
    }

    public static BillingClient newBillingClient(Context context, boolean bl2, @NonNull PurchasesUpdatedListener purchasesUpdatedListener) {
        return new PipoPayBillingClientImpl(context, 0, 0, bl2, purchasesUpdatedListener);
    }

    @UiThread
    PipoPayBillingClientImpl(@NonNull Context context, int n2, int n3, boolean bl2, @NonNull PurchasesUpdatedListener purchasesUpdatedListener) {
        this(context, n2, n3, bl2, purchasesUpdatedListener, "2.0.3");
    }

    private PipoPayBillingClientImpl(Activity activity, int n2, int n3, boolean bl2, String string2) {
        this(activity.getApplicationContext(), n2, n3, bl2, (PurchasesUpdatedListener)new BillingClientNativeCallback(), string2);
    }

    private PipoPayBillingClientImpl(@NonNull Context context, int n2, int n3, boolean bl2, @NonNull PurchasesUpdatedListener purchasesUpdatedListener, String string2) {
        this.s = context.getApplicationContext();
        this.t = n2;
        this.u = n3;
        this.D = bl2;
        this.r = new BillingBroadcastManager(this.s, purchasesUpdatedListener);
        this.p = string2;
    }

    public BillingResult isFeatureSupported(String string2) {
        if (!this.isReady()) {
            return BillingResults.SERVICE_DISCONNECTED;
        }
        switch (string2) {
            case "subscriptions": {
                return this.x ? BillingResults.OK : BillingResults.FEATURE_NOT_SUPPORTED;
            }
            case "subscriptionsUpdate": {
                return this.y ? BillingResults.OK : BillingResults.FEATURE_NOT_SUPPORTED;
            }
            case "inAppItemsOnVr": {
                return this.c("inapp");
            }
            case "subscriptionsOnVr": {
                return this.c("subs");
            }
            case "priceChangeConfirmation": {
                return this.A ? BillingResults.OK : BillingResults.FEATURE_NOT_SUPPORTED;
            }
        }
        BillingHelper.logWarn((String)TAG, (String)("Unsupported feature: " + string2));
        return BillingResults.UNKNOWN_FEATURE;
    }

    public boolean isReady() {
        return this.l == 2 && this.v != null && this.w != null;
    }

    public void startConnection(@NonNull BillingClientStateListener billingClientStateListener) {
        if (this.isReady()) {
            BillingHelper.logVerbose((String)TAG, (String)"Service connection is valid. No need to re-initialize.");
            billingClientStateListener.onBillingSetupFinished(BillingResults.OK);
            return;
        }
        if (this.l == 1) {
            BillingHelper.logWarn((String)TAG, (String)"Client is already in the process of connecting to billing service.");
            billingClientStateListener.onBillingSetupFinished(BillingResults.CLIENT_CONNECTING);
            return;
        }
        if (this.l == 3) {
            BillingHelper.logWarn((String)TAG, (String)"Client was already closed and can't be reused. Please create another instance.");
            billingClientStateListener.onBillingSetupFinished(BillingResults.SERVICE_DISCONNECTED);
            return;
        }
        this.l = 1;
        this.r.registerReceiver();
        BillingHelper.logVerbose((String)TAG, (String)"Starting in-app billing setup.");
        this.w = new a(billingClientStateListener);
        Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
        intent.setPackage("com.android.vending");
        List list = null;
        try {
            list = this.s.getPackageManager().queryIntentServices(intent, 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (list != null && !list.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
            if (resolveInfo.serviceInfo != null) {
                String string2 = resolveInfo.serviceInfo.packageName;
                String string3 = resolveInfo.serviceInfo.name;
                if ("com.android.vending".equals(string2) && string3 != null) {
                    ComponentName componentName = new ComponentName(string2, string3);
                    Intent intent2 = new Intent(intent);
                    intent2.setComponent(componentName);
                    intent2.putExtra("playBillingLibraryVersion", this.p);
                    boolean bl2 = this.s.bindService(intent2, (ServiceConnection)this.w, 1);
                    if (bl2) {
                        BillingHelper.logVerbose((String)TAG, (String)"Service was bonded successfully.");
                        return;
                    }
                    BillingHelper.logWarn((String)TAG, (String)"Connection to Billing service is blocked.");
                } else {
                    BillingHelper.logWarn((String)TAG, (String)"The device doesn't have valid Play Store.");
                }
            }
        }
        this.l = 0;
        BillingHelper.logVerbose((String)TAG, (String)"Billing service unavailable on device.");
        billingClientStateListener.onBillingSetupFinished(BillingResults.BILLING_UNAVAILABLE);
    }

    private void a(long l2) {
        this.startConnection((BillingClientStateListener)new BillingClientNativeCallback(l2));
    }

    public void endConnection() {
        try {
            this.r.destroy();
            if (this.w != null) {
                this.w.markDisconnectedAndCleanUp();
            }
            if (this.w != null && this.v != null) {
                BillingHelper.logVerbose((String)TAG, (String)"Unbinding from service.");
                this.s.unbindService((ServiceConnection)this.w);
                this.w = null;
            }
            this.v = null;
            if (this.E != null) {
                this.E.shutdownNow();
                this.E = null;
            }
        }
        catch (Exception exception) {
            BillingHelper.logWarn((String)TAG, (String)("There was an exception while ending connection: " + exception));
        }
        finally {
            this.l = 3;
        }
    }

    private void a(Activity activity, PriceChangeFlowParams priceChangeFlowParams, long l2) {
        this.launchPriceChangeConfirmationFlow(activity, priceChangeFlowParams, (PriceChangeConfirmationListener)new BillingClientNativeCallback(l2));
    }

    public void launchPriceChangeConfirmationFlow(Activity activity, PriceChangeFlowParams priceChangeFlowParams, final @NonNull PriceChangeConfirmationListener priceChangeConfirmationListener) {
        if (!this.isReady()) {
            priceChangeConfirmationListener.onPriceChangeConfirmationResult(BillingResults.SERVICE_DISCONNECTED);
            return;
        }
        if (priceChangeFlowParams == null || priceChangeFlowParams.getSkuDetails() == null) {
            BillingHelper.logWarn((String)TAG, (String)"Please fix the input params. priceChangeFlowParams must contain valid sku.");
            priceChangeConfirmationListener.onPriceChangeConfirmationResult(BillingResults.NULL_SKU);
            return;
        }
        final String string2 = priceChangeFlowParams.getSkuDetails().getSku();
        if (string2 == null) {
            BillingHelper.logWarn((String)TAG, (String)"Please fix the input params. priceChangeFlowParams must contain valid sku.");
            priceChangeConfirmationListener.onPriceChangeConfirmationResult(BillingResults.NULL_SKU);
            return;
        }
        if (!this.A) {
            BillingHelper.logWarn((String)TAG, (String)"Current client doesn't support price change confirmation flow.");
            priceChangeConfirmationListener.onPriceChangeConfirmationResult(BillingResults.FEATURE_NOT_SUPPORTED);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("playBillingLibraryVersion", this.p);
        bundle.putBoolean("subs_price_change", true);
        final Bundle bundle2 = bundle;
        Future<Bundle> future = this.a(new Callable<Bundle>(){

            @Override
            public Bundle call() throws Exception {
                return PipoPayBillingClientImpl.this.v.getSubscriptionManagementIntent(8, PipoPayBillingClientImpl.this.s.getPackageName(), string2, "subs", bundle2);
            }
        }, 5000L, null);
        try {
            Bundle bundle3 = future.get(5000L, TimeUnit.MILLISECONDS);
            int n2 = BillingHelper.getResponseCodeFromBundle((Bundle)bundle3, (String)TAG);
            String string3 = BillingHelper.getDebugMessageFromBundle((Bundle)bundle3, (String)TAG);
            BillingResult billingResult = BillingResult.newBuilder().setResponseCode(n2).setDebugMessage(string3).build();
            if (n2 != 0) {
                BillingHelper.logWarn((String)TAG, (String)("Unable to launch price change flow, error response code: " + n2));
                priceChangeConfirmationListener.onPriceChangeConfirmationResult(billingResult);
                return;
            }
            ResultReceiver resultReceiver = new ResultReceiver(this.q){

                public void onReceiveResult(int n2, Bundle bundle) {
                    BillingResult billingResult = BillingResult.newBuilder().setResponseCode(n2).setDebugMessage(BillingHelper.getDebugMessageFromBundle((Bundle)bundle, (String)PipoPayBillingClientImpl.TAG)).build();
                    priceChangeConfirmationListener.onPriceChangeConfirmationResult(billingResult);
                }
            };
            Intent intent = new Intent((Context)activity, ProxyBillingActivity.class);
            PendingIntent pendingIntent = (PendingIntent)bundle3.getParcelable("SUBS_MANAGEMENT_INTENT");
            intent.putExtra("SUBS_MANAGEMENT_INTENT", (Parcelable)pendingIntent);
            intent.putExtra("result_receiver", (Parcelable)resultReceiver);
            activity.startActivity(intent);
        }
        catch (CancellationException | TimeoutException exception) {
            String string4 = "Time out while launching Price Change Flow for sku: " + string2 + "; try to reconnect";
            BillingHelper.logWarn((String)TAG, (String)string4);
            priceChangeConfirmationListener.onPriceChangeConfirmationResult(BillingResults.SERVICE_TIMEOUT);
        }
        catch (Exception exception) {
            String string5 = "Exception caught while launching Price Change Flow for sku: " + string2 + "; try to reconnect";
            BillingHelper.logWarn((String)TAG, (String)string5);
            priceChangeConfirmationListener.onPriceChangeConfirmationResult(BillingResults.SERVICE_DISCONNECTED);
        }
    }

    public BillingResult launchBillingFlow(Activity activity, final BillingFlowParams billingFlowParams) {
        Future<Bundle> future;
        Object object;
        Bundle bundle;
        boolean bl2;
        boolean bl3;
        if (!this.isReady()) {
            return this.a(BillingResults.SERVICE_DISCONNECTED);
        }
        final String string2 = billingFlowParams.getSkuType();
        final String string3 = billingFlowParams.getSku();
        SkuDetails skuDetails = billingFlowParams.getSkuDetails();
        boolean bl4 = bl3 = skuDetails != null && skuDetails.isRewarded();
        if (string3 == null) {
            BillingHelper.logWarn((String)TAG, (String)"Please fix the input params. SKU can't be null.");
            return this.a(BillingResults.NULL_SKU);
        }
        if (string2 == null) {
            BillingHelper.logWarn((String)TAG, (String)"Please fix the input params. SkuType can't be null.");
            return this.a(BillingResults.NULL_SKU_TYPE);
        }
        if (string2.equals("subs") && !this.x) {
            BillingHelper.logWarn((String)TAG, (String)"Current client doesn't support subscriptions.");
            return this.a(BillingResults.SUBSCRIPTIONS_NOT_SUPPORTED);
        }
        boolean bl5 = bl2 = billingFlowParams.getOldSku() != null;
        if (bl2 && !this.y) {
            BillingHelper.logWarn((String)TAG, (String)"Current client doesn't support subscriptions update.");
            return this.a(BillingResults.SUBSCRIPTIONS_UPDATE_NOT_SUPPORTED);
        }
        if (billingFlowParams.hasExtraParams() && !this.z) {
            BillingHelper.logWarn((String)TAG, (String)"Current client doesn't support extra params for buy intent.");
            return this.a(BillingResults.EXTRA_PARAMS_NOT_SUPPORTED);
        }
        if (bl3 && !this.z) {
            BillingHelper.logWarn((String)TAG, (String)"Current client doesn't support extra params for buy intent.");
            return this.a(BillingResults.EXTRA_PARAMS_NOT_SUPPORTED);
        }
        BillingHelper.logVerbose((String)TAG, (String)("Constructing buy intent for " + string3 + ", item type: " + string2));
        final PipoBillingFlowParams pipoBillingFlowParams = (PipoBillingFlowParams)billingFlowParams;
        if (this.z) {
            bundle = BillingHelper.constructExtraParamsForLaunchBillingFlow((BillingFlowParams)billingFlowParams, (boolean)this.B, (boolean)this.D, (String)this.p);
            if (!skuDetails.getSkuDetailsToken().isEmpty()) {
                bundle.putString("skuDetailsToken", skuDetails.getSkuDetailsToken());
            }
            if (bl3) {
                bundle.putString("rewardToken", skuDetails.rewardToken());
                if (this.t != 0) {
                    bundle.putInt("childDirected", this.t);
                }
                if (this.u != 0) {
                    bundle.putInt("underAgeOfConsent", this.u);
                }
            }
            object = bundle;
            int n2 = 6;
            if (this.B) {
                n2 = 9;
            } else if (billingFlowParams.getVrPurchaseFlow()) {
                n2 = 7;
            }
            final int n3 = n2;
            future = this.a(new Callable<Bundle>(){

                @Override
                public Bundle call() throws Exception {
                    return PipoPayBillingClientImpl.this.v.getBuyIntentExtraParams(n3, PipoPayBillingClientImpl.this.s.getPackageName(), string3, string2, pipoBillingFlowParams.getDevelopPayload(), object);
                }
            }, 5000L, null);
        } else {
            future = bl2 ? this.a(new Callable<Bundle>(){

                @Override
                public Bundle call() throws Exception {
                    return PipoPayBillingClientImpl.this.v.getBuyIntentToReplaceSkus(5, PipoPayBillingClientImpl.this.s.getPackageName(), Arrays.asList(billingFlowParams.getOldSku()), string3, "subs", pipoBillingFlowParams.getDevelopPayload());
                }
            }, 5000L, null) : this.a(new Callable<Bundle>(){

                @Override
                public Bundle call() throws Exception {
                    return PipoPayBillingClientImpl.this.v.getBuyIntent(3, PipoPayBillingClientImpl.this.s.getPackageName(), string3, string2, pipoBillingFlowParams.getDevelopPayload());
                }
            }, 5000L, null);
        }
        try {
            bundle = future.get(5000L, TimeUnit.MILLISECONDS);
            int n4 = BillingHelper.getResponseCodeFromBundle((Bundle)bundle, (String)TAG);
            String string4 = BillingHelper.getDebugMessageFromBundle((Bundle)bundle, (String)TAG);
            if (n4 != 0) {
                BillingHelper.logWarn((String)TAG, (String)("Unable to buy item, Error response code: " + n4));
                BillingResult billingResult = BillingResult.newBuilder().setResponseCode(n4).setDebugMessage(string4).build();
                return this.a(billingResult);
            }
            Intent intent = new Intent((Context)activity, ProxyBillingActivity.class);
            intent.putExtra("result_receiver", (Parcelable)this.F);
            PendingIntent pendingIntent = (PendingIntent)bundle.getParcelable("BUY_INTENT");
            intent.putExtra("BUY_INTENT", (Parcelable)pendingIntent);
            activity.startActivity(intent);
        }
        catch (CancellationException | TimeoutException exception) {
            object = "Time out while launching billing flow: ; for sku: " + string3 + "; try to reconnect";
            BillingHelper.logWarn((String)TAG, (String)object);
            return this.a(BillingResults.SERVICE_TIMEOUT);
        }
        catch (Exception exception) {
            object = "Exception while launching billing flow: ; for sku: " + string3 + "; try to reconnect";
            BillingHelper.logWarn((String)TAG, (String)object);
            return this.a(BillingResults.SERVICE_DISCONNECTED);
        }
        return BillingResults.OK;
    }

    private BillingResult a(BillingResult billingResult) {
        this.r.getListener().onPurchasesUpdated(billingResult, null);
        return billingResult;
    }

    private int a(Activity activity, BillingFlowParams billingFlowParams) {
        return this.launchBillingFlow(activity, billingFlowParams).getResponseCode();
    }

    public Purchase.PurchasesResult queryPurchases(final String string2) {
        if (!this.isReady()) {
            return new Purchase.PurchasesResult(BillingResults.SERVICE_DISCONNECTED, null);
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            BillingHelper.logWarn((String)TAG, (String)"Please provide a valid SKU type.");
            return new Purchase.PurchasesResult(BillingResults.EMPTY_SKU_TYPE, null);
        }
        Future<Purchase.PurchasesResult> future = this.a(new Callable<Purchase.PurchasesResult>(){

            @Override
            public Purchase.PurchasesResult call() throws Exception {
                return PipoPayBillingClientImpl.this.d(string2);
            }
        }, 5000L, null);
        try {
            return future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (CancellationException | TimeoutException exception) {
            return new Purchase.PurchasesResult(BillingResults.SERVICE_TIMEOUT, null);
        }
        catch (Exception exception) {
            return new Purchase.PurchasesResult(BillingResults.INTERNAL_ERROR, null);
        }
    }

    private void a(final String string2, long l2) {
        Future<Void> future;
        final BillingClientNativeCallback billingClientNativeCallback = new BillingClientNativeCallback(l2);
        if (!this.isReady()) {
            billingClientNativeCallback.onQueryPurchasesResponse(BillingResults.SERVICE_DISCONNECTED, null);
        }
        if ((future = this.a(new Callable<Void>(){

            @Override
            public Void call() {
                final Purchase.PurchasesResult purchasesResult = PipoPayBillingClientImpl.this.d(string2);
                PipoPayBillingClientImpl.this.a(new Runnable(){

                    @Override
                    public void run() {
                        billingClientNativeCallback.onQueryPurchasesResponse(purchasesResult.getBillingResult(), purchasesResult.getPurchasesList());
                    }
                });
                return null;
            }
        }, 30000L, new Runnable(){

            @Override
            public void run() {
                billingClientNativeCallback.onQueryPurchasesResponse(BillingResults.SERVICE_TIMEOUT, null);
            }
        })) == null) {
            billingClientNativeCallback.onQueryPurchasesResponse(this.b(), null);
        }
    }

    public void querySkuDetailsAsync(SkuDetailsParams skuDetailsParams, final SkuDetailsResponseListener skuDetailsResponseListener) {
        if (!this.isReady()) {
            skuDetailsResponseListener.onSkuDetailsResponse(BillingResults.SERVICE_DISCONNECTED, null);
            return;
        }
        final String string2 = skuDetailsParams.getSkuType();
        final List list = skuDetailsParams.getSkusList();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            String string3 = "Please fix the input params. SKU type can't be empty.";
            BillingHelper.logWarn((String)TAG, (String)string3);
            skuDetailsResponseListener.onSkuDetailsResponse(BillingResults.EMPTY_SKU_TYPE, null);
            return;
        }
        if (list == null) {
            String string4 = "Please fix the input params. The list of SKUs can't be empty.";
            BillingHelper.logWarn((String)TAG, (String)string4);
            skuDetailsResponseListener.onSkuDetailsResponse(BillingResults.EMPTY_SKU_LIST, null);
            return;
        }
        Future<Void> future = this.a(new Callable<Void>(){

            @Override
            public Void call() {
                final SkuDetails.SkuDetailsResult skuDetailsResult = PipoPayBillingClientImpl.this.querySkuDetailsInternal(string2, list);
                PipoPayBillingClientImpl.this.a(new Runnable(){

                    @Override
                    public void run() {
                        skuDetailsResponseListener.onSkuDetailsResponse(BillingResult.newBuilder().setResponseCode(skuDetailsResult.getResponseCode()).setDebugMessage(skuDetailsResult.getDebugMessage()).build(), skuDetailsResult.getSkuDetailsList());
                    }
                });
                return null;
            }
        }, 30000L, new Runnable(){

            @Override
            public void run() {
                skuDetailsResponseListener.onSkuDetailsResponse(BillingResults.SERVICE_TIMEOUT, null);
            }
        });
        if (future == null) {
            skuDetailsResponseListener.onSkuDetailsResponse(this.b(), null);
        }
    }

    private void a(String string2, String[] stringArray, long l2) {
        this.querySkuDetailsAsync(SkuDetailsParams.newBuilder().setType(string2).setSkusList(Arrays.asList(stringArray)).build(), (SkuDetailsResponseListener)new BillingClientNativeCallback(l2));
    }

    public void consumeAsync(final ConsumeParams consumeParams, final ConsumeResponseListener consumeResponseListener) {
        if (!this.isReady()) {
            consumeResponseListener.onConsumeResponse(BillingResults.SERVICE_DISCONNECTED, null);
            return;
        }
        Future<Void> future = this.a(new Callable<Void>(){

            @Override
            public Void call() {
                PipoPayBillingClientImpl.this.a(consumeParams, consumeResponseListener);
                return null;
            }
        }, 30000L, new Runnable(){

            @Override
            public void run() {
                consumeResponseListener.onConsumeResponse(BillingResults.SERVICE_TIMEOUT, null);
            }
        });
        if (future == null) {
            consumeResponseListener.onConsumeResponse(this.b(), null);
        }
    }

    private void a(ConsumeParams consumeParams, long l2) {
        this.consumeAsync(consumeParams, (ConsumeResponseListener)new BillingClientNativeCallback(l2));
    }

    public void queryPurchaseHistoryAsync(final String string2, final PurchaseHistoryResponseListener purchaseHistoryResponseListener) {
        if (!this.isReady()) {
            purchaseHistoryResponseListener.onPurchaseHistoryResponse(BillingResults.SERVICE_DISCONNECTED, null);
            return;
        }
        Future<Void> future = this.a(new Callable<Void>(){

            @Override
            public Void call() {
                final c c2 = PipoPayBillingClientImpl.this.b(string2);
                PipoPayBillingClientImpl.this.a(new Runnable(){

                    @Override
                    public void run() {
                        purchaseHistoryResponseListener.onPurchaseHistoryResponse(c2.getBillingResult(), c2.getPurchaseHistoryRecordList());
                    }
                });
                return null;
            }
        }, 30000L, new Runnable(){

            @Override
            public void run() {
                purchaseHistoryResponseListener.onPurchaseHistoryResponse(BillingResults.SERVICE_TIMEOUT, null);
            }
        });
        if (future == null) {
            purchaseHistoryResponseListener.onPurchaseHistoryResponse(this.b(), null);
        }
    }

    private c b(String string2) {
        BillingHelper.logVerbose((String)TAG, (String)("Querying purchase history, item type: " + string2));
        String string3 = null;
        ArrayList<PurchaseHistoryRecord> arrayList = new ArrayList<PurchaseHistoryRecord>();
        Bundle bundle = BillingHelper.constructExtraParamsForQueryPurchases((boolean)this.B, (boolean)this.D, (String)this.p);
        do {
            Bundle bundle2;
            try {
                if (!this.z) {
                    BillingHelper.logWarn((String)TAG, (String)"getPurchaseHistory is not supported on current device");
                    return new c(BillingResults.GET_PURCHASE_HISTORY_NOT_SUPPORTED, null);
                }
                bundle2 = this.v.getPurchaseHistory(6, this.s.getPackageName(), string2, string3, bundle);
            }
            catch (RemoteException remoteException) {
                BillingHelper.logWarn((String)TAG, (String)("Got exception trying to get purchase history: " + (Object)((Object)remoteException) + "; try to reconnect"));
                return new c(BillingResults.SERVICE_DISCONNECTED, null);
            }
            BillingResult billingResult = PurchaseApiResponseChecker.checkPurchasesBundleValidity((Bundle)bundle2, (String)TAG, (String)"getPurchaseHistory()");
            if (billingResult != BillingResults.OK) {
                return new c(billingResult, null);
            }
            ArrayList arrayList2 = bundle2.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList3 = bundle2.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList4 = bundle2.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            for (int i2 = 0; i2 < arrayList3.size(); ++i2) {
                PurchaseHistoryRecord purchaseHistoryRecord;
                String string4 = (String)arrayList3.get(i2);
                String string5 = (String)arrayList4.get(i2);
                String string6 = (String)arrayList2.get(i2);
                BillingHelper.logVerbose((String)TAG, (String)("Purchase record found for sku : " + string6));
                try {
                    purchaseHistoryRecord = new PurchaseHistoryRecord(string4, string5);
                }
                catch (JSONException jSONException) {
                    BillingHelper.logWarn((String)TAG, (String)("Got an exception trying to decode the purchase: " + (Object)((Object)jSONException)));
                    return new c(BillingResults.INTERNAL_ERROR, null);
                }
                if (TextUtils.isEmpty((CharSequence)purchaseHistoryRecord.getPurchaseToken())) {
                    BillingHelper.logWarn((String)TAG, (String)"BUG: empty/null token!");
                }
                arrayList.add(purchaseHistoryRecord);
            }
            string3 = bundle2.getString("INAPP_CONTINUATION_TOKEN");
            BillingHelper.logVerbose((String)TAG, (String)("Continuation token: " + string3));
        } while (!TextUtils.isEmpty((CharSequence)string3));
        return new c(BillingResults.OK, arrayList);
    }

    private void b(@NonNull String string2, long l2) {
        this.queryPurchaseHistoryAsync(string2, (PurchaseHistoryResponseListener)new BillingClientNativeCallback(l2));
    }

    public void loadRewardedSku(final RewardLoadParams rewardLoadParams, final RewardResponseListener rewardResponseListener) {
        if (!this.z) {
            rewardResponseListener.onRewardResponse(BillingResults.ITEM_UNAVAILABLE);
            return;
        }
        Future<Void> future = this.a(new Callable<Void>(){

            @Override
            public Void call() {
                Bundle bundle;
                Bundle bundle2 = BillingHelper.constructExtraParamsForLoadRewardedSku((String)rewardLoadParams.getSkuDetails().rewardToken(), (int)PipoPayBillingClientImpl.this.t, (int)PipoPayBillingClientImpl.this.u, (String)PipoPayBillingClientImpl.this.p);
                try {
                    bundle = PipoPayBillingClientImpl.this.v.getBuyIntentExtraParams(6, PipoPayBillingClientImpl.this.s.getPackageName(), rewardLoadParams.getSkuDetails().getSku(), rewardLoadParams.getSkuDetails().getType(), null, bundle2);
                }
                catch (Exception exception) {
                    PipoPayBillingClientImpl.this.a(new Runnable(){

                        @Override
                        public void run() {
                            rewardResponseListener.onRewardResponse(BillingResults.INTERNAL_ERROR);
                        }
                    });
                    return null;
                }
                final BillingResult billingResult = BillingResult.newBuilder().setResponseCode(BillingHelper.getResponseCodeFromBundle((Bundle)bundle, (String)PipoPayBillingClientImpl.TAG)).setDebugMessage(BillingHelper.getDebugMessageFromBundle((Bundle)bundle, (String)PipoPayBillingClientImpl.TAG)).build();
                PipoPayBillingClientImpl.this.a(new Runnable(){

                    @Override
                    public void run() {
                        rewardResponseListener.onRewardResponse(billingResult);
                    }
                });
                return null;
            }
        }, 30000L, new Runnable(){

            @Override
            public void run() {
                rewardResponseListener.onRewardResponse(BillingResults.SERVICE_TIMEOUT);
            }
        });
        if (future == null) {
            rewardResponseListener.onRewardResponse(this.b());
        }
    }

    private void a(RewardLoadParams rewardLoadParams, long l2) {
        this.loadRewardedSku(rewardLoadParams, (RewardResponseListener)new BillingClientNativeCallback(l2));
    }

    public void acknowledgePurchase(final AcknowledgePurchaseParams acknowledgePurchaseParams, final AcknowledgePurchaseResponseListener acknowledgePurchaseResponseListener) {
        if (!this.isReady()) {
            acknowledgePurchaseResponseListener.onAcknowledgePurchaseResponse(BillingResults.SERVICE_DISCONNECTED);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)acknowledgePurchaseParams.getPurchaseToken())) {
            BillingHelper.logWarn((String)TAG, (String)"Please provide a valid purchase token.");
            acknowledgePurchaseResponseListener.onAcknowledgePurchaseResponse(BillingResults.INVALID_PURCHASE_TOKEN);
            return;
        }
        if (!this.B) {
            acknowledgePurchaseResponseListener.onAcknowledgePurchaseResponse(BillingResults.API_VERSION_NOT_V9);
            return;
        }
        Future<Void> future = this.a(new Callable<Void>(){

            @Override
            public Void call() {
                Bundle bundle;
                try {
                    bundle = PipoPayBillingClientImpl.this.v.acknowledgePurchaseExtraParams(9, PipoPayBillingClientImpl.this.s.getPackageName(), acknowledgePurchaseParams.getPurchaseToken(), BillingHelper.constructExtraParamsForAcknowledgePurchase((AcknowledgePurchaseParams)acknowledgePurchaseParams, (String)PipoPayBillingClientImpl.this.p));
                }
                catch (Exception exception) {
                    PipoPayBillingClientImpl.this.a(new Runnable(){

                        @Override
                        public void run() {
                            BillingHelper.logWarn((String)PipoPayBillingClientImpl.TAG, (String)("Error acknowledge purchase; ex: " + exception));
                            acknowledgePurchaseResponseListener.onAcknowledgePurchaseResponse(BillingResults.SERVICE_DISCONNECTED);
                        }
                    });
                    return null;
                }
                final int n2 = BillingHelper.getResponseCodeFromBundle((Bundle)bundle, (String)PipoPayBillingClientImpl.TAG);
                final String string2 = BillingHelper.getDebugMessageFromBundle((Bundle)bundle, (String)PipoPayBillingClientImpl.TAG);
                PipoPayBillingClientImpl.this.a(new Runnable(){

                    @Override
                    public void run() {
                        acknowledgePurchaseResponseListener.onAcknowledgePurchaseResponse(BillingResult.newBuilder().setResponseCode(n2).setDebugMessage(string2).build());
                    }
                });
                return null;
            }
        }, 30000L, new Runnable(){

            @Override
            public void run() {
                acknowledgePurchaseResponseListener.onAcknowledgePurchaseResponse(BillingResults.SERVICE_TIMEOUT);
            }
        });
        if (future == null) {
            acknowledgePurchaseResponseListener.onAcknowledgePurchaseResponse(this.b());
        }
    }

    private void a(AcknowledgePurchaseParams acknowledgePurchaseParams, long l2) {
        this.acknowledgePurchase(acknowledgePurchaseParams, (AcknowledgePurchaseResponseListener)new BillingClientNativeCallback(l2));
    }

    @Nullable
    private <T> Future<T> a(@NonNull Callable<T> callable, long l2, final @Nullable Runnable runnable) {
        Future<T> future;
        long l3 = (long)(0.95 * (double)l2);
        if (this.E == null) {
            this.E = Executors.newFixedThreadPool(BillingHelper.NUMBER_OF_CORES);
        }
        try {
            future = this.E.submit(callable);
        }
        catch (Exception exception) {
            BillingHelper.logWarn((String)TAG, (String)("Async task throws exception " + exception));
            return null;
        }
        this.q.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!future.isDone() && !future.isCancelled()) {
                    future.cancel(true);
                    BillingHelper.logWarn((String)PipoPayBillingClientImpl.TAG, (String)"Async task is taking too long, cancel it!");
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            }
        }, l3);
        return future;
    }

    private BillingResult c(final String string2) {
        Future<Integer> future = this.a(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return PipoPayBillingClientImpl.this.v.isBillingSupportedExtraParams(7, PipoPayBillingClientImpl.this.s.getPackageName(), string2, PipoPayBillingClientImpl.this.a());
            }
        }, 5000L, null);
        try {
            int n2 = future.get(5000L, TimeUnit.MILLISECONDS);
            return n2 == 0 ? BillingResults.OK : BillingResults.FEATURE_NOT_SUPPORTED;
        }
        catch (Exception exception) {
            BillingHelper.logWarn((String)TAG, (String)"Exception while checking if billing is supported; try to reconnect");
            return BillingResults.SERVICE_DISCONNECTED;
        }
    }

    private Bundle a() {
        Bundle bundle = new Bundle();
        bundle.putBoolean("vr", true);
        return bundle;
    }

    @VisibleForTesting
    SkuDetails.SkuDetailsResult querySkuDetailsInternal(String string2, List<String> list) {
        ArrayList<SkuDetails> arrayList = new ArrayList<SkuDetails>();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; i2 += 20) {
            String string3;
            Object object;
            Bundle bundle;
            int n3 = i2 + 20;
            if (n3 > n2) {
                n3 = n2;
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(list.subList(i2, n3));
            Bundle bundle2 = new Bundle();
            bundle2.putStringArrayList(m, arrayList2);
            bundle2.putString("playBillingLibraryVersion", this.p);
            try {
                bundle = this.C ? this.v.getSkuDetailsExtraParams(10, this.s.getPackageName(), string2, bundle2, BillingHelper.constructExtraParamsForGetSkuDetails((boolean)this.B, (boolean)this.D, (String)this.p)) : this.v.getSkuDetails(3, this.s.getPackageName(), string2, bundle2);
            }
            catch (Exception exception) {
                String string4 = "querySkuDetailsAsync got a remote exception (try to reconnect).";
                BillingHelper.logWarn((String)TAG, (String)(string4 + exception));
                return new SkuDetails.SkuDetailsResult(-1, "Service connection is disconnected.", null);
            }
            if (bundle == null) {
                object = "querySkuDetailsAsync got null sku details list";
                BillingHelper.logWarn((String)TAG, (String)object);
                return new SkuDetails.SkuDetailsResult(4, "Null sku details list", null);
            }
            if (!bundle.containsKey("DETAILS_LIST")) {
                int n4 = BillingHelper.getResponseCodeFromBundle((Bundle)bundle, (String)TAG);
                String string5 = BillingHelper.getDebugMessageFromBundle((Bundle)bundle, (String)TAG);
                if (n4 != 0) {
                    string3 = "getSkuDetails() failed. Response code: " + n4;
                    BillingHelper.logWarn((String)TAG, (String)string3);
                    return new SkuDetails.SkuDetailsResult(n4, string5, arrayList);
                }
                string3 = "getSkuDetails() returned a bundle with neither an error nor a detail list.";
                BillingHelper.logWarn((String)TAG, (String)string3);
                return new SkuDetails.SkuDetailsResult(6, string5, arrayList);
            }
            object = bundle.getStringArrayList("DETAILS_LIST");
            if (object == null) {
                String string6 = "querySkuDetailsAsync got null response list";
                BillingHelper.logWarn((String)TAG, (String)string6);
                return new SkuDetails.SkuDetailsResult(4, string6, null);
            }
            for (int i3 = 0; i3 < ((ArrayList)object).size(); ++i3) {
                SkuDetails skuDetails;
                string3 = (String)((ArrayList)object).get(i3);
                try {
                    skuDetails = new SkuDetails(string3);
                }
                catch (JSONException jSONException) {
                    String string7 = "Got a JSON exception trying to decode SkuDetails.";
                    BillingHelper.logWarn((String)TAG, (String)string7);
                    return new SkuDetails.SkuDetailsResult(6, "Error trying to decode SkuDetails.", null);
                }
                BillingHelper.logVerbose((String)TAG, (String)("Got sku details: " + skuDetails));
                arrayList.add(skuDetails);
            }
        }
        return new SkuDetails.SkuDetailsResult(0, "", arrayList);
    }

    private Purchase.PurchasesResult d(String string2) {
        BillingHelper.logVerbose((String)TAG, (String)("Querying owned items, item type: " + string2));
        String string3 = null;
        ArrayList<Purchase> arrayList = new ArrayList<Purchase>();
        Bundle bundle = BillingHelper.constructExtraParamsForQueryPurchases((boolean)this.B, (boolean)this.D, (String)this.p);
        do {
            Bundle bundle2;
            try {
                bundle2 = this.B ? this.v.getPurchasesExtraParams(9, this.s.getPackageName(), string2, string3, bundle) : this.v.getPurchases(3, this.s.getPackageName(), string2, string3);
            }
            catch (Exception exception) {
                BillingHelper.logWarn((String)TAG, (String)("Got exception trying to get purchases: " + exception + "; try to reconnect"));
                return new Purchase.PurchasesResult(BillingResults.SERVICE_DISCONNECTED, null);
            }
            BillingResult billingResult = PurchaseApiResponseChecker.checkPurchasesBundleValidity((Bundle)bundle2, (String)TAG, (String)"getPurchase()");
            if (billingResult != BillingResults.OK) {
                return new Purchase.PurchasesResult(billingResult, null);
            }
            ArrayList arrayList2 = bundle2.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList3 = bundle2.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList4 = bundle2.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            for (int i2 = 0; i2 < arrayList3.size(); ++i2) {
                Purchase purchase;
                String string4 = (String)arrayList3.get(i2);
                String string5 = (String)arrayList4.get(i2);
                String string6 = (String)arrayList2.get(i2);
                BillingHelper.logVerbose((String)TAG, (String)("Sku is owned: " + string6));
                try {
                    purchase = new Purchase(string4, string5);
                }
                catch (JSONException jSONException) {
                    BillingHelper.logWarn((String)TAG, (String)("Got an exception trying to decode the purchase: " + (Object)((Object)jSONException)));
                    return new Purchase.PurchasesResult(BillingResults.INTERNAL_ERROR, null);
                }
                if (TextUtils.isEmpty((CharSequence)purchase.getPurchaseToken())) {
                    BillingHelper.logWarn((String)TAG, (String)"BUG: empty/null token!");
                }
                arrayList.add(purchase);
            }
            string3 = bundle2.getString("INAPP_CONTINUATION_TOKEN");
            BillingHelper.logVerbose((String)TAG, (String)("Continuation token: " + string3));
        } while (!TextUtils.isEmpty((CharSequence)string3));
        return new Purchase.PurchasesResult(BillingResults.OK, arrayList);
    }

    private void a(Runnable runnable) {
        if (Thread.interrupted()) {
            return;
        }
        this.q.post(runnable);
    }

    @WorkerThread
    private void a(ConsumeParams consumeParams, final ConsumeResponseListener consumeResponseListener) {
        final String string2 = consumeParams.getPurchaseToken();
        try {
            String string3;
            int n2;
            Bundle bundle;
            BillingHelper.logVerbose((String)TAG, (String)("Consuming purchase with token: " + string2));
            if (this.B) {
                bundle = this.v.consumePurchaseExtraParams(9, this.s.getPackageName(), string2, BillingHelper.constructExtraParamsForConsume((ConsumeParams)consumeParams, (boolean)this.B, (String)this.p));
                n2 = bundle.getInt("RESPONSE_CODE");
                string3 = BillingHelper.getDebugMessageFromBundle((Bundle)bundle, (String)TAG);
            } else {
                n2 = this.v.consumePurchase(3, this.s.getPackageName(), string2);
                string3 = "";
            }
            bundle = BillingResult.newBuilder().setResponseCode(n2).setDebugMessage(string3).build();
            if (n2 == 0) {
                this.a(new Runnable((BillingResult)bundle, string2){
                    final /* synthetic */ BillingResult val$billingResult;
                    final /* synthetic */ String val$purchaseToken;
                    {
                        this.val$billingResult = billingResult;
                        this.val$purchaseToken = string2;
                    }

                    @Override
                    public void run() {
                        BillingHelper.logVerbose((String)PipoPayBillingClientImpl.TAG, (String)"Successfully consumed purchase.");
                        consumeResponseListener.onConsumeResponse(this.val$billingResult, this.val$purchaseToken);
                    }
                });
            } else {
                this.a(new Runnable((BillingResult)bundle, string2){
                    final /* synthetic */ BillingResult val$billingResult;
                    final /* synthetic */ String val$purchaseToken;
                    {
                        this.val$billingResult = billingResult;
                        this.val$purchaseToken = string2;
                    }

                    @Override
                    public void run() {
                        BillingHelper.logWarn((String)PipoPayBillingClientImpl.TAG, (String)("Error consuming purchase with token. Response code: " + n2));
                        consumeResponseListener.onConsumeResponse(this.val$billingResult, this.val$purchaseToken);
                    }
                });
            }
        }
        catch (Exception exception) {
            this.a(new Runnable(){

                @Override
                public void run() {
                    BillingHelper.logWarn((String)PipoPayBillingClientImpl.TAG, (String)("Error consuming purchase; ex: " + exception));
                    consumeResponseListener.onConsumeResponse(BillingResults.SERVICE_DISCONNECTED, string2);
                }
            });
        }
    }

    private BillingResult b() {
        return this.l == 0 || this.l == 3 ? BillingResults.SERVICE_DISCONNECTED : BillingResults.INTERNAL_ERROR;
    }

    static class c {
        private List<PurchaseHistoryRecord> Q;
        private BillingResult R;

        c(BillingResult billingResult, List<PurchaseHistoryRecord> list) {
            this.Q = list;
            this.R = billingResult;
        }

        BillingResult getBillingResult() {
            return this.R;
        }

        List<PurchaseHistoryRecord> getPurchaseHistoryRecordList() {
            return this.Q;
        }
    }

    final class a
    implements ServiceConnection {
        private final Object lock = new Object();
        private boolean N = false;
        private BillingClientStateListener O;

        private a(@NonNull BillingClientStateListener billingClientStateListener) {
            this.O = billingClientStateListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName componentName) {
            BillingHelper.logWarn((String)PipoPayBillingClientImpl.TAG, (String)"Billing service disconnected.");
            PipoPayBillingClientImpl.this.v = null;
            PipoPayBillingClientImpl.this.l = 0;
            Object object = this.lock;
            synchronized (object) {
                if (this.O != null) {
                    this.O.onBillingServiceDisconnected();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markDisconnectedAndCleanUp() {
            Object object = this.lock;
            synchronized (object) {
                this.O = null;
                this.N = true;
            }
        }

        private void b(final BillingResult billingResult) {
            PipoPayBillingClientImpl.this.a(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = a.this.lock;
                    synchronized (object) {
                        if (a.this.O != null) {
                            a.this.O.onBillingSetupFinished(billingResult);
                        }
                    }
                }
            });
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            BillingHelper.logVerbose((String)PipoPayBillingClientImpl.TAG, (String)"Billing service connected.");
            PipoPayBillingClientImpl.this.v = IInAppBillingService.Stub.asInterface((IBinder)iBinder);
            Future future = PipoPayBillingClientImpl.this.a(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() {
                    Object object = a.this.lock;
                    synchronized (object) {
                        if (a.this.N) {
                            return null;
                        }
                    }
                    int n2 = 3;
                    try {
                        int n3;
                        String string2 = PipoPayBillingClientImpl.this.s.getPackageName();
                        int n4 = 0;
                        for (n3 = 10; n3 >= 3; --n3) {
                            n2 = PipoPayBillingClientImpl.this.v.isBillingSupported(n3, string2, "subs");
                            if (n2 != 0) continue;
                            n4 = n3;
                            break;
                        }
                        PipoPayBillingClientImpl.this.y = n4 >= 5;
                        PipoPayBillingClientImpl.this.x = n4 >= 3;
                        if (n4 < 3) {
                            BillingHelper.logVerbose((String)PipoPayBillingClientImpl.TAG, (String)"In-app billing API does not support subscription on this device.");
                        }
                        n3 = 0;
                        for (int i2 = 10; i2 >= 3; --i2) {
                            n2 = PipoPayBillingClientImpl.this.v.isBillingSupported(i2, string2, "inapp");
                            if (n2 != 0) continue;
                            n3 = i2;
                            break;
                        }
                        PipoPayBillingClientImpl.this.C = n3 >= 10;
                        PipoPayBillingClientImpl.this.B = n3 >= 9;
                        PipoPayBillingClientImpl.this.A = n3 >= 8;
                        PipoPayBillingClientImpl.this.z = n3 >= 6;
                        if (n3 < 3) {
                            BillingHelper.logWarn((String)PipoPayBillingClientImpl.TAG, (String)"In-app billing API version 3 is not supported on this device.");
                        }
                        if (n2 == 0) {
                            PipoPayBillingClientImpl.this.l = 2;
                        } else {
                            PipoPayBillingClientImpl.this.l = 0;
                            PipoPayBillingClientImpl.this.v = null;
                        }
                    }
                    catch (Exception exception) {
                        BillingHelper.logWarn((String)PipoPayBillingClientImpl.TAG, (String)"Exception while checking if billing is supported; try to reconnect");
                        PipoPayBillingClientImpl.this.l = 0;
                        PipoPayBillingClientImpl.this.v = null;
                    }
                    if (n2 == 0) {
                        a.this.b(BillingResults.OK);
                    } else {
                        a.this.b(BillingResults.API_VERSION_NOT_V3);
                    }
                    return null;
                }
            }, 30000L, new Runnable(){

                @Override
                public void run() {
                    PipoPayBillingClientImpl.this.l = 0;
                    PipoPayBillingClientImpl.this.v = null;
                    a.this.b(BillingResults.SERVICE_TIMEOUT);
                }
            });
            if (future == null) {
                this.b(PipoPayBillingClientImpl.this.b());
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface b {
        public static final int DISCONNECTED = 0;
        public static final int CONNECTING = 1;
        public static final int CONNECTED = 2;
        public static final int CLOSED = 3;
    }
}

