/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.swiperefresh;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.viewmanagers.AndroidSwipeRefreshLayoutManagerDelegate;
import com.facebook.react.viewmanagers.AndroidSwipeRefreshLayoutManagerInterface;
import com.facebook.react.views.swiperefresh.ReactSwipeRefreshLayout;
import com.facebook.react.views.swiperefresh.RefreshEvent;
import java.util.Map;

@ReactModule(name="AndroidSwipeRefreshLayout")
public class SwipeRefreshLayoutManager
extends ViewGroupManager<ReactSwipeRefreshLayout>
implements AndroidSwipeRefreshLayoutManagerInterface<ReactSwipeRefreshLayout> {
    public static final String REACT_CLASS = "AndroidSwipeRefreshLayout";
    private final ViewManagerDelegate<ReactSwipeRefreshLayout> mDelegate = new AndroidSwipeRefreshLayoutManagerDelegate<ReactSwipeRefreshLayout, SwipeRefreshLayoutManager>(this);

    @Override
    protected ReactSwipeRefreshLayout createViewInstance(ThemedReactContext reactContext) {
        return new ReactSwipeRefreshLayout(reactContext);
    }

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    @ReactProp(name="enabled", defaultBoolean=true)
    public void setEnabled(ReactSwipeRefreshLayout view, boolean enabled) {
        view.setEnabled(enabled);
    }

    @Override
    @ReactProp(name="colors", customType="ColorArray")
    public void setColors(ReactSwipeRefreshLayout view, @Nullable ReadableArray colors) {
        if (colors != null) {
            int[] colorValues = new int[colors.size()];
            for (int i = 0; i < colors.size(); ++i) {
                colorValues[i] = colors.getInt(i);
            }
            view.setColorSchemeColors(colorValues);
        } else {
            view.setColorSchemeColors(new int[0]);
        }
    }

    @Override
    @ReactProp(name="progressBackgroundColor", customType="Color")
    public void setProgressBackgroundColor(ReactSwipeRefreshLayout view, Integer color) {
        view.setProgressBackgroundColorSchemeColor(color == null ? 0 : color);
    }

    @Override
    public void setSize(ReactSwipeRefreshLayout view, int value) {
        view.setSize(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ReactProp(name="size")
    public void setSize(ReactSwipeRefreshLayout view, Dynamic size) {
        if (size.isNull()) {
            view.setSize(1);
            return;
        } else if (size.getType() == ReadableType.Number) {
            view.setSize(size.asInt());
            return;
        } else {
            if (size.getType() != ReadableType.String) throw new IllegalArgumentException("Size must be 'default' or 'large'");
            String sizeStr = size.asString();
            if (sizeStr.equals("default")) {
                view.setSize(1);
                return;
            } else {
                if (!sizeStr.equals("large")) throw new IllegalArgumentException("Size must be 'default' or 'large', received: " + sizeStr);
                view.setSize(0);
            }
        }
    }

    @Override
    @ReactProp(name="refreshing")
    public void setRefreshing(ReactSwipeRefreshLayout view, boolean refreshing) {
        view.setRefreshing(refreshing);
    }

    @Override
    @ReactProp(name="progressViewOffset", defaultFloat=0.0f)
    public void setProgressViewOffset(ReactSwipeRefreshLayout view, float offset) {
        view.setProgressViewOffset(offset);
    }

    @Override
    public void setNativeRefreshing(ReactSwipeRefreshLayout view, boolean value) {
    }

    @Override
    protected void addEventEmitters(final ThemedReactContext reactContext, final ReactSwipeRefreshLayout view) {
        view.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher().dispatchEvent(new RefreshEvent(view.getId()));
            }
        });
    }

    @Override
    public void receiveCommand(@NonNull ReactSwipeRefreshLayout root, String commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case "setNativeRefreshing": {
                if (args == null) break;
                this.setRefreshing(root, args.getBoolean(0));
            }
        }
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedViewConstants() {
        return MapBuilder.of("SIZE", MapBuilder.of("DEFAULT", 1, "LARGE", 0));
    }

    @Override
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put("topRefresh", MapBuilder.of("registrationName", "onRefresh")).build();
    }

    @Override
    protected ViewManagerDelegate<ReactSwipeRefreshLayout> getDelegate() {
        return this.mDelegate;
    }
}

