/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.yoga;

import com.facebook.yoga.YogaConfig;
import com.facebook.yoga.YogaExperimentalFeature;
import com.facebook.yoga.YogaLogger;
import com.facebook.yoga.YogaNative;

public abstract class YogaConfigJNIBase
extends YogaConfig {
    long mNativePointer;
    private YogaLogger mLogger;

    private YogaConfigJNIBase(long nativePointer) {
        if (nativePointer == 0L) {
            throw new IllegalStateException("Failed to allocate native memory");
        }
        this.mNativePointer = nativePointer;
    }

    YogaConfigJNIBase() {
        this(YogaNative.jni_YGConfigNewJNI());
    }

    YogaConfigJNIBase(boolean useVanillaJNI) {
        this(YogaNative.jni_YGConfigNewJNI());
    }

    @Override
    public void setExperimentalFeatureEnabled(YogaExperimentalFeature feature, boolean enabled) {
        YogaNative.jni_YGConfigSetExperimentalFeatureEnabledJNI(this.mNativePointer, feature.intValue(), enabled);
    }

    @Override
    public void setUseWebDefaults(boolean useWebDefaults) {
        YogaNative.jni_YGConfigSetUseWebDefaultsJNI(this.mNativePointer, useWebDefaults);
    }

    @Override
    public void setPrintTreeFlag(boolean enable) {
        YogaNative.jni_YGConfigSetPrintTreeFlagJNI(this.mNativePointer, enable);
    }

    @Override
    public void setPointScaleFactor(float pixelsInPoint) {
        YogaNative.jni_YGConfigSetPointScaleFactorJNI(this.mNativePointer, pixelsInPoint);
    }

    @Override
    public void setUseLegacyStretchBehaviour(boolean useLegacyStretchBehaviour) {
        YogaNative.jni_YGConfigSetUseLegacyStretchBehaviourJNI(this.mNativePointer, useLegacyStretchBehaviour);
    }

    @Override
    public void setShouldDiffLayoutWithoutLegacyStretchBehaviour(boolean shouldDiffLayoutWithoutLegacyStretchBehaviour) {
        YogaNative.jni_YGConfigSetShouldDiffLayoutWithoutLegacyStretchBehaviourJNI(this.mNativePointer, shouldDiffLayoutWithoutLegacyStretchBehaviour);
    }

    @Override
    public void setLogger(YogaLogger logger) {
        this.mLogger = logger;
        YogaNative.jni_YGConfigSetLoggerJNI(this.mNativePointer, logger);
    }

    @Override
    public YogaLogger getLogger() {
        return this.mLogger;
    }

    @Override
    long getNativePointer() {
        return this.mNativePointer;
    }
}

