/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.turbomodule.core;

import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.ReactPackage;
import com.facebook.react.TurboReactPackage;
import com.facebook.react.bridge.CxxModuleWrapper;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.turbomodule.core.TurboModuleManagerDelegate;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ReactPackageTurboModuleManagerDelegate
extends TurboModuleManagerDelegate {
    private final List<TurboReactPackage> mPackages = new ArrayList<TurboReactPackage>();
    private final Map<String, TurboModule> mModules = new HashMap<String, TurboModule>();
    private final ReactApplicationContext mReactApplicationContext;

    protected ReactPackageTurboModuleManagerDelegate(ReactApplicationContext reactApplicationContext, List<ReactPackage> packages) {
        this.mReactApplicationContext = reactApplicationContext;
        for (ReactPackage reactPackage : packages) {
            if (!(reactPackage instanceof TurboReactPackage)) continue;
            this.mPackages.add((TurboReactPackage)reactPackage);
        }
    }

    @Override
    @Nullable
    public TurboModule getModule(String moduleName) {
        TurboModule module = this.resolveModule(moduleName);
        if (module == null) {
            return null;
        }
        if (module instanceof CxxModuleWrapper) {
            return null;
        }
        return module;
    }

    @Override
    @Nullable
    @DoNotStrip
    public CxxModuleWrapper getLegacyCxxModule(String moduleName) {
        TurboModule module = this.resolveModule(moduleName);
        if (module == null) {
            return null;
        }
        if (!(module instanceof CxxModuleWrapper)) {
            return null;
        }
        return (CxxModuleWrapper)((Object)module);
    }

    private TurboModule resolveModule(String moduleName) {
        if (this.mModules.containsKey(moduleName)) {
            return this.mModules.get(moduleName);
        }
        NativeModule resolvedModule = null;
        for (TurboReactPackage pkg : this.mPackages) {
            try {
                NativeModule module = pkg.getModule(moduleName, this.mReactApplicationContext);
                if (resolvedModule != null && (module == null || !module.canOverrideExistingModule())) continue;
                resolvedModule = module;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (resolvedModule instanceof TurboModule) {
            this.mModules.put(moduleName, (TurboModule)((Object)resolvedModule));
        } else {
            this.mModules.put(moduleName, null);
        }
        return this.mModules.get(moduleName);
    }

    @Override
    public List<String> getEagerInitModuleNames() {
        ArrayList<String> moduleNames = new ArrayList<String>();
        for (TurboReactPackage reactPackage : this.mPackages) {
            for (ReactModuleInfo moduleInfo : reactPackage.getReactModuleInfoProvider().getReactModuleInfos().values()) {
                if (!moduleInfo.isTurboModule() || !moduleInfo.needsEagerInit()) continue;
                moduleNames.add(moduleInfo.name());
            }
        }
        return moduleNames;
    }

    public static abstract class Builder {
        @Nullable
        private List<ReactPackage> mPackages;
        @Nullable
        private ReactApplicationContext mContext;

        public Builder setPackages(List<ReactPackage> packages) {
            this.mPackages = new ArrayList<ReactPackage>(packages);
            return this;
        }

        public Builder setReactApplicationContext(ReactApplicationContext context) {
            this.mContext = context;
            return this;
        }

        protected abstract ReactPackageTurboModuleManagerDelegate build(ReactApplicationContext var1, List<ReactPackage> var2);

        public ReactPackageTurboModuleManagerDelegate build() {
            Assertions.assertNotNull((Object)((Object)this.mContext), (String)"The ReactApplicationContext must be provided to create ReactPackageTurboModuleManagerDelegate");
            Assertions.assertNotNull(this.mPackages, (String)"A set of ReactPackages must be provided to create ReactPackageTurboModuleManagerDelegate");
            return this.build(this.mContext, this.mPackages);
        }
    }
}

