/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReadableArray;
import java.util.Arrays;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class AsyncLocalStorageUtil {
    static String buildKeySelection(int selectionCount) {
        Object[] list = new String[selectionCount];
        Arrays.fill(list, "?");
        return "key IN (" + TextUtils.join((CharSequence)", ", (Object[])list) + ")";
    }

    static String[] buildKeySelectionArgs(ReadableArray keys, int start, int count) {
        String[] selectionArgs = new String[count];
        for (int keyIndex = 0; keyIndex < count; ++keyIndex) {
            selectionArgs[keyIndex] = keys.getString(start + keyIndex);
        }
        return selectionArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getItemImpl(SQLiteDatabase db, String key) {
        String[] columns = new String[]{"value"};
        String[] selectionArgs = new String[]{key};
        try (Cursor cursor = db.query("catalystLocalStorage", columns, "key=?", selectionArgs, null, null, null);){
            if (!cursor.moveToFirst()) {
                String string2 = null;
                return string2;
            }
            String string3 = cursor.getString(0);
            return string3;
        }
    }

    static boolean setItemImpl(SQLiteDatabase db, String key, String value) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("key", key);
        contentValues.put("value", value);
        long inserted = db.insertWithOnConflict("catalystLocalStorage", null, contentValues, 5);
        return -1L != inserted;
    }

    static boolean mergeImpl(SQLiteDatabase db, String key, String value) throws JSONException {
        String newValue;
        String oldValue = AsyncLocalStorageUtil.getItemImpl(db, key);
        if (oldValue == null) {
            newValue = value;
        } else {
            JSONObject oldJSON = new JSONObject(oldValue);
            JSONObject newJSON = new JSONObject(value);
            AsyncLocalStorageUtil.deepMergeInto(oldJSON, newJSON);
            newValue = oldJSON.toString();
        }
        return AsyncLocalStorageUtil.setItemImpl(db, key, newValue);
    }

    private static void deepMergeInto(JSONObject oldJSON, JSONObject newJSON) throws JSONException {
        Iterator keys = newJSON.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            JSONObject newJSONObject = newJSON.optJSONObject(key);
            JSONObject oldJSONObject = oldJSON.optJSONObject(key);
            if (newJSONObject != null && oldJSONObject != null) {
                AsyncLocalStorageUtil.deepMergeInto(oldJSONObject, newJSONObject);
                oldJSON.put(key, (Object)oldJSONObject);
                continue;
            }
            oldJSON.put(key, newJSON.get(key));
        }
    }
}

