/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.progressbar;

import android.content.Context;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.viewmanagers.AndroidProgressBarManagerDelegate;
import com.facebook.react.viewmanagers.AndroidProgressBarManagerInterface;
import com.facebook.react.views.progressbar.ProgressBarContainerView;
import com.facebook.react.views.progressbar.ProgressBarShadowNode;

@ReactModule(name="AndroidProgressBar")
public class ReactProgressBarViewManager
extends BaseViewManager<ProgressBarContainerView, ProgressBarShadowNode>
implements AndroidProgressBarManagerInterface<ProgressBarContainerView> {
    public static final String REACT_CLASS = "AndroidProgressBar";
    static final String PROP_STYLE = "styleAttr";
    static final String PROP_INDETERMINATE = "indeterminate";
    static final String PROP_PROGRESS = "progress";
    static final String PROP_ANIMATING = "animating";
    static final String DEFAULT_STYLE = "Normal";
    private static Object sProgressBarCtorLock = new Object();
    private final ViewManagerDelegate<ProgressBarContainerView> mDelegate = new AndroidProgressBarManagerDelegate<ProgressBarContainerView, ReactProgressBarViewManager>(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProgressBar createProgressBar(Context context, int style2) {
        Object object = sProgressBarCtorLock;
        synchronized (object) {
            return new ProgressBar(context, null, style2);
        }
    }

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected ProgressBarContainerView createViewInstance(ThemedReactContext context) {
        return new ProgressBarContainerView((Context)context);
    }

    @Override
    @ReactProp(name="styleAttr")
    public void setStyleAttr(ProgressBarContainerView view, @Nullable String styleName) {
        view.setStyle(styleName);
    }

    @Override
    @ReactProp(name="color", customType="Color")
    public void setColor(ProgressBarContainerView view, @Nullable Integer color) {
        view.setColor(color);
    }

    @Override
    @ReactProp(name="indeterminate")
    public void setIndeterminate(ProgressBarContainerView view, boolean indeterminate) {
        view.setIndeterminate(indeterminate);
    }

    @Override
    @ReactProp(name="progress")
    public void setProgress(ProgressBarContainerView view, double progress) {
        view.setProgress(progress);
    }

    @Override
    @ReactProp(name="animating")
    public void setAnimating(ProgressBarContainerView view, boolean animating) {
        view.setAnimating(animating);
    }

    @Override
    public void setTestID(ProgressBarContainerView view, @Nullable String value) {
        super.setTestId(view, value);
    }

    @Override
    public void setTypeAttr(ProgressBarContainerView view, @Nullable String value) {
    }

    @Override
    public ProgressBarShadowNode createShadowNodeInstance() {
        return new ProgressBarShadowNode();
    }

    @Override
    public Class<ProgressBarShadowNode> getShadowNodeClass() {
        return ProgressBarShadowNode.class;
    }

    @Override
    public void updateExtraData(ProgressBarContainerView root, Object extraData) {
    }

    @Override
    protected void onAfterUpdateTransaction(ProgressBarContainerView view) {
        view.apply();
    }

    @Override
    protected ViewManagerDelegate<ProgressBarContainerView> getDelegate() {
        return this.mDelegate;
    }

    static int getStyleFromString(@Nullable String styleStr) {
        if (styleStr == null) {
            throw new JSApplicationIllegalArgumentException("ProgressBar needs to have a style, null received");
        }
        if (styleStr.equals("Horizontal")) {
            return 16842872;
        }
        if (styleStr.equals("Small")) {
            return 16842873;
        }
        if (styleStr.equals("Large")) {
            return 16842874;
        }
        if (styleStr.equals("Inverse")) {
            return 16843399;
        }
        if (styleStr.equals("SmallInverse")) {
            return 16843400;
        }
        if (styleStr.equals("LargeInverse")) {
            return 16843401;
        }
        if (styleStr.equals(DEFAULT_STYLE)) {
            return 0x1010077;
        }
        throw new JSApplicationIllegalArgumentException("Unknown ProgressBar style: " + styleStr);
    }
}

