/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.art;

import android.content.Context;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.views.art.ARTSurfaceView;
import com.facebook.react.views.art.ARTSurfaceViewShadowNode;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaNode;

@ReactModule(name="ARTSurfaceView")
public class ARTSurfaceViewManager
extends BaseViewManager<ARTSurfaceView, ARTSurfaceViewShadowNode> {
    public static final String REACT_CLASS = "ARTSurfaceView";
    private static final YogaMeasureFunction MEASURE_FUNCTION = new YogaMeasureFunction(){

        @Override
        public long measure(YogaNode node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
            throw new IllegalStateException("SurfaceView should have explicit width and height set");
        }
    };

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ARTSurfaceViewShadowNode createShadowNodeInstance() {
        ARTSurfaceViewShadowNode node = new ARTSurfaceViewShadowNode();
        node.setMeasureFunction(MEASURE_FUNCTION);
        return node;
    }

    @Override
    public Class<ARTSurfaceViewShadowNode> getShadowNodeClass() {
        return ARTSurfaceViewShadowNode.class;
    }

    @Override
    protected ARTSurfaceView createViewInstance(ThemedReactContext reactContext) {
        return new ARTSurfaceView((Context)reactContext);
    }

    @Override
    public void updateExtraData(ARTSurfaceView root, Object extraData) {
        ARTSurfaceViewShadowNode shadowNode = (ARTSurfaceViewShadowNode)extraData;
        shadowNode.setupSurfaceTextureListener(root);
    }

    @Override
    public void setBackgroundColor(ARTSurfaceView view, int backgroundColor) {
    }
}

