/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.timepicker;

import android.app.Dialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.text.format.DateFormat;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import com.facebook.react.modules.timepicker.DismissableTimePickerDialog;
import com.facebook.react.modules.timepicker.TimePickerMode;
import java.util.Calendar;
import java.util.Locale;

public class TimePickerDialogFragment
extends DialogFragment {
    @Nullable
    private TimePickerDialog.OnTimeSetListener mOnTimeSetListener;
    @Nullable
    private DialogInterface.OnDismissListener mOnDismissListener;

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        return TimePickerDialogFragment.createDialog(args, (Context)this.getActivity(), this.mOnTimeSetListener);
    }

    static Dialog createDialog(Bundle args, Context activityContext, @Nullable TimePickerDialog.OnTimeSetListener onTimeSetListener) {
        Calendar now = Calendar.getInstance();
        int hour = now.get(11);
        int minute = now.get(12);
        boolean is24hour = DateFormat.is24HourFormat((Context)activityContext);
        TimePickerMode mode = TimePickerMode.DEFAULT;
        if (args != null && args.getString("mode", null) != null) {
            mode = TimePickerMode.valueOf(args.getString("mode").toUpperCase(Locale.US));
        }
        if (args != null) {
            hour = args.getInt("hour", now.get(11));
            minute = args.getInt("minute", now.get(12));
            is24hour = args.getBoolean("is24Hour", DateFormat.is24HourFormat((Context)activityContext));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            if (mode == TimePickerMode.CLOCK) {
                return new DismissableTimePickerDialog(activityContext, activityContext.getResources().getIdentifier("ClockTimePickerDialog", "style", activityContext.getPackageName()), onTimeSetListener, hour, minute, is24hour);
            }
            if (mode == TimePickerMode.SPINNER) {
                return new DismissableTimePickerDialog(activityContext, activityContext.getResources().getIdentifier("SpinnerTimePickerDialog", "style", activityContext.getPackageName()), onTimeSetListener, hour, minute, is24hour);
            }
        }
        return new DismissableTimePickerDialog(activityContext, onTimeSetListener, hour, minute, is24hour);
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    public void setOnDismissListener(@Nullable DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    public void setOnTimeSetListener(@Nullable TimePickerDialog.OnTimeSetListener onTimeSetListener) {
        this.mOnTimeSetListener = onTimeSetListener;
    }
}

