/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.appearance;

import android.content.Context;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DeviceEventManagerModule;

@ReactModule(name="Appearance")
public class AppearanceModule
extends ReactContextBaseJavaModule {
    public static final String NAME = "Appearance";
    private static final String APPEARANCE_CHANGED_EVENT_NAME = "appearanceChanged";
    private String mColorScheme = "light";

    public AppearanceModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mColorScheme = AppearanceModule.colorSchemeForCurrentConfiguration((Context)reactContext);
    }

    private static String colorSchemeForCurrentConfiguration(Context context) {
        int currentNightMode = context.getResources().getConfiguration().uiMode & 0x30;
        switch (currentNightMode) {
            case 16: {
                return "light";
            }
            case 32: {
                return "dark";
            }
        }
        return "light";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ReactMethod(isBlockingSynchronousMethod=true)
    public String getColorScheme() {
        this.mColorScheme = AppearanceModule.colorSchemeForCurrentConfiguration((Context)this.getReactApplicationContext());
        return this.mColorScheme;
    }

    @ReactMethod
    public void addListener(String eventName) {
    }

    @ReactMethod
    public void removeListeners(double count) {
    }

    public void onConfigurationChanged(Context currentContext) {
        String newColorScheme = AppearanceModule.colorSchemeForCurrentConfiguration(currentContext);
        if (!this.mColorScheme.equals(newColorScheme)) {
            this.mColorScheme = newColorScheme;
            this.emitAppearanceChanged(this.mColorScheme);
        }
    }

    public void emitAppearanceChanged(String colorScheme) {
        WritableMap appearancePreferences = Arguments.createMap();
        appearancePreferences.putString("colorScheme", colorScheme);
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
        if (reactApplicationContext != null) {
            reactApplicationContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit(APPEARANCE_CHANGED_EVENT_NAME, appearancePreferences);
        }
    }
}

