/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting.mountitems;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;

public class CreateMountItem
implements MountItem {
    @NonNull
    private final String mComponent;
    private final int mRootTag;
    private final int mReactTag;
    @NonNull
    private final ThemedReactContext mContext;
    @Nullable
    private final ReadableMap mProps;
    @Nullable
    private final StateWrapper mStateWrapper;
    private final boolean mIsLayoutable;

    public CreateMountItem(@NonNull ThemedReactContext context, int rootTag, int reactTag, @NonNull String component, @Nullable ReadableMap props, @NonNull StateWrapper stateWrapper, boolean isLayoutable) {
        this.mContext = context;
        this.mComponent = component;
        this.mRootTag = rootTag;
        this.mReactTag = reactTag;
        this.mProps = props;
        this.mStateWrapper = stateWrapper;
        this.mIsLayoutable = isLayoutable;
    }

    @Override
    public void execute(@NonNull MountingManager mountingManager) {
        mountingManager.createView(this.mContext, this.mComponent, this.mReactTag, this.mProps, this.mStateWrapper, this.mIsLayoutable);
    }

    public String toString() {
        return "CreateMountItem [" + this.mReactTag + "] - component: " + this.mComponent + " - rootTag: " + this.mRootTag + " - isLayoutable: " + this.mIsLayoutable;
    }
}

