/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.os.Build;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.LruCache;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.views.text.CustomLetterSpacingSpan;
import com.facebook.react.views.text.CustomLineHeightSpan;
import com.facebook.react.views.text.CustomStyleSpan;
import com.facebook.react.views.text.ReactAbsoluteSizeSpan;
import com.facebook.react.views.text.ReactBackgroundColorSpan;
import com.facebook.react.views.text.ReactForegroundColorSpan;
import com.facebook.react.views.text.ReactSpan;
import com.facebook.react.views.text.ReactStrikethroughSpan;
import com.facebook.react.views.text.ReactTagSpan;
import com.facebook.react.views.text.ReactUnderlineSpan;
import com.facebook.react.views.text.ShadowStyleSpan;
import com.facebook.react.views.text.TextAttributeProps;
import com.facebook.react.views.text.TextTransform;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import java.util.ArrayList;
import java.util.List;

public class TextLayoutManager {
    private static final TextPaint sTextPaintInstance = new TextPaint(1);
    private static final int spannableCacheSize = 100;
    private static final Object sSpannableCacheLock = new Object();
    private static LruCache<String, Spannable> sSpannableCache = new LruCache(100);

    private static void buildSpannableFromFragment(Context context, ReadableArray fragments, SpannableStringBuilder sb, List<SetSpanOperation> ops) {
        int length = fragments.size();
        for (int i = 0; i < length; ++i) {
            ReadableMap fragment = fragments.getMap(i);
            int start = sb.length();
            TextAttributeProps textAttributes = new TextAttributeProps(new ReactStylesDiffMap(fragment.getMap("textAttributes")));
            sb.append((CharSequence)TextTransform.apply(fragment.getString("string"), textAttributes.mTextTransform));
            int end = sb.length();
            if (end < start) continue;
            if (textAttributes.mIsColorSet) {
                ops.add(new SetSpanOperation(start, end, new ReactForegroundColorSpan(textAttributes.mColor)));
            }
            if (textAttributes.mIsBackgroundColorSet) {
                ops.add(new SetSpanOperation(start, end, new ReactBackgroundColorSpan(textAttributes.mBackgroundColor)));
            }
            if (Build.VERSION.SDK_INT >= 21 && !Float.isNaN(textAttributes.mLetterSpacing)) {
                ops.add(new SetSpanOperation(start, end, new CustomLetterSpacingSpan(textAttributes.mLetterSpacing)));
            }
            ops.add(new SetSpanOperation(start, end, new ReactAbsoluteSizeSpan(textAttributes.mFontSize)));
            if (textAttributes.mFontStyle != -1 || textAttributes.mFontWeight != -1 || textAttributes.mFontFamily != null) {
                ops.add(new SetSpanOperation(start, end, new CustomStyleSpan(textAttributes.mFontStyle, textAttributes.mFontWeight, textAttributes.mFontFamily, context.getAssets())));
            }
            if (textAttributes.mIsUnderlineTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new ReactUnderlineSpan()));
            }
            if (textAttributes.mIsLineThroughTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new ReactStrikethroughSpan()));
            }
            if (textAttributes.mTextShadowOffsetDx != 0.0f || textAttributes.mTextShadowOffsetDy != 0.0f) {
                ops.add(new SetSpanOperation(start, end, new ShadowStyleSpan(textAttributes.mTextShadowOffsetDx, textAttributes.mTextShadowOffsetDy, textAttributes.mTextShadowRadius, textAttributes.mTextShadowColor)));
            }
            if (!Float.isNaN(textAttributes.getEffectiveLineHeight())) {
                ops.add(new SetSpanOperation(start, end, new CustomLineHeightSpan(textAttributes.getEffectiveLineHeight())));
            }
            int reactTag = fragment.getInt("reactTag");
            ops.add(new SetSpanOperation(start, end, new ReactTagSpan(reactTag)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Spannable getOrCreateSpannableForText(Context context, ReadableMap attributedString) {
        Spannable preparedSpannableText;
        String attributedStringPayload = attributedString.toString();
        Object object = sSpannableCacheLock;
        synchronized (object) {
            preparedSpannableText = (Spannable)sSpannableCache.get((Object)attributedStringPayload);
            if (preparedSpannableText != null) {
                return preparedSpannableText;
            }
        }
        preparedSpannableText = TextLayoutManager.createSpannableFromAttributedString(context, attributedString);
        object = sSpannableCacheLock;
        synchronized (object) {
            sSpannableCache.put((Object)attributedStringPayload, (Object)preparedSpannableText);
        }
        return preparedSpannableText;
    }

    private static Spannable createSpannableFromAttributedString(Context context, ReadableMap attributedString) {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        ArrayList<SetSpanOperation> ops = new ArrayList<SetSpanOperation>();
        TextLayoutManager.buildSpannableFromFragment(context, attributedString.getArray("fragments"), sb, ops);
        int priority = 0;
        for (SetSpanOperation op : ops) {
            op.execute(sb, priority);
            ++priority;
        }
        return sb;
    }

    public static long measureText(ReactContext context, ReadableNativeMap attributedString, ReadableNativeMap paragraphAttributes, float width, YogaMeasureMode widthYogaMeasureMode, float height, YogaMeasureMode heightYogaMeasureMode) {
        Object layout2;
        boolean unconstrainedWidth;
        TextPaint textPaint = sTextPaintInstance;
        Spannable preparedSpannableText = TextLayoutManager.getOrCreateSpannableForText((Context)context, attributedString);
        int textBreakStrategy = 1;
        boolean includeFontPadding = true;
        if (preparedSpannableText == null) {
            throw new IllegalStateException("Spannable element has not been prepared in onBeforeLayout");
        }
        Spannable text = preparedSpannableText;
        BoringLayout.Metrics boring = BoringLayout.isBoring((CharSequence)text, (TextPaint)textPaint);
        float desiredWidth = boring == null ? Layout.getDesiredWidth((CharSequence)text, (TextPaint)textPaint) : Float.NaN;
        boolean bl = unconstrainedWidth = widthYogaMeasureMode == YogaMeasureMode.UNDEFINED || width < 0.0f;
        if (boring == null && (unconstrainedWidth || !YogaConstants.isUndefined(desiredWidth) && desiredWidth <= width)) {
            int hintWidth = (int)Math.ceil(desiredWidth);
            layout2 = Build.VERSION.SDK_INT < 23 ? new StaticLayout((CharSequence)text, textPaint, hintWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, includeFontPadding) : StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)textPaint, (int)hintWidth).setAlignment(Layout.Alignment.ALIGN_NORMAL).setLineSpacing(0.0f, 1.0f).setIncludePad(includeFontPadding).setBreakStrategy(textBreakStrategy).setHyphenationFrequency(1).build();
        } else {
            layout2 = boring != null && (unconstrainedWidth || (float)boring.width <= width) ? BoringLayout.make((CharSequence)text, (TextPaint)textPaint, (int)boring.width, (Layout.Alignment)Layout.Alignment.ALIGN_NORMAL, (float)1.0f, (float)0.0f, (BoringLayout.Metrics)boring, (boolean)includeFontPadding) : (Build.VERSION.SDK_INT < 23 ? new StaticLayout((CharSequence)text, textPaint, (int)width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, includeFontPadding) : StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)textPaint, (int)((int)width)).setAlignment(Layout.Alignment.ALIGN_NORMAL).setLineSpacing(0.0f, 1.0f).setIncludePad(includeFontPadding).setBreakStrategy(textBreakStrategy).setHyphenationFrequency(1).build());
        }
        int maximumNumberOfLines = paragraphAttributes.hasKey("maximumNumberOfLines") ? paragraphAttributes.getInt("maximumNumberOfLines") : -1;
        width = layout2.getWidth();
        height = maximumNumberOfLines != -1 && maximumNumberOfLines != 0 && maximumNumberOfLines < layout2.getLineCount() ? (float)layout2.getLineBottom(maximumNumberOfLines - 1) : (float)layout2.getHeight();
        return YogaMeasureOutput.make(PixelUtil.toSPFromPixel(width), PixelUtil.toSPFromPixel(height));
    }

    public static class SetSpanOperation {
        protected int start;
        protected int end;
        protected ReactSpan what;

        SetSpanOperation(int start, int end, ReactSpan what) {
            this.start = start;
            this.end = end;
            this.what = what;
        }

        public void execute(SpannableStringBuilder sb, int priority) {
            int spanFlags = 34;
            if (this.start == 0) {
                spanFlags = 18;
            }
            spanFlags &= 0xFF00FFFF;
            sb.setSpan((Object)this.what, this.start, this.end, spanFlags |= priority << 16 & 0xFF0000);
        }
    }
}

