/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.datepicker;

import android.app.DatePickerDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.widget.DatePicker;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.datepicker.DatePickerDialogFragment;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ReactModule(name="DatePickerAndroid")
public class DatePickerDialogModule
extends ReactContextBaseJavaModule {
    @VisibleForTesting
    public static final String FRAGMENT_TAG = "DatePickerAndroid";
    private static final String ERROR_NO_ACTIVITY = "E_NO_ACTIVITY";
    static final String ARG_DATE = "date";
    static final String ARG_MINDATE = "minDate";
    static final String ARG_MAXDATE = "maxDate";
    static final String ARG_MODE = "mode";
    static final String ACTION_DATE_SET = "dateSetAction";
    static final String ACTION_DISMISSED = "dismissedAction";

    public DatePickerDialogModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    @Nonnull
    public String getName() {
        return FRAGMENT_TAG;
    }

    @ReactMethod
    public void open(@Nullable ReadableMap options, Promise promise) {
        FragmentActivity activity = (FragmentActivity)this.getCurrentActivity();
        if (activity == null) {
            promise.reject(ERROR_NO_ACTIVITY, "Tried to open a DatePicker dialog while not attached to an Activity");
            return;
        }
        FragmentManager fragmentManager = activity.getSupportFragmentManager();
        DialogFragment oldFragment = (DialogFragment)fragmentManager.findFragmentByTag(FRAGMENT_TAG);
        if (oldFragment != null) {
            oldFragment.dismiss();
        }
        DatePickerDialogFragment fragment = new DatePickerDialogFragment();
        if (options != null) {
            Bundle args = this.createFragmentArguments(options);
            fragment.setArguments(args);
        }
        DatePickerDialogListener listener = new DatePickerDialogListener(promise);
        fragment.setOnDismissListener(listener);
        fragment.setOnDateSetListener(listener);
        fragment.show(fragmentManager, FRAGMENT_TAG);
    }

    private Bundle createFragmentArguments(ReadableMap options) {
        Bundle args = new Bundle();
        if (options.hasKey(ARG_DATE) && !options.isNull(ARG_DATE)) {
            args.putLong(ARG_DATE, (long)options.getDouble(ARG_DATE));
        }
        if (options.hasKey(ARG_MINDATE) && !options.isNull(ARG_MINDATE)) {
            args.putLong(ARG_MINDATE, (long)options.getDouble(ARG_MINDATE));
        }
        if (options.hasKey(ARG_MAXDATE) && !options.isNull(ARG_MAXDATE)) {
            args.putLong(ARG_MAXDATE, (long)options.getDouble(ARG_MAXDATE));
        }
        if (options.hasKey(ARG_MODE) && !options.isNull(ARG_MODE)) {
            args.putString(ARG_MODE, options.getString(ARG_MODE));
        }
        return args;
    }

    private class DatePickerDialogListener
    implements DatePickerDialog.OnDateSetListener,
    DialogInterface.OnDismissListener {
        private final Promise mPromise;
        private boolean mPromiseResolved = false;

        public DatePickerDialogListener(Promise promise) {
            this.mPromise = promise;
        }

        public void onDateSet(DatePicker view, int year, int month, int day) {
            if (!this.mPromiseResolved && DatePickerDialogModule.this.getReactApplicationContext().hasActiveCatalystInstance()) {
                WritableNativeMap result = new WritableNativeMap();
                result.putString("action", DatePickerDialogModule.ACTION_DATE_SET);
                result.putInt("year", year);
                result.putInt("month", month);
                result.putInt("day", day);
                this.mPromise.resolve(result);
                this.mPromiseResolved = true;
            }
        }

        public void onDismiss(DialogInterface dialog) {
            if (!this.mPromiseResolved && DatePickerDialogModule.this.getReactApplicationContext().hasActiveCatalystInstance()) {
                WritableNativeMap result = new WritableNativeMap();
                result.putString("action", DatePickerDialogModule.ACTION_DISMISSED);
                this.mPromise.resolve(result);
                this.mPromiseResolved = true;
            }
        }
    }
}

