/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.content.Context;
import android.util.Log;
import com.facebook.react.bridge.CatalystInstanceImpl;
import com.facebook.react.bridge.JSBundleLoaderDelegate;
import com.facebook.react.bridge.NativeDeltaClient;
import com.facebook.react.common.DebugServerException;
import com.facebook.react.common.JavascriptException;

public abstract class JSBundleLoader {
    public static JSBundleLoader createAssetLoader(final Context context, final String assetUrl, final boolean loadSynchronously) {
        return new JSBundleLoader(){

            @Override
            public String loadScript(JSBundleLoaderDelegate delegate) {
                delegate.loadScriptFromAssets(context.getAssets(), assetUrl, loadSynchronously);
                return assetUrl;
            }
        };
    }

    public static JSBundleLoader createFileLoader(String fileName) {
        return JSBundleLoader.createFileLoader(fileName, fileName, false);
    }

    public static JSBundleLoader createFileLoader(final String fileName, final String assetUrl, boolean loadSynchronously) {
        return new JSBundleLoader(){

            @Override
            public String loadScript(JSBundleLoaderDelegate delegate) {
                Log.e((String)"kris test url", (String)("" + fileName + "  " + assetUrl));
                Log.e((String)"kris", (String)("bundle file load error : " + fileName));
                CatalystInstanceImpl impl = (CatalystInstanceImpl)delegate;
                impl.onNativeException(new JavascriptException("bundle file now found"));
                return fileName;
            }
        };
    }

    public static JSBundleLoader createCachedBundleFromNetworkLoader(final String sourceURL, final String cachedFileLocation) {
        return new JSBundleLoader(){

            @Override
            public String loadScript(JSBundleLoaderDelegate delegate) {
                try {
                    delegate.loadScriptFromFile(cachedFileLocation, sourceURL, false);
                    return sourceURL;
                }
                catch (Exception e) {
                    throw DebugServerException.makeGeneric(e.getMessage(), e);
                }
            }
        };
    }

    public static JSBundleLoader createDeltaFromNetworkLoader(final String sourceURL, final NativeDeltaClient nativeDeltaClient) {
        return new JSBundleLoader(){

            @Override
            public String loadScript(JSBundleLoaderDelegate delegate) {
                try {
                    delegate.loadScriptFromDeltaBundle(sourceURL, nativeDeltaClient, false);
                    return sourceURL;
                }
                catch (Exception e) {
                    throw DebugServerException.makeGeneric(e.getMessage(), e);
                }
            }
        };
    }

    public static JSBundleLoader createRemoteDebuggerBundleLoader(final String proxySourceURL, final String realSourceURL) {
        return new JSBundleLoader(){

            @Override
            public String loadScript(JSBundleLoaderDelegate delegate) {
                delegate.setSourceURLs(realSourceURL, proxySourceURL);
                return realSourceURL;
            }
        };
    }

    public abstract String loadScript(JSBundleLoaderDelegate var1);
}

