/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.imagehelper;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ResourceDrawableIdHelper {
    private Map<String, Integer> mResourceDrawableIdMap = new HashMap<String, Integer>();
    private static final String LOCAL_RESOURCE_SCHEME = "res";
    private static volatile ResourceDrawableIdHelper sResourceDrawableIdHelper;

    private ResourceDrawableIdHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceDrawableIdHelper getInstance() {
        if (sResourceDrawableIdHelper != null) return sResourceDrawableIdHelper;
        Class<ResourceDrawableIdHelper> clazz = ResourceDrawableIdHelper.class;
        synchronized (ResourceDrawableIdHelper.class) {
            if (sResourceDrawableIdHelper != null) return sResourceDrawableIdHelper;
            sResourceDrawableIdHelper = new ResourceDrawableIdHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sResourceDrawableIdHelper;
        }
    }

    public synchronized void clear() {
        this.mResourceDrawableIdMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResourceDrawableId(Context context, @Nullable String name) {
        if (name == null || name.isEmpty()) {
            return 0;
        }
        name = name.toLowerCase().replace("-", "_");
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException numberFormatException) {
            ResourceDrawableIdHelper resourceDrawableIdHelper = this;
            synchronized (resourceDrawableIdHelper) {
                if (this.mResourceDrawableIdMap.containsKey(name)) {
                    return this.mResourceDrawableIdMap.get(name);
                }
                int id2 = context.getResources().getIdentifier(name, "drawable", context.getPackageName());
                this.mResourceDrawableIdMap.put(name, id2);
                return id2;
            }
        }
    }

    @Nullable
    public Drawable getResourceDrawable(Context context, @Nullable String name) {
        int resId = this.getResourceDrawableId(context, name);
        return resId > 0 ? context.getResources().getDrawable(resId) : null;
    }

    public Uri getResourceDrawableUri(Context context, @Nullable String name) {
        int resId = this.getResourceDrawableId(context, name);
        return resId > 0 ? new Uri.Builder().scheme(LOCAL_RESOURCE_SCHEME).path(String.valueOf(resId)).build() : Uri.EMPTY;
    }
}

