/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.turbomodule.core;

import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.JSIModule;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import com.facebook.soloader.SoLoader;

public class TurboModuleManager
implements JSIModule {
    private final ReactApplicationContext mReactApplicationContext;
    @DoNotStrip
    private final HybridData mHybridData;
    private final ModuleProvider mModuleProvider;

    public TurboModuleManager(ReactApplicationContext reactApplicationContext, JavaScriptContextHolder jsContext, ModuleProvider moduleProvider) {
        this.mReactApplicationContext = reactApplicationContext;
        MessageQueueThread jsMessageQueueThread = this.mReactApplicationContext.getCatalystInstance().getReactQueueConfiguration().getJSQueueThread();
        this.mHybridData = this.initHybrid(jsContext.get(), jsMessageQueueThread);
        this.mModuleProvider = moduleProvider;
    }

    @DoNotStrip
    protected TurboModule getJavaModule(String name) {
        return this.mModuleProvider.getModule(name, this.mReactApplicationContext);
    }

    protected native HybridData initHybrid(long var1, MessageQueueThread var3);

    protected native void installJSIBindings();

    public void installBindings() {
        this.installJSIBindings();
    }

    protected ReactApplicationContext getReactApplicationContext() {
        return this.mReactApplicationContext;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void onCatalystInstanceDestroy() {
    }

    static {
        SoLoader.loadLibrary((String)"turbomodulejsijni");
    }

    public static interface ModuleProvider {
        public TurboModule getModule(String var1, ReactApplicationContext var2);
    }
}

