/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.ReactAndroidHWInputDeviceHelper;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.modules.appregistry.AppRegistry;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.deviceinfo.DeviceInfoModule;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.JSTouchDispatcher;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.common.MeasureSpecProvider;
import com.facebook.react.uimanager.common.SizeMonitoringFrameLayout;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.systrace.Systrace;
import javax.annotation.Nullable;

public class ReactRootView
extends SizeMonitoringFrameLayout
implements RootView,
MeasureSpecProvider {
    @Nullable
    private ReactInstanceManager mReactInstanceManager;
    @Nullable
    private String mJSModuleName;
    @Nullable
    private Bundle mAppProperties;
    @Nullable
    private String mInitialUITemplate;
    @Nullable
    private CustomGlobalLayoutListener mCustomGlobalLayoutListener;
    @Nullable
    private ReactRootViewEventListener mRootViewEventListener;
    private int mRootViewTag;
    private boolean mIsAttachedToInstance;
    private boolean mShouldLogContentAppeared;
    @Nullable
    private JSTouchDispatcher mJSTouchDispatcher;
    private final ReactAndroidHWInputDeviceHelper mAndroidHWInputDeviceHelper = new ReactAndroidHWInputDeviceHelper(this);
    private boolean mWasMeasured = false;
    private int mWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    private int mHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    private int mUIManagerType = 1;

    public ReactRootView(Context context) {
        super(context);
        this.init();
    }

    public ReactRootView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ReactRootView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.setClipChildren(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Systrace.beginSection(0L, "ReactRootView.onMeasure");
        try {
            int heightMode;
            this.mWidthMeasureSpec = widthMeasureSpec;
            this.mHeightMeasureSpec = heightMeasureSpec;
            int width = 0;
            int height = 0;
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            if (widthMode == Integer.MIN_VALUE || widthMode == 0) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    View child = this.getChildAt(i);
                    int childSize = child.getLeft() + child.getMeasuredWidth() + child.getPaddingLeft() + child.getPaddingRight();
                    width = Math.max(width, childSize);
                }
            } else {
                width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            }
            if ((heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec)) == Integer.MIN_VALUE || heightMode == 0) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    View child = this.getChildAt(i);
                    int childSize = child.getTop() + child.getMeasuredHeight() + child.getPaddingTop() + child.getPaddingBottom();
                    height = Math.max(height, childSize);
                }
            } else {
                height = View.MeasureSpec.getSize((int)heightMeasureSpec);
            }
            this.setMeasuredDimension(width, height);
            this.mWasMeasured = true;
            if (this.mReactInstanceManager != null && !this.mIsAttachedToInstance) {
                this.attachToReactInstanceManager();
                this.enableLayoutCalculation();
            } else {
                this.enableLayoutCalculation();
                this.updateRootLayoutSpecs(this.mWidthMeasureSpec, this.mHeightMeasureSpec);
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    @Override
    public int getWidthMeasureSpec() {
        if (!this.mWasMeasured && this.getLayoutParams() != null && this.getLayoutParams().width > 0) {
            return View.MeasureSpec.makeMeasureSpec((int)this.getLayoutParams().width, (int)0x40000000);
        }
        return this.mWidthMeasureSpec;
    }

    @Override
    public int getHeightMeasureSpec() {
        if (!this.mWasMeasured && this.getLayoutParams() != null && this.getLayoutParams().height > 0) {
            return View.MeasureSpec.makeMeasureSpec((int)this.getLayoutParams().height, (int)0x40000000);
        }
        return this.mHeightMeasureSpec;
    }

    @Override
    public void onChildStartedNativeGesture(MotionEvent androidEvent) {
        if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance || this.mReactInstanceManager.getCurrentReactContext() == null) {
            FLog.w((String)"ReactNative", (String)"Unable to dispatch touch to JS as the catalyst instance has not been attached");
            return;
        }
        if (this.mJSTouchDispatcher == null) {
            FLog.w((String)"ReactNative", (String)"Unable to dispatch touch to JS before the dispatcher is available");
            return;
        }
        ReactContext reactContext = this.mReactInstanceManager.getCurrentReactContext();
        EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        this.mJSTouchDispatcher.onChildStartedNativeGesture(androidEvent, eventDispatcher);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.dispatchJSTouchEvent(ev);
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.dispatchJSTouchEvent(ev);
        super.onTouchEvent(ev);
        return true;
    }

    protected void dispatchDraw(Canvas canvas) {
        try {
            super.dispatchDraw(canvas);
        }
        catch (StackOverflowError e) {
            this.handleException(e);
        }
    }

    public boolean dispatchKeyEvent(KeyEvent ev) {
        if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance || this.mReactInstanceManager.getCurrentReactContext() == null) {
            FLog.w((String)"ReactNative", (String)"Unable to handle key event as the catalyst instance has not been attached");
            return super.dispatchKeyEvent(ev);
        }
        this.mAndroidHWInputDeviceHelper.handleKeyEvent(ev);
        return super.dispatchKeyEvent(ev);
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance || this.mReactInstanceManager.getCurrentReactContext() == null) {
            FLog.w((String)"ReactNative", (String)"Unable to handle focus changed event as the catalyst instance has not been attached");
            super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
            return;
        }
        this.mAndroidHWInputDeviceHelper.clearFocus();
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
    }

    public void requestChildFocus(View child, View focused) {
        if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance || this.mReactInstanceManager.getCurrentReactContext() == null) {
            FLog.w((String)"ReactNative", (String)"Unable to handle child focus changed event as the catalyst instance has not been attached");
            super.requestChildFocus(child, focused);
            return;
        }
        this.mAndroidHWInputDeviceHelper.onFocusChanged(focused);
        super.requestChildFocus(child, focused);
    }

    private void dispatchJSTouchEvent(MotionEvent event) {
        if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance || this.mReactInstanceManager.getCurrentReactContext() == null) {
            FLog.w((String)"ReactNative", (String)"Unable to dispatch touch to JS as the catalyst instance has not been attached");
            return;
        }
        if (this.mJSTouchDispatcher == null) {
            FLog.w((String)"ReactNative", (String)"Unable to dispatch touch to JS before the dispatcher is available");
            return;
        }
        ReactContext reactContext = this.mReactInstanceManager.getCurrentReactContext();
        EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        this.mJSTouchDispatcher.handleTouchEvent(event, eventDispatcher);
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mIsAttachedToInstance) {
            this.removeOnGlobalLayoutListener();
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.getCustomGlobalLayoutListener());
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mIsAttachedToInstance) {
            this.removeOnGlobalLayoutListener();
        }
    }

    private void removeOnGlobalLayoutListener() {
        this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.getCustomGlobalLayoutListener());
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        if (this.mShouldLogContentAppeared) {
            this.mShouldLogContentAppeared = false;
            if (this.mJSModuleName != null) {
                ReactMarker.logMarker(ReactMarkerConstants.CONTENT_APPEARED, this.mJSModuleName, this.mRootViewTag);
            }
        }
    }

    public void startReactApplication(ReactInstanceManager reactInstanceManager, String moduleName) {
        this.startReactApplication(reactInstanceManager, moduleName, null);
    }

    public void startReactApplication(ReactInstanceManager reactInstanceManager, String moduleName, @Nullable Bundle initialProperties) {
        this.startReactApplication(reactInstanceManager, moduleName, initialProperties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReactApplication(ReactInstanceManager reactInstanceManager, String moduleName, @Nullable Bundle initialProperties, @Nullable String initialUITemplate) {
        Systrace.beginSection(0L, "startReactApplication");
        try {
            UiThreadUtil.assertOnUiThread();
            Assertions.assertCondition((this.mReactInstanceManager == null ? 1 : 0) != 0, (String)"This root view has already been attached to a catalyst instance manager");
            this.mReactInstanceManager = reactInstanceManager;
            this.mJSModuleName = moduleName;
            this.mAppProperties = initialProperties;
            this.mInitialUITemplate = initialUITemplate;
            if (!this.mReactInstanceManager.hasStartedCreatingInitialContext()) {
                this.mReactInstanceManager.createReactContextInBackground();
            }
            this.attachToReactInstanceManager();
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    private void enableLayoutCalculation() {
        if (this.mReactInstanceManager == null) {
            FLog.w((String)"ReactNative", (String)"Unable to enable layout calculation for uninitialized ReactInstanceManager");
            return;
        }
        ReactContext reactApplicationContext = this.mReactInstanceManager.getCurrentReactContext();
        if (reactApplicationContext != null) {
            if (reactApplicationContext.getCatalystInstance() == null || reactApplicationContext.getCatalystInstance().getNativeModule(UIManagerModule.class) == null) {
                return;
            }
            reactApplicationContext.getCatalystInstance().getNativeModule(UIManagerModule.class).getUIImplementation().enableLayoutCalculationForRootNode(this.getRootViewTag());
        }
    }

    private void updateRootLayoutSpecs(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mReactInstanceManager == null) {
            FLog.w((String)"ReactNative", (String)"Unable to update root layout specs for uninitialized ReactInstanceManager");
            return;
        }
        ReactContext reactApplicationContext = this.mReactInstanceManager.getCurrentReactContext();
        if (reactApplicationContext != null) {
            UIManagerHelper.getUIManager(reactApplicationContext, this.getUIManagerType()).updateRootLayoutSpecs(this.getRootViewTag(), widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void unmountReactApplication() {
        if (this.mReactInstanceManager != null && this.mIsAttachedToInstance) {
            this.mReactInstanceManager.detachRootView(this);
            this.mReactInstanceManager = null;
            this.mIsAttachedToInstance = false;
        }
        this.mShouldLogContentAppeared = false;
    }

    public void onAttachedToReactInstance() {
        this.mJSTouchDispatcher = new JSTouchDispatcher((ViewGroup)this);
        if (this.mRootViewEventListener != null) {
            this.mRootViewEventListener.onAttachedToReactInstance(this);
        }
    }

    public void setEventListener(ReactRootViewEventListener eventListener) {
        this.mRootViewEventListener = eventListener;
    }

    String getJSModuleName() {
        return (String)Assertions.assertNotNull((Object)this.mJSModuleName);
    }

    @Nullable
    public Bundle getAppProperties() {
        return this.mAppProperties;
    }

    @Nullable
    public String getInitialUITemplate() {
        return this.mInitialUITemplate;
    }

    public void setAppProperties(@Nullable Bundle appProperties) {
        UiThreadUtil.assertOnUiThread();
        this.mAppProperties = appProperties;
        if (this.getRootViewTag() != 0) {
            this.runApplication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runApplication() {
        Systrace.beginSection(0L, "ReactRootView.runApplication");
        try {
            if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance) {
                return;
            }
            ReactContext reactContext = this.mReactInstanceManager.getCurrentReactContext();
            if (reactContext == null) {
                return;
            }
            CatalystInstance catalystInstance = reactContext.getCatalystInstance();
            WritableNativeMap appParams = new WritableNativeMap();
            appParams.putDouble("rootTag", this.getRootViewTag());
            Bundle appProperties = this.getAppProperties();
            if (appProperties != null) {
                appParams.putMap("initialProps", Arguments.fromBundle(appProperties));
            }
            if (this.getUIManagerType() == 2) {
                appParams.putBoolean("fabric", true);
            }
            this.mShouldLogContentAppeared = true;
            String jsAppModuleName = this.getJSModuleName();
            catalystInstance.getJSModule(AppRegistry.class).runApplication(jsAppModuleName, appParams);
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    @VisibleForTesting
    void simulateAttachForTesting() {
        this.mIsAttachedToInstance = true;
        this.mJSTouchDispatcher = new JSTouchDispatcher((ViewGroup)this);
    }

    private CustomGlobalLayoutListener getCustomGlobalLayoutListener() {
        if (this.mCustomGlobalLayoutListener == null) {
            this.mCustomGlobalLayoutListener = new CustomGlobalLayoutListener();
        }
        return this.mCustomGlobalLayoutListener;
    }

    private void attachToReactInstanceManager() {
        Systrace.beginSection(0L, "attachToReactInstanceManager");
        try {
            if (this.mIsAttachedToInstance) {
                return;
            }
            this.mIsAttachedToInstance = true;
            ((ReactInstanceManager)Assertions.assertNotNull((Object)this.mReactInstanceManager)).attachRootView(this);
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.getCustomGlobalLayoutListener());
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Assertions.assertCondition((!this.mIsAttachedToInstance ? 1 : 0) != 0, (String)"The application this ReactRootView was rendering was not unmounted before the ReactRootView was garbage collected. This usually means that your application is leaking large amounts of memory. To solve this, make sure to call ReactRootView#unmountReactApplication in the onDestroy() of your hosting Activity or in the onDestroyView() of your hosting Fragment.");
    }

    public int getRootViewTag() {
        return this.mRootViewTag;
    }

    public void setRootViewTag(int rootViewTag) {
        this.mRootViewTag = rootViewTag;
    }

    @Override
    public void handleException(Throwable t) {
        if (this.mReactInstanceManager == null || this.mReactInstanceManager.getCurrentReactContext() == null) {
            throw new RuntimeException(t);
        }
        IllegalViewOperationException e = new IllegalViewOperationException(t.getMessage(), (View)this, t);
        this.mReactInstanceManager.getCurrentReactContext().handleException(e);
    }

    public void setIsFabric(boolean isFabric) {
        this.mUIManagerType = isFabric ? 2 : 1;
    }

    public int getUIManagerType() {
        return this.mUIManagerType;
    }

    @Nullable
    public ReactInstanceManager getReactInstanceManager() {
        return this.mReactInstanceManager;
    }

    void sendEvent(String eventName, @Nullable WritableMap params) {
        if (this.mReactInstanceManager != null) {
            this.mReactInstanceManager.getCurrentReactContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit(eventName, params);
        }
    }

    private class CustomGlobalLayoutListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private final Rect mVisibleViewArea;
        private final int mMinKeyboardHeightDetected;
        private int mKeyboardHeight = 0;
        private int mDeviceRotation = 0;
        private DisplayMetrics mWindowMetrics = new DisplayMetrics();
        private DisplayMetrics mScreenMetrics = new DisplayMetrics();

        CustomGlobalLayoutListener() {
            DisplayMetricsHolder.initDisplayMetricsIfNotInitialized(ReactRootView.this.getContext().getApplicationContext());
            this.mVisibleViewArea = new Rect();
            this.mMinKeyboardHeightDetected = (int)PixelUtil.toPixelFromDIP(60.0f);
        }

        public void onGlobalLayout() {
            if (ReactRootView.this.mReactInstanceManager == null || !ReactRootView.this.mIsAttachedToInstance || ReactRootView.this.mReactInstanceManager.getCurrentReactContext() == null) {
                return;
            }
            this.checkForKeyboardEvents();
            this.checkForDeviceOrientationChanges();
            this.checkForDeviceDimensionsChanges();
        }

        private void checkForKeyboardEvents() {
            ReactRootView.this.getRootView().getWindowVisibleDisplayFrame(this.mVisibleViewArea);
            int heightDiff = DisplayMetricsHolder.getWindowDisplayMetrics().heightPixels - this.mVisibleViewArea.bottom;
            if (this.mKeyboardHeight != heightDiff && heightDiff > this.mMinKeyboardHeightDetected) {
                this.mKeyboardHeight = heightDiff;
                WritableMap params = Arguments.createMap();
                WritableMap coordinates = Arguments.createMap();
                coordinates.putDouble("screenY", PixelUtil.toDIPFromPixel(this.mVisibleViewArea.bottom));
                coordinates.putDouble("screenX", PixelUtil.toDIPFromPixel(this.mVisibleViewArea.left));
                coordinates.putDouble("width", PixelUtil.toDIPFromPixel(this.mVisibleViewArea.width()));
                coordinates.putDouble("height", PixelUtil.toDIPFromPixel(this.mKeyboardHeight));
                params.putMap("endCoordinates", coordinates);
                ReactRootView.this.sendEvent("keyboardDidShow", params);
            } else if (this.mKeyboardHeight != 0 && heightDiff <= this.mMinKeyboardHeightDetected) {
                this.mKeyboardHeight = 0;
                ReactRootView.this.sendEvent("keyboardDidHide", null);
            }
        }

        private void checkForDeviceOrientationChanges() {
            int rotation = ((WindowManager)ReactRootView.this.getContext().getSystemService("window")).getDefaultDisplay().getRotation();
            if (this.mDeviceRotation == rotation) {
                return;
            }
            this.mDeviceRotation = rotation;
            this.emitOrientationChanged(rotation);
        }

        private void checkForDeviceDimensionsChanges() {
            DisplayMetricsHolder.initDisplayMetrics(ReactRootView.this.getContext());
            if (!this.areMetricsEqual(this.mWindowMetrics, DisplayMetricsHolder.getWindowDisplayMetrics()) || !this.areMetricsEqual(this.mScreenMetrics, DisplayMetricsHolder.getScreenDisplayMetrics())) {
                this.mWindowMetrics.setTo(DisplayMetricsHolder.getWindowDisplayMetrics());
                this.mScreenMetrics.setTo(DisplayMetricsHolder.getScreenDisplayMetrics());
                this.emitUpdateDimensionsEvent();
            }
        }

        private boolean areMetricsEqual(DisplayMetrics displayMetrics, DisplayMetrics otherMetrics) {
            if (Build.VERSION.SDK_INT >= 17) {
                return displayMetrics.equals(otherMetrics);
            }
            return displayMetrics.widthPixels == otherMetrics.widthPixels && displayMetrics.heightPixels == otherMetrics.heightPixels && displayMetrics.density == otherMetrics.density && displayMetrics.densityDpi == otherMetrics.densityDpi && displayMetrics.scaledDensity == otherMetrics.scaledDensity && displayMetrics.xdpi == otherMetrics.xdpi && displayMetrics.ydpi == otherMetrics.ydpi;
        }

        private void emitOrientationChanged(int newRotation) {
            double rotationDegrees;
            String name;
            boolean isLandscape = false;
            switch (newRotation) {
                case 0: {
                    name = "portrait-primary";
                    rotationDegrees = 0.0;
                    break;
                }
                case 1: {
                    name = "landscape-primary";
                    rotationDegrees = -90.0;
                    isLandscape = true;
                    break;
                }
                case 2: {
                    name = "portrait-secondary";
                    rotationDegrees = 180.0;
                    break;
                }
                case 3: {
                    name = "landscape-secondary";
                    rotationDegrees = 90.0;
                    isLandscape = true;
                    break;
                }
                default: {
                    return;
                }
            }
            WritableMap map = Arguments.createMap();
            map.putString("name", name);
            map.putDouble("rotationDegrees", rotationDegrees);
            map.putBoolean("isLandscape", isLandscape);
            ReactRootView.this.sendEvent("namedOrientationDidChange", map);
        }

        private void emitUpdateDimensionsEvent() {
            ReactRootView.this.mReactInstanceManager.getCurrentReactContext().getNativeModule(DeviceInfoModule.class).emitUpdateDimensionsEvent();
        }
    }

    public static interface ReactRootViewEventListener {
        public void onAttachedToReactInstance(ReactRootView var1);
    }
}

