/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.i18nmanager;

import android.content.Context;
import com.facebook.react.bridge.ContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@ReactModule(name="I18nManager")
public class I18nManagerModule
extends ContextBaseJavaModule {
    public static final String NAME = "I18nManager";
    private final I18nUtil sharedI18nUtilInstance = I18nUtil.getInstance();

    public I18nManagerModule(Context context) {
        super(context);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Map<String, Object> getConstants() {
        Context context = this.getContext();
        Locale locale = context.getResources().getConfiguration().locale;
        HashMap<String, Object> constants = MapBuilder.newHashMap();
        constants.put("isRTL", this.sharedI18nUtilInstance.isRTL(context));
        constants.put("doLeftAndRightSwapInRTL", this.sharedI18nUtilInstance.doLeftAndRightSwapInRTL(context));
        constants.put("localeIdentifier", locale.toString());
        return constants;
    }

    @ReactMethod
    public void allowRTL(boolean value) {
        this.sharedI18nUtilInstance.allowRTL(this.getContext(), value);
    }

    @ReactMethod
    public void forceRTL(boolean value) {
        this.sharedI18nUtilInstance.forceRTL(this.getContext(), value);
    }

    @ReactMethod
    public void swapLeftAndRightInRTL(boolean value) {
        this.sharedI18nUtilInstance.swapLeftAndRightInRTL(this.getContext(), value);
    }
}

