/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.dialog;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import com.facebook.react.modules.dialog.DialogModule;
import javax.annotation.Nullable;

public class AlertFragment
extends DialogFragment
implements DialogInterface.OnClickListener {
    static final String ARG_TITLE = "title";
    static final String ARG_MESSAGE = "message";
    static final String ARG_BUTTON_POSITIVE = "button_positive";
    static final String ARG_BUTTON_NEGATIVE = "button_negative";
    static final String ARG_BUTTON_NEUTRAL = "button_neutral";
    static final String ARG_ITEMS = "items";
    @Nullable
    private final DialogModule.AlertFragmentListener mListener;

    public AlertFragment() {
        this.mListener = null;
    }

    @SuppressLint(value={"ValidFragment"})
    public AlertFragment(@Nullable DialogModule.AlertFragmentListener listener, Bundle arguments) {
        this.mListener = listener;
        this.setArguments(arguments);
    }

    public static Dialog createDialog(Context activityContext, Bundle arguments, DialogInterface.OnClickListener fragment) {
        AlertDialog.Builder builder = new AlertDialog.Builder(activityContext).setTitle((CharSequence)arguments.getString(ARG_TITLE));
        if (arguments.containsKey(ARG_BUTTON_POSITIVE)) {
            builder.setPositiveButton((CharSequence)arguments.getString(ARG_BUTTON_POSITIVE), fragment);
        }
        if (arguments.containsKey(ARG_BUTTON_NEGATIVE)) {
            builder.setNegativeButton((CharSequence)arguments.getString(ARG_BUTTON_NEGATIVE), fragment);
        }
        if (arguments.containsKey(ARG_BUTTON_NEUTRAL)) {
            builder.setNeutralButton((CharSequence)arguments.getString(ARG_BUTTON_NEUTRAL), fragment);
        }
        if (arguments.containsKey(ARG_MESSAGE)) {
            builder.setMessage((CharSequence)arguments.getString(ARG_MESSAGE));
        }
        if (arguments.containsKey(ARG_ITEMS)) {
            builder.setItems(arguments.getCharSequenceArray(ARG_ITEMS), fragment);
        }
        return builder.create();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = AlertFragment.createDialog((Context)this.getActivity(), this.getArguments(), this);
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface d) {
                if (d instanceof Dialog) {
                    Dialog dialog = (Dialog)d;
                    dialog.getWindow().setFlags(8, 8);
                    if (Build.VERSION.SDK_INT >= 19) {
                        int uiOptions = 5894;
                        dialog.getWindow().getDecorView().setSystemUiVisibility(uiOptions);
                    } else if (Build.VERSION.SDK_INT > 11 && Build.VERSION.SDK_INT < 19) {
                        dialog.getWindow().getDecorView().setSystemUiVisibility(8);
                    }
                    dialog.getWindow().clearFlags(8);
                }
            }
        });
        return dialog;
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.mListener != null) {
            this.mListener.onClick(dialog, which);
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mListener != null) {
            this.mListener.onDismiss(dialog);
        }
    }
}

