/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.jstasks.HeadlessJsTaskContext;
import com.facebook.react.module.annotations.ReactModule;

@ReactModule(name="HeadlessJsTaskSupport")
public class HeadlessJsTaskSupportModule
extends ReactContextBaseJavaModule {
    public static final String NAME = "HeadlessJsTaskSupport";

    public HeadlessJsTaskSupportModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ReactMethod
    public void notifyTaskFinished(int taskId) {
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.getReactApplicationContext());
        if (headlessJsTaskContext.isTaskRunning(taskId)) {
            headlessJsTaskContext.finishTask(taskId);
        } else {
            FLog.w(HeadlessJsTaskSupportModule.class, (String)"Tried to finish non-active task with id %d. Did it time out?", (Object[])new Object[]{taskId});
        }
    }
}

