/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.switchview;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import androidx.appcompat.widget.SwitchCompat;
import javax.annotation.Nullable;

class ReactSwitch
extends SwitchCompat {
    private boolean mAllowChange = true;
    @Nullable
    private Integer mTrackColorForFalse = null;
    @Nullable
    private Integer mTrackColorForTrue = null;

    public ReactSwitch(Context context) {
        super(context);
    }

    public void setChecked(boolean checked) {
        if (this.mAllowChange && this.isChecked() != checked) {
            this.mAllowChange = false;
            super.setChecked(checked);
            this.setTrackColor(checked);
        }
    }

    void setColor(Drawable drawable, @Nullable Integer color) {
        if (color == null) {
            drawable.clearColorFilter();
        } else {
            drawable.setColorFilter(color.intValue(), PorterDuff.Mode.MULTIPLY);
        }
    }

    public void setTrackColor(@Nullable Integer color) {
        this.setColor(super.getTrackDrawable(), color);
    }

    public void setThumbColor(@Nullable Integer color) {
        this.setColor(super.getThumbDrawable(), color);
    }

    void setOn(boolean on) {
        if (this.isChecked() != on) {
            super.setChecked(on);
            this.setTrackColor(on);
        }
        this.mAllowChange = true;
    }

    public void setTrackColorForTrue(@Nullable Integer color) {
        if (color == this.mTrackColorForTrue) {
            return;
        }
        this.mTrackColorForTrue = color;
        if (this.isChecked()) {
            this.setTrackColor(this.mTrackColorForTrue);
        }
    }

    public void setTrackColorForFalse(@Nullable Integer color) {
        if (color == this.mTrackColorForFalse) {
            return;
        }
        this.mTrackColorForFalse = color;
        if (!this.isChecked()) {
            this.setTrackColor(this.mTrackColorForFalse);
        }
    }

    private void setTrackColor(boolean checked) {
        if (this.mTrackColorForTrue != null || this.mTrackColorForFalse != null) {
            Integer currentTrackColor = checked ? this.mTrackColorForTrue : this.mTrackColorForFalse;
            this.setTrackColor(currentTrackColor);
        }
    }
}

