/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.Log;
import android.util.SparseArray;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactFontManager {
    private static final String[] EXTENSIONS = new String[]{"", "_bold", "_italic", "_bold_italic"};
    private static final String[] FILE_EXTENSIONS = new String[]{".ttf", ".otf"};
    private static final String FONTS_ASSET_PATH = "fonts/";
    private static ReactFontManager sReactFontManagerInstance;
    private Map<String, FontFamily> mFontCache = new HashMap<String, FontFamily>();

    private ReactFontManager() {
    }

    public static ReactFontManager getInstance() {
        if (sReactFontManagerInstance == null) {
            sReactFontManagerInstance = new ReactFontManager();
        }
        return sReactFontManagerInstance;
    }

    @Nullable
    public Typeface getTypeface(String fontFamilyName, int style2, AssetManager assetManager) {
        return this.getTypeface(fontFamilyName, style2, null, assetManager);
    }

    @Nullable
    public Typeface getTypeface(String fontFamilyName, int style2, Context context, AssetManager assetManager) {
        Typeface typeface;
        FontFamily fontFamily = this.mFontCache.get(fontFamilyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily();
            this.mFontCache.put(fontFamilyName, fontFamily);
        }
        if ((typeface = fontFamily.getTypeface(style2)) == null && (typeface = ReactFontManager.createTypeface(fontFamilyName, style2, context, assetManager)) != null) {
            fontFamily.setTypeface(style2, typeface);
        }
        return typeface;
    }

    public void setTypeface(String fontFamilyName, int style2, Typeface typeface) {
        if (typeface != null) {
            FontFamily fontFamily = this.mFontCache.get(fontFamilyName);
            if (fontFamily == null) {
                fontFamily = new FontFamily();
                this.mFontCache.put(fontFamilyName, fontFamily);
            }
            fontFamily.setTypeface(style2, typeface);
        }
    }

    @Nullable
    private static Typeface createTypeface(String fontFamilyName, int style2, Context context, AssetManager assetManager) {
        String extension = EXTENSIONS[style2];
        for (String fileExtension : FILE_EXTENSIONS) {
            String fileName = FONTS_ASSET_PATH + fontFamilyName + extension + fileExtension;
            try {
                return Typeface.createFromAsset((AssetManager)assetManager, (String)fileName);
            }
            catch (RuntimeException e) {
                Log.i((String)"myyf", (String)("get fonts from bundles" + fileName));
                try {
                    if (context == null) continue;
                    Log.i((String)"myyf", (String)"get fonts from bundles");
                    File fileDir = context.getFilesDir();
                    File bundleFileDir = new File(fileDir, "bundles");
                    if (bundleFileDir != null && bundleFileDir.isDirectory()) {
                        Log.i((String)"myyf", (String)("get fonts from bundles1:" + bundleFileDir.getPath()));
                    }
                    for (File file : bundleFileDir.listFiles()) {
                        if (!file.isDirectory()) continue;
                        Log.i((String)"myyf", (String)("get fonts from bundles2:" + file.getPath()));
                        for (File file1 : file.listFiles()) {
                            if (!file1.isDirectory()) continue;
                            Log.i((String)"myyf", (String)("get fonts from bundles3:" + file1.getPath()));
                            File fontFile = new File(file1, fileName);
                            if (!fontFile.exists()) continue;
                            try {
                                return Typeface.createFromFile((File)fontFile);
                            }
                            catch (RuntimeException e1) {
                                Log.i((String)"myyf", (String)("get fonts from bundles:" + e1));
                            }
                        }
                    }
                }
                catch (Exception e1) {
                    Log.i((String)"myyf", (String)("get fonts from bundles:" + e1));
                }
            }
        }
        return Typeface.create((String)fontFamilyName, (int)style2);
    }

    private static class FontFamily {
        private SparseArray<Typeface> mTypefaceSparseArray = new SparseArray(4);

        private FontFamily() {
        }

        public Typeface getTypeface(int style2) {
            return (Typeface)this.mTypefaceSparseArray.get(style2);
        }

        public void setTypeface(int style2, Typeface typeface) {
            this.mTypefaceSparseArray.put(style2, (Object)typeface);
        }
    }
}

