/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.os.SystemClock;

public class OnScrollDispatchHelper {
    private static final int MIN_EVENT_SEPARATION_MS = 10;
    private int mPrevX = Integer.MIN_VALUE;
    private int mPrevY = Integer.MIN_VALUE;
    private float mXFlingVelocity = 0.0f;
    private float mYFlingVelocity = 0.0f;
    private long mLastScrollEventTimeMs = -11L;

    public boolean onScrollChanged(int x, int y) {
        boolean shouldDispatch;
        long eventTime = SystemClock.uptimeMillis();
        boolean bl = shouldDispatch = eventTime - this.mLastScrollEventTimeMs > 10L || this.mPrevX != x || this.mPrevY != y;
        if (eventTime - this.mLastScrollEventTimeMs != 0L) {
            this.mXFlingVelocity = (float)(x - this.mPrevX) / (float)(eventTime - this.mLastScrollEventTimeMs);
            this.mYFlingVelocity = (float)(y - this.mPrevY) / (float)(eventTime - this.mLastScrollEventTimeMs);
        }
        this.mLastScrollEventTimeMs = eventTime;
        this.mPrevX = x;
        this.mPrevY = y;
        return shouldDispatch;
    }

    public float getXFlingVelocity() {
        return this.mXFlingVelocity;
    }

    public float getYFlingVelocity() {
        return this.mYFlingVelocity;
    }
}

