/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animation;

import android.view.View;
import com.facebook.react.animation.AnimationPropertyUpdater;

public abstract class AbstractFloatPairPropertyUpdater
implements AnimationPropertyUpdater {
    private final float[] mFromValues = new float[2];
    private final float[] mToValues = new float[2];
    private final float[] mUpdateValues = new float[2];
    private boolean mFromSource;

    protected AbstractFloatPairPropertyUpdater(float toFirst, float toSecond) {
        this.mToValues[0] = toFirst;
        this.mToValues[1] = toSecond;
        this.mFromSource = true;
    }

    protected AbstractFloatPairPropertyUpdater(float fromFirst, float fromSecond, float toFirst, float toSecond) {
        this(toFirst, toSecond);
        this.mFromValues[0] = fromFirst;
        this.mFromValues[1] = fromSecond;
        this.mFromSource = false;
    }

    protected abstract void getProperty(View var1, float[] var2);

    protected abstract void setProperty(View var1, float[] var2);

    @Override
    public void prepare(View view) {
        if (this.mFromSource) {
            this.getProperty(view, this.mFromValues);
        }
    }

    @Override
    public void onUpdate(View view, float progress) {
        this.mUpdateValues[0] = this.mFromValues[0] + (this.mToValues[0] - this.mFromValues[0]) * progress;
        this.mUpdateValues[1] = this.mFromValues[1] + (this.mToValues[1] - this.mFromValues[1]) * progress;
        this.setProperty(view, this.mUpdateValues);
    }

    @Override
    public void onFinish(View view) {
        this.setProperty(view, this.mToValues);
    }
}

