/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.JSIModule;
import com.facebook.react.bridge.JSIModuleHolder;
import com.facebook.react.bridge.JSIModuleSpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSIModuleRegistry {
    private final Map<Class, JSIModuleHolder> mModules = new HashMap<Class, JSIModuleHolder>();

    public <T extends JSIModule> T getModule(Class<T> moduleClass) {
        JSIModuleHolder jsiModuleHolder = this.mModules.get(moduleClass);
        if (jsiModuleHolder == null) {
            throw new IllegalArgumentException("Unable to find JSIModule for class " + moduleClass);
        }
        return (T)((JSIModule)Assertions.assertNotNull((Object)jsiModuleHolder.getJSIModule()));
    }

    public void registerModules(List<JSIModuleSpec> jsiModules) {
        for (JSIModuleSpec spec : jsiModules) {
            this.mModules.put(spec.getJSIModuleClass(), new JSIModuleHolder(spec));
        }
    }

    public void notifyJSInstanceDestroy() {
        for (JSIModuleHolder moduleHolder : this.mModules.values()) {
            moduleHolder.notifyJSInstanceDestroy();
        }
    }
}

