/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hianalytics.process;

import android.content.Context;
import com.huawei.hianalytics.process.HiAnalyticsConfig;
import com.huawei.hianalytics.process.HiAnalyticsManager;
import com.huawei.hianalytics.process.a;
import com.huawei.hianalytics.process.b;
import com.huawei.hianalytics.process.d;
import com.huawei.hianalytics.util.f;
import java.util.LinkedHashMap;
import java.util.Map;

public interface HiAnalyticsInstance {
    public void setUpid(int var1, String var2);

    public void setOAID(int var1, String var2);

    public void setOAIDTrackingFlag(int var1, boolean var2);

    public void refresh(int var1, HiAnalyticsConfig var2);

    public void setCommonProp(int var1, Map<String, String> var2);

    public void clearData();

    public void onBackground(long var1);

    public void onForeground(long var1);

    @Deprecated
    public void onEvent(Context var1, String var2, String var3);

    public void onEvent(int var1, String var2, LinkedHashMap<String, String> var3);

    public void onEvent(String var1, LinkedHashMap<String, String> var2);

    public void onStreamEvent(int var1, String var2, LinkedHashMap<String, String> var3);

    public void onReport(int var1);

    @Deprecated
    public void onReport(Context var1, int var2);

    public void onPause(Context var1);

    public void onPause(Context var1, LinkedHashMap<String, String> var2);

    public void onPause(String var1, LinkedHashMap<String, String> var2);

    public void onResume(Context var1);

    public void onResume(Context var1, LinkedHashMap<String, String> var2);

    public void onResume(String var1, LinkedHashMap<String, String> var2);

    public static final class Builder {
        private HiAnalyticsConfig maintConf = null;
        private HiAnalyticsConfig operConf = null;
        private HiAnalyticsConfig diffConf = null;
        private Context mContext;

        public Builder(Context context) {
            if (context != null) {
                this.mContext = context.getApplicationContext();
            }
        }

        public Builder setMaintConf(HiAnalyticsConfig hiAnalyticsConfig) {
            this.maintConf = hiAnalyticsConfig;
            return this;
        }

        public Builder setOperConf(HiAnalyticsConfig hiAnalyticsConfig) {
            this.operConf = hiAnalyticsConfig;
            return this;
        }

        public Builder setDiffConf(HiAnalyticsConfig hiAnalyticsConfig) {
            this.diffConf = hiAnalyticsConfig;
            return this;
        }

        public HiAnalyticsInstance create(String string) {
            if (this.mContext == null) {
                com.huawei.hianalytics.g.b.d("HianalyticsSDK", "create(): instance context is null,create failed!");
                return null;
            }
            if (string == null || !f.a("tag", string, "[a-zA-Z0-9][a-zA-Z0-9_]{0,255}")) {
                com.huawei.hianalytics.g.b.d("HianalyticsSDK", "create(): check tag failed! TAG: " + string);
                return null;
            }
            if (HiAnalyticsManager.getInitFlag(string)) {
                com.huawei.hianalytics.g.b.d("HianalyticsSDK", "This tag already exists");
                return null;
            }
            if (a.b().c(string)) {
                com.huawei.hianalytics.g.b.d("HianalyticsSDK", "create(): black tag is not allowed here.");
                return null;
            }
            if (a.b().a() - a.b().e() > 50) {
                com.huawei.hianalytics.g.b.d("HianalyticsSDK", "The number of TAGs exceeds the limit!");
                return null;
            }
            d d2 = new d(string);
            this.setConf(d2);
            a.b().a(this.mContext);
            b.a().a(this.mContext);
            d d3 = a.b().a(string, d2);
            return d3 == null ? d2 : d3;
        }

        private void setConf(d d2) {
            if (this.operConf == null) {
                d2.c(null);
            } else {
                d2.c(new HiAnalyticsConfig(this.operConf));
            }
            if (this.maintConf == null) {
                d2.a(null);
            } else {
                d2.a(new HiAnalyticsConfig(this.maintConf));
            }
            if (this.diffConf == null) {
                d2.b(null);
            } else {
                d2.b(new HiAnalyticsConfig(this.diffConf));
            }
        }

        public HiAnalyticsInstance refresh(String string) {
            d d2 = a.b().a(string);
            if (d2 == null) {
                com.huawei.hianalytics.g.b.c("HianalyticsSDK", "HiAnalyticsInstance.Builder.Refresh(): calling refresh before create. TAG: " + string + " has no instance. ");
                return this.create(string);
            }
            d2.refresh(1, this.maintConf);
            d2.refresh(0, this.operConf);
            d2.refresh(3, this.diffConf);
            return d2;
        }
    }
}

