/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.heytap.mcssdk.utils.LogUtil;
import java.lang.reflect.Method;

public class Utils {
    private static final int SDK_INT_26 = 26;

    public static int parseInt(String string) {
        int n = -1;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                LogUtil.e("parseInt--NumberFormatException" + numberFormatException.getMessage());
            }
        }
        return n;
    }

    public static boolean isExistPackage(Context context, String string) {
        try {
            context.getPackageManager().getPackageInfo(string, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            LogUtil.e("isExistPackage NameNotFoundException:" + nameNotFoundException.getMessage());
            return false;
        }
    }

    public static boolean isSupportPush(Context context, String string, String string2) {
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(string, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            LogUtil.e("isSupportPush NameNotFoundException:" + nameNotFoundException.getMessage());
        }
        return applicationInfo != null && applicationInfo.metaData.getBoolean(string2, false);
    }

    public static int getVersionCode(Context context, String string) {
        try {
            return context.getPackageManager().getPackageInfo((String)string, (int)0).versionCode;
        }
        catch (Exception exception) {
            LogUtil.d("getVersionCode--Exception:" + exception.getMessage());
            return 0;
        }
    }

    public static String getVersionName(Context context, String string) {
        try {
            return context.getPackageManager().getPackageInfo((String)string, (int)0).versionName;
        }
        catch (Exception exception) {
            LogUtil.d("getVersionName--Exception:" + exception.getMessage());
            return null;
        }
    }

    public static String getVersionName(Context context) {
        String string = "0";
        try {
            string = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (Exception exception) {}
        return string;
    }

    public static int getVersionCode(Context context) {
        int n = 0;
        try {
            n = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (Exception exception) {}
        return n;
    }

    public static String getPackageName(Context context) {
        String string = "0";
        try {
            string = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).packageName;
        }
        catch (Exception exception) {
            LogUtil.e(exception);
        }
        return string;
    }

    public static String getAppName(Context context) {
        String string = "app";
        try {
            int n = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).applicationInfo.labelRes;
            return context.getResources().getString(n);
        }
        catch (Exception exception) {
            LogUtil.e(exception);
            return string;
        }
    }

    public static String getSystemProperties(String string, String string2) {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Class[] classArray = new Class[2];
            Object object = classArray;
            classArray[0] = String.class;
            object[1] = String.class;
            object = clazz.getMethod("get", (Class<?>)object);
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray2[1] = string2;
            string = (String)((Method)object).invoke(clazz, objectArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            string = string2;
        }
        return string;
    }

    public static String getString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : nArray) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }
}

