/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.SystemProperties;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.heytap.mcssdk.utils.LogUtil;

@SuppressLint(value={"DefaultLocale"})
public class SystemInfoUtil {
    private static final String MODEL_NULL = "0";
    private static final int SDK_INT_21 = 21;

    public static String getModel() {
        String string = MODEL_NULL;
        if (!SystemInfoUtil.isEmpty(Build.MODEL)) {
            string = Build.MODEL.toUpperCase();
        } else {
            LogUtil.w("No MODEL.");
        }
        return string;
    }

    public static String getRomVersion() {
        return SystemProperties.get((String)"ro.build.display.id", (String)"");
    }

    public static String getAndroidVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getOperator(Context context) {
        String string = "";
        try {
            context = (TelephonyManager)context.getSystemService("phone");
            if (context != null) {
                string = context.getNetworkOperatorName();
            }
        }
        catch (Exception exception) {
            LogUtil.e(exception);
        }
        return string;
    }

    public static String getCarrierName(Context object) {
        switch (SystemInfoUtil.getOperator((Context)object).toLowerCase()) {
            case "\u4e2d\u56fd\u79fb\u52a8": 
            case "china mobile": 
            case "chinamobile": {
                object = "China Mobile";
                break;
            }
            case "\u4e2d\u56fd\u8054\u901a": 
            case "china unicom": 
            case "chinaunicom": {
                object = "China Unicom";
                break;
            }
            case "\u4e2d\u56fd\u7535\u4fe1": 
            case "china net": 
            case "chinanet": {
                object = "China Net";
                break;
            }
            default: {
                object = "none";
            }
        }
        return object;
    }

    private static boolean isEmpty(String string) {
        return TextUtils.isEmpty((CharSequence)string) || "null".equals(string);
    }
}

