/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk.utils;

import android.content.Context;
import android.content.Intent;
import com.heytap.mcssdk.PushManager;
import com.heytap.mcssdk.mode.MessageStat;
import com.heytap.mcssdk.utils.LogUtil;
import com.heytap.mcssdk.utils.Utils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class StatUtil {
    private static final String TYPE = "type";
    private static final String COUNT = "count";
    private static final String STAT_LIST = "list";
    private static final int MCS_SUPPORT_VERSION = 1017;

    public static void statisticMessage(Context context, MessageStat messageStat) {
        LinkedList<MessageStat> linkedList = new LinkedList<MessageStat>();
        linkedList.add(messageStat);
        StatUtil.statisticMessage(context, linkedList);
    }

    public static void statisticMessage(Context context, List<MessageStat> list) {
        LinkedList<MessageStat> linkedList = new LinkedList<MessageStat>();
        linkedList.addAll(list);
        LogUtil.d("isSupportStatisticByMcs:" + StatUtil.isSupportStatisticByMcs(context) + ",list size:" + linkedList.size());
        if (linkedList.size() > 0 && StatUtil.isSupportStatisticByMcs(context)) {
            StatUtil.statisticMessageByMcs(context, linkedList);
        }
    }

    private static boolean isSupportStatisticByMcs(Context context) {
        String string = PushManager.getMcsPackageName(context);
        return Utils.isExistPackage(context, string) && Utils.getVersionCode(context, string) >= 1017;
    }

    private static void statisticMessageByMcs(Context context, List<MessageStat> object) {
        try {
            Intent intent = new Intent();
            intent.setAction(PushManager.getReceiveSdkAction(context));
            intent.setPackage(PushManager.getMcsPackageName(context));
            intent.putExtra("appPackage", context.getPackageName());
            intent.putExtra(TYPE, 12291);
            intent.putExtra(COUNT, object.size());
            ArrayList<String> arrayList = new ArrayList<String>();
            object = object.iterator();
            while (object.hasNext()) {
                MessageStat messageStat = (MessageStat)object.next();
                arrayList.add(messageStat.toJsonObject());
            }
            intent.putStringArrayListExtra(STAT_LIST, arrayList);
            context.startService(intent);
            return;
        }
        catch (Exception exception) {
            LogUtil.e("statisticMessage--Exception" + exception.getMessage());
            return;
        }
    }
}

