/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.heytap.mcssdk.utils.LogUtil;

@SuppressLint(value={"DefaultLocale"})
public class NetInfoUtil {
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;
    private static final int NETWORK_TYPE_UNAVAILABLE = -1;
    private static final int NETWORK_TYPE_WIFI = -101;
    private static final int NETWORK_CLASS_WIFI = -101;
    private static final int NETWORK_CLASS_UNAVAILABLE = -1;
    private static final int NETWORK_CLASS_UNKNOWN = 0;
    private static final int NETWORK_CLASS_2_G = 1;
    private static final int NETWORK_CLASS_3_G = 2;
    private static final int NETWORK_CLASS_4_G = 3;

    public static boolean isWifiNetWork(Context context) {
        boolean bl = false;
        try {
            if (NetInfoUtil.getNetType(context).equals("WIFI")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            LogUtil.e(exception);
        }
        return bl;
    }

    public static boolean is3GNetwork(Context object) {
        boolean bl = false;
        try {
            object = NetInfoUtil.getNetType((Context)object);
            if (((String)object).equals("3GNET") || ((String)object).equals("3GWAP")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            LogUtil.e(exception);
        }
        return bl;
    }

    public static boolean is2GNetwork(Context object) {
        boolean bl = false;
        try {
            object = NetInfoUtil.getNetType((Context)object);
            if (((String)object).equals("UNINET") || ((String)object).equals("UNIWAP") || ((String)object).equals("CMNET") || ((String)object).equals("CMWAP") || ((String)object).equals("CTNET") || ((String)object).equals("CTWAP")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            LogUtil.e(exception);
        }
        return bl;
    }

    public static boolean isConnectNet(Context context) {
        boolean bl = false;
        try {
            context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
            if (context != null) {
                bl = context.isConnected();
            }
        }
        catch (Exception exception) {
            LogUtil.e(exception);
        }
        return bl;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String getNetType(Context object) {
        String string = "0";
        try {
            object = (ConnectivityManager)object.getSystemService("connectivity");
            if ((object = object != null ? object.getActiveNetworkInfo() : null) != null && (string = object.getTypeName().toUpperCase()).equals("MOBILE") && !TextUtils.isEmpty((CharSequence)(object = object.getExtraInfo()))) {
                string = ((String)object).toUpperCase();
            }
        }
        catch (Exception exception) {
            LogUtil.e(exception);
        }
        return string;
    }

    public static String getNetworkType(Context context) {
        String string;
        int n = 0;
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if ((connectivityManager = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null) != null && connectivityManager.isAvailable() && connectivityManager.isConnected()) {
                int n2 = connectivityManager.getType();
                if (n2 == 1) {
                    n = -101;
                } else if (n2 == 0 && (context = (TelephonyManager)context.getSystemService("phone")) != null) {
                    n = context.getNetworkType();
                }
            } else {
                n = -1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        switch (NetInfoUtil.getNetworkClassByType(n)) {
            case -1: {
                string = "UNKNOWN";
                break;
            }
            case -101: {
                string = "WIFI";
                break;
            }
            case 1: {
                string = "2G";
                break;
            }
            case 2: {
                string = "3G";
                break;
            }
            case 3: {
                string = "4G";
                break;
            }
            case 0: {
                string = "UNKNOWN";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    private static int getNetworkClassByType(int n) {
        switch (n) {
            case -1: {
                return -1;
            }
            case -101: {
                return -101;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 2;
            }
            case 13: {
                return 3;
            }
        }
        return 0;
    }

    public static boolean isWapNet(Context object) {
        return ((String)(object = NetInfoUtil.getNetType((Context)object))).equals("CMWAP") || ((String)object).equals("3GWAP") || ((String)object).equals("UNIWAP");
    }
}

