/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk.utils;

import android.text.TextUtils;
import com.heytap.mcssdk.utils.DESUtil;
import com.heytap.mcssdk.utils.LogUtil;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;

public class CryptoUtil {
    public static final String DES_KEY = "com.nearme.mcs";
    private static final int DEFAULT_RADIX = 16;

    public static String parseByte2HexStr(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuilder.append(string.toUpperCase(Locale.getDefault()));
        }
        return stringBuilder.toString();
    }

    public static byte[] parseHexStr2Byte(String string) {
        if (string.length() <= 0) {
            return null;
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length() / 2; ++i) {
            int n = Integer.parseInt(string.substring(i * 2, i * 2 + 1), 16);
            int n2 = Integer.parseInt(string.substring(i * 2 + 1, i * 2 + 2), 16);
            byArray[i] = (byte)(n * 16 + n2);
        }
        return byArray;
    }

    public static byte[] getUTF8Bytes(String string) {
        if (string == null) {
            return new byte[0];
        }
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new byte[0];
        }
    }

    public static byte[] swapBytes(byte[] byArray) {
        int n = byArray.length % 2 == 0 ? byArray.length : byArray.length - 1;
        for (int i = 0; i < n; i += 2) {
            byte by = byArray[i];
            byArray[i] = byArray[i + 1];
            byArray[i + 1] = by;
        }
        return byArray;
    }

    private static String getDesKey() {
        String string = "";
        byte[] byArray = CryptoUtil.swapBytes(CryptoUtil.getUTF8Bytes(DES_KEY));
        if (byArray != null) {
            string = new String(byArray, Charset.forName("UTF-8"));
        }
        return string;
    }

    public static String desEncrypt(String string) {
        String string2 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                string2 = DESUtil.encrypt(string, CryptoUtil.getDesKey());
            }
            catch (Exception exception) {
                LogUtil.e("desEncrypt-" + exception.getMessage());
            }
        }
        return string2;
    }

    public static String desDecrypt(String string) {
        String string2 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                string2 = DESUtil.decrypt(string, CryptoUtil.getDesKey());
            }
            catch (Exception exception) {
                LogUtil.e("desDecrypt-" + exception.getMessage());
            }
        }
        return string2;
    }
}

