/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import com.heytap.mcssdk.b;
import com.heytap.mcssdk.b.a;
import com.heytap.mcssdk.b.c;
import com.heytap.mcssdk.callback.PushCallback;
import com.heytap.mcssdk.d;
import com.heytap.mcssdk.e;
import com.heytap.mcssdk.mode.AppMessage;
import com.heytap.mcssdk.mode.CommandMessage;
import com.heytap.mcssdk.mode.MessageStat;
import com.heytap.mcssdk.mode.SptDataMessage;
import com.heytap.mcssdk.utils.LogUtil;
import com.heytap.mcssdk.utils.StatUtil;
import com.heytap.mcssdk.utils.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class PushManager
implements b {
    public static final String EVENT_ID_PUSH_REGISTER = "push_register";
    public static final String EVENT_ID_PUSH_TRANSMIT = "push_transmit";
    public static final String EVENT_ID_PUSH_SHOW = "push_show";
    public static final String EVENT_ID_PUSH_NO_SHOW = "push_no_show";
    public static final String EVENT_ID_READ_MESSAGE = "push_read_message";
    public static final String EVENT_ID_PUSH_CLICK = "push_click";
    public static final String EVENT_ID_APP_BLACK_LIST = "app_black_list";
    public static final String EVENT_ID_PUSH_EXCEPTION = "push_exception";
    public static final String EVENT_ID_PUSH_DELETE = "push_delete";
    public static final String EVENT_ID_PUSH_REVOKE = "push_revoke";
    public static final String EVENT_ID_PUSH_REVOKE_DELETE = "push_revoke_delete";
    public static final String EVENT_ID_PUSH_ADD_MESSAGE_TOP = "add_message_top";
    public static final String EVENT_ID_PUSH_ADD_MESSAGE_NO_DISTURBING = "add_message_no_disturbing";
    public static final String EVENT_ID_PUSH_NO_IMSI = "imsi_not_exist";
    public static final String EVENT_ID_PUSH_MESSAGE_REPEAT = "message_repeat";
    private static final int[] OLD_MCS_PACKAGE = new int[]{99, 111, 109, 46, 99, 111, 108, 111, 114, 111, 115, 46, 109, 99, 115};
    private static final int[] OLD_MCS_RECEIVE_SDK_ACTION = new int[]{99, 111, 109, 46, 99, 111, 108, 111, 114, 111, 115, 46, 109, 99, 115, 115, 100, 107, 46, 97, 99, 116, 105, 111, 110, 46, 82, 69, 67, 69, 73, 86, 69, 95, 83, 68, 75, 95, 77, 69, 83, 83, 65, 71, 69};
    private static final String NEW_MCS_RECEIVE_SDK_ACTION = "com.mcs.action.RECEIVE_SDK_MESSAGE";
    private static final String TYPE = "type";
    private static final int MCS_SUPPORT_VERSION = 1012;
    private static final String EVENT_ID = "eventID";
    private static final String TASK_ID = "taskID";
    private static final String APP_PACKAGE = "appPackage";
    private static final String EXTRA = "extra";
    private static final String MESSAGE_TYPE = "messageType";
    private static final String MESSAGE_ID = "messageID";
    private static final String GLOBAL_ID = "globalID";
    private static final String SUPPORT_OPEN_PUSH = "supportOpenPush";
    private static final String APP_VERSION_NAME = "versionName";
    private static final String APP_VERSION_CODE = "versionCode";
    private static final String PUSH_SDK_VERSION = "pushSdkVersion";
    private static final int MAX_HOUR_IN_DAY = 23;
    private static final int MAX_MIN_IN_HOUR = 59;
    private static final int SDK_INT_24 = 24;
    private static final int SYSTEM_UID = 1000;
    private static int sCount = 0;
    private static String sMcsPkgName;
    private static boolean sIsNewMcsPkg;
    private final Object mMcsServiceLock = new Object();
    private Context mContext;
    private List<c> mProcessors = new ArrayList<c>();
    private List<com.heytap.mcssdk.a.d> mParsers = new ArrayList<com.heytap.mcssdk.a.d>();
    private String mAppKey;
    private String mAppSecret;
    private String mRegisterID = null;
    private PushCallback mPushCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PushManager() {
        Class<PushManager> clazz = PushManager.class;
        synchronized (PushManager.class) {
            if (sCount > 0) {
                throw new RuntimeException("PushManager can't create again!");
            }
            ++sCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.addParser(new com.heytap.mcssdk.a.a());
            this.addParser(new com.heytap.mcssdk.a.e());
            this.addParser(new com.heytap.mcssdk.a.b());
            this.addProcessor(new a());
            this.addProcessor(new com.heytap.mcssdk.b.d());
            this.addProcessor(new com.heytap.mcssdk.b.b());
            return;
        }
    }

    public static PushManager getInstance() {
        return e.a();
    }

    private static String getNewMcsPackageName(Context context) {
        Object object = new Intent(NEW_MCS_RECEIVE_SDK_ACTION);
        object = context.getPackageManager().queryIntentServices((Intent)object, 8192);
        if (Build.VERSION.SDK_INT >= 24) {
            object = object.iterator();
            while (object.hasNext()) {
                String string = ((ResolveInfo)object.next()).serviceInfo.packageName;
                try {
                    boolean bl = (context.getPackageManager().getApplicationInfo((String)string, (int)0).flags & 1) == 1;
                    int n = context.getPackageManager().getPackageUid(string, 0);
                    int n2 = context.getPackageManager().getPackageUid("android", 0);
                    int n3 = n = n == n2 ? 1 : 0;
                    if (!bl && n == 0) continue;
                    return string;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                }
            }
        }
        return null;
    }

    public static String getMcsPackageName(Context object) {
        if (sMcsPkgName == null) {
            if ((object = PushManager.getNewMcsPackageName(object)) == null) {
                sMcsPkgName = Utils.getString(OLD_MCS_PACKAGE);
                sIsNewMcsPkg = false;
            } else {
                sMcsPkgName = object;
                sIsNewMcsPkg = true;
            }
        }
        return sMcsPkgName;
    }

    public static String getReceiveSdkAction(Context context) {
        if (sMcsPkgName == null) {
            PushManager.getNewMcsPackageName(context);
        }
        if (sIsNewMcsPkg) {
            return NEW_MCS_RECEIVE_SDK_ACTION;
        }
        return Utils.getString(OLD_MCS_RECEIVE_SDK_ACTION);
    }

    public static boolean isSupportPush(Context context) {
        String string = PushManager.getMcsPackageName(context);
        return Utils.isExistPackage(context, string) && Utils.getVersionCode(context, string) >= 1012 && Utils.isSupportPush(context, string, SUPPORT_OPEN_PUSH);
    }

    @Deprecated
    private static void onAppStart(Context context) {
        MessageStat messageStat = new MessageStat(context.getPackageName(), "app_start", null);
        PushManager.statisticMessage(context, messageStat);
    }

    public static void statisticMessage(Context context, MessageStat messageStat) {
        StatUtil.statisticMessage(context, messageStat);
    }

    public static void statisticMessage(Context context, List<MessageStat> list) {
        StatUtil.statisticMessage(context, list);
    }

    public static void statisticMessage(Context context, AppMessage appMessage, String string) {
        try {
            Intent intent = new Intent();
            intent.setAction(PushManager.getReceiveSdkAction(context));
            intent.setPackage(PushManager.getMcsPackageName(context));
            intent.putExtra(TYPE, 12291);
            intent.putExtra(TASK_ID, appMessage.getTaskID());
            intent.putExtra(APP_PACKAGE, appMessage.getAppPackage());
            intent.putExtra(MESSAGE_ID, String.valueOf(appMessage.getMessageID()));
            intent.putExtra(GLOBAL_ID, String.valueOf(appMessage.getMessageID()));
            intent.putExtra(MESSAGE_TYPE, appMessage.getType());
            intent.putExtra(EVENT_ID, string);
            context.startService(intent);
            return;
        }
        catch (Exception exception) {
            LogUtil.e("statisticMessage--Exception" + exception.getMessage());
            return;
        }
    }

    public static void statisticMessage(Context context, SptDataMessage sptDataMessage, String string) {
        try {
            Intent intent = new Intent();
            intent.setAction(PushManager.getReceiveSdkAction(context));
            intent.setPackage(PushManager.getMcsPackageName(context));
            intent.putExtra(TYPE, 12291);
            intent.putExtra(TASK_ID, sptDataMessage.getTaskID());
            intent.putExtra(APP_PACKAGE, sptDataMessage.getAppPackage());
            intent.putExtra(MESSAGE_ID, sptDataMessage.getMessageID());
            intent.putExtra(GLOBAL_ID, sptDataMessage.getGlobalID());
            intent.putExtra(MESSAGE_TYPE, sptDataMessage.getType());
            intent.putExtra(EVENT_ID, string);
            context.startService(intent);
            return;
        }
        catch (Exception exception) {
            LogUtil.e("statisticMessage--Exception" + exception.getMessage());
            return;
        }
    }

    private synchronized void addProcessor(c c2) {
        if (c2 != null) {
            this.mProcessors.add(c2);
        }
    }

    private synchronized void addParser(com.heytap.mcssdk.a.d d2) {
        if (d2 != null) {
            this.mParsers.add(d2);
        }
    }

    public List<com.heytap.mcssdk.a.d> getParsers() {
        return this.mParsers;
    }

    public List<c> getProcessors() {
        return this.mProcessors;
    }

    private void checkContext() {
        if (this.mContext == null) {
            throw new IllegalArgumentException("please call the register first!");
        }
    }

    private void checkRegisterID() {
        if (this.mRegisterID == null) {
            throw new IllegalArgumentException("please call the register until get the registerID!");
        }
    }

    private void checkAll() {
        this.checkContext();
        this.checkRegisterID();
    }

    public void setAppKeySecret(String string, String string2) {
        this.mAppKey = string;
        this.mAppSecret = string2;
    }

    @Override
    public String getRegisterID() {
        return this.mRegisterID;
    }

    @Override
    public void setRegisterID(String string) {
        this.mRegisterID = string;
    }

    private void startMcsService(int n, JSONObject jSONObject) {
        this.startMcsService(n, "", jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMcsService(int n, String string, JSONObject jSONObject) {
        Object object = this.mMcsServiceLock;
        synchronized (object) {
            Intent intent = this.getIntent(n, string, jSONObject);
            this.mContext.startService(intent);
            return;
        }
    }

    public void bindMcsService(int n) {
        Intent intent = this.getIntent(n, "", null);
        this.mContext.bindService(intent, (ServiceConnection)new d(this, intent), 1);
    }

    private Intent getIntent(int n, String string, JSONObject jSONObject) {
        Intent intent = new Intent();
        intent.setAction(PushManager.getReceiveSdkAction(this.mContext));
        intent.setPackage(PushManager.getMcsPackageName(this.mContext));
        intent.putExtra(TYPE, n);
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.putOpt(APP_VERSION_NAME, (Object)Utils.getVersionName(this.mContext, this.mContext.getPackageName()));
            jSONObject2.putOpt(APP_VERSION_CODE, (Object)Utils.getVersionCode(this.mContext, this.mContext.getPackageName()));
            if (jSONObject != null) {
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    jSONObject2.putOpt(string2, jSONObject.get(string2));
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            intent.putExtra(EXTRA, jSONObject2.toString());
        }
        intent.putExtra("params", string);
        intent.putExtra(APP_PACKAGE, this.mContext.getPackageName());
        intent.putExtra("appKey", this.mAppKey);
        intent.putExtra("appSecret", this.mAppSecret);
        intent.putExtra("registerID", this.mRegisterID);
        intent.putExtra("sdkVersion", PushManager.getSDKVersion());
        return intent;
    }

    public PushCallback getPushCallback() {
        return this.mPushCallback;
    }

    public void setPushCallback(PushCallback pushCallback) {
        this.mPushCallback = pushCallback;
    }

    @Override
    public void register(Context context, String string, String string2, JSONObject jSONObject, PushCallback pushCallback) {
        try {
            if (context == null) {
                throw new IllegalArgumentException("context is null !");
            }
            PushManager.statisticMessage(context, new MessageStat(context.getPackageName(), EVENT_ID_PUSH_REGISTER, null));
            if (!PushManager.isSupportPush(context)) {
                throw new IllegalArgumentException("the phone is not support push!");
            }
            this.mAppKey = string;
            this.mAppSecret = string2;
            this.mContext = context.getApplicationContext();
            this.mPushCallback = pushCallback;
            this.startMcsService(12289, jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onRegister(-2, null);
            }
            return;
        }
    }

    @Override
    public void register(Context context, String string, String string2, PushCallback pushCallback) {
        this.register(context, string, string2, null, pushCallback);
    }

    public void unRegister(Context context, String string, String string2, JSONObject jSONObject, PushCallback pushCallback) {
        this.mAppKey = string;
        this.mAppSecret = string2;
        this.mContext = context.getApplicationContext();
        this.mPushCallback = pushCallback;
        this.unRegister(jSONObject);
    }

    @Override
    public void unRegister(JSONObject jSONObject) {
        try {
            this.checkContext();
            this.startMcsService(12290, jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onUnRegister(-2);
            }
            return;
        }
    }

    @Override
    public void unRegister() {
        this.unRegister(null);
    }

    @Override
    public void getRegister(JSONObject jSONObject) {
        try {
            this.checkContext();
            this.startMcsService(12289, jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onRegister(-2, null);
            }
            return;
        }
    }

    @Override
    public void getRegister() {
        this.getRegister(null);
    }

    @Override
    public void setAliases(List<String> list, JSONObject jSONObject) {
        try {
            this.checkAll();
            if (list == null || list.size() == 0) {
                return;
            }
            this.startMcsService(12292, CommandMessage.parseToString(list), jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onSetAliases(-2, null);
            }
            return;
        }
    }

    @Override
    public void setAliases(List<String> list) {
        this.setAliases(list, null);
    }

    @Override
    public void unsetAlias(String string, JSONObject jSONObject) {
        try {
            this.checkAll();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.unsetAliases(arrayList, jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onUnsetAliases(-2, null);
            }
            return;
        }
    }

    @Override
    public void unsetAlias(String string) {
        this.unsetAlias(string, null);
    }

    @Override
    @Deprecated
    public void unsetAliases(List<String> list, JSONObject jSONObject) {
        try {
            this.checkAll();
            if (list == null || list.size() == 0) {
                return;
            }
            this.startMcsService(12294, CommandMessage.parseToString(list), jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onUnsetAliases(-2, null);
            }
            return;
        }
    }

    @Override
    public void unsetAliases(List<String> list) {
        this.unsetAliases(list, null);
    }

    @Override
    public void getAliases(JSONObject jSONObject) {
        try {
            this.checkAll();
            this.startMcsService(12293, jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onGetAliases(-2, null);
            }
            return;
        }
    }

    @Override
    public void getAliases() {
        this.getAliases(null);
    }

    @Override
    public void setUserAccount(String string, JSONObject jSONObject) {
        try {
            this.checkAll();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setUserAccounts(arrayList, jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onSetUserAccounts(-2, null);
            }
            return;
        }
    }

    @Override
    public void setUserAccount(String string) {
        this.setUserAccount(string, null);
    }

    @Override
    @Deprecated
    public void setUserAccounts(List<String> list, JSONObject jSONObject) {
        try {
            this.checkAll();
            if (list == null || list.size() == 0) {
                return;
            }
            this.startMcsService(12301, CommandMessage.parseToString(list), jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onSetUserAccounts(-2, null);
            }
            return;
        }
    }

    @Override
    public void setUserAccounts(List<String> list) {
        this.setUserAccounts(list, null);
    }

    @Override
    public void unsetUserAccounts(List<String> list, JSONObject jSONObject) {
        try {
            this.checkAll();
            if (list == null || list.size() == 0) {
                return;
            }
            this.startMcsService(12303, CommandMessage.parseToString(list), jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onUnsetUserAccounts(-2, null);
            }
            return;
        }
    }

    @Override
    public void unsetUserAccounts(List<String> list) {
        this.unsetUserAccounts(list, null);
    }

    @Override
    public void getUserAccounts(JSONObject jSONObject) {
        try {
            this.checkAll();
            this.startMcsService(12302, jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onGetUserAccounts(-2, null);
            }
            return;
        }
    }

    @Override
    public void getUserAccounts() {
        this.getUserAccounts(null);
    }

    @Override
    public void setTags(List<String> list, JSONObject jSONObject) {
        try {
            this.checkAll();
            if (list == null || list.size() == 0) {
                return;
            }
            this.startMcsService(12295, CommandMessage.parseToString(list), jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onSetTags(-2, null);
            }
            return;
        }
    }

    @Override
    public void setTags(List<String> list) {
        this.setTags(list, null);
    }

    @Override
    public void unsetTags(List<String> list, JSONObject jSONObject) {
        try {
            this.checkAll();
            if (list == null || list.size() == 0) {
                return;
            }
            this.startMcsService(12297, CommandMessage.parseToString(list), jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onUnsetTags(-2, null);
            }
            return;
        }
    }

    @Override
    public void unsetTags(List<String> list) {
        this.unsetTags(list, null);
    }

    @Override
    public void getTags(JSONObject jSONObject) {
        try {
            this.checkAll();
            this.startMcsService(12296, jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onGetTags(-2, null);
            }
            return;
        }
    }

    @Override
    public void getTags() {
        this.getTags(null);
    }

    @Override
    public void pausePush(JSONObject jSONObject) {
        try {
            this.checkAll();
            this.startMcsService(12299, jSONObject);
            return;
        }
        catch (Exception exception) {
            LogUtil.e("mcssdk---", exception);
            return;
        }
    }

    @Override
    public void pausePush() {
        this.pausePush(null);
    }

    @Override
    public void resumePush(JSONObject jSONObject) {
        try {
            this.checkAll();
            this.startMcsService(12300, jSONObject);
            return;
        }
        catch (Exception exception) {
            LogUtil.e("mcssdk---", exception);
            return;
        }
    }

    @Override
    public void resumePush() {
        this.resumePush(null);
    }

    @Override
    public void getNotificationStatus(JSONObject jSONObject) {
        try {
            this.checkAll();
            this.startMcsService(12309, jSONObject);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onGetNotificationStatus(-2, 0);
            }
            return;
        }
    }

    @Override
    public void getNotificationStatus() {
        this.getNotificationStatus(null);
    }

    @Override
    public void setNotificationType(int n, JSONObject jSONObject) {
        try {
            this.checkAll();
            this.startMcsService(12307, String.valueOf(n), jSONObject);
            return;
        }
        catch (Exception exception) {
            LogUtil.e("mcssdk---", exception);
            return;
        }
    }

    @Override
    public void setNotificationType(int n) {
        this.setNotificationType(n, null);
    }

    @Override
    public void clearNotificationType(JSONObject jSONObject) {
        try {
            this.checkAll();
            this.startMcsService(12308, jSONObject);
            return;
        }
        catch (Exception exception) {
            LogUtil.e("mcssdk---", exception);
            return;
        }
    }

    @Override
    public void clearNotificationType() {
        this.clearNotificationType(null);
    }

    @Override
    public void openNotificationSettings(JSONObject jSONObject) {
        try {
            this.checkAll();
            this.startMcsService(12310, jSONObject);
            return;
        }
        catch (Exception exception) {
            LogUtil.e("mcssdk---", exception);
            return;
        }
    }

    @Override
    public void openNotificationSettings() {
        this.openNotificationSettings(null);
    }

    @Override
    public void clearNotifications() {
        this.clearNotifications(null);
    }

    @Override
    public void clearNotifications(JSONObject jSONObject) {
        try {
            this.checkContext();
            this.startMcsService(12311, jSONObject);
            return;
        }
        catch (Exception exception) {
            LogUtil.e("mcssdk---", exception);
            return;
        }
    }

    public void getPushStatus() {
        try {
            this.checkAll();
            this.startMcsService(12306, null);
            return;
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onGetPushStatus(-2, 0);
            }
            return;
        }
    }

    public static String getSDKVersion() {
        return "2.0.2";
    }

    public String getPushVersionName() {
        this.checkContext();
        return Utils.getVersionName(this.mContext, PushManager.getMcsPackageName(this.mContext));
    }

    public int getPushVersionCode() {
        this.checkContext();
        return Utils.getVersionCode(this.mContext, PushManager.getMcsPackageName(this.mContext));
    }

    @Override
    public void setPushTime(List<Integer> list, int n, int n2, int n3, int n4, JSONObject jSONObject) {
        try {
            this.checkAll();
            if (list != null && list.size() > 0 && n >= 0 && n <= 23 && n2 >= 0 && n2 <= 59 && n3 >= n && n3 <= 23 && n4 >= n2 && n4 <= 59) {
                try {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("weekDays", (Object)CommandMessage.parseToString(list));
                    jSONObject2.put("startHour", n);
                    jSONObject2.put("startMin", n2);
                    jSONObject2.put("endHour", n3);
                    jSONObject2.put("endMin", n4);
                    this.startMcsService(12298, jSONObject2.toString(), jSONObject);
                    return;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    return;
                }
            }
            throw new IllegalArgumentException("params are not all right,please check params");
        }
        catch (Exception exception) {
            if (this.getPushCallback() != null) {
                this.getPushCallback().onSetPushTime(-2, exception.getMessage());
            }
            return;
        }
    }

    @Override
    public void setPushTime(List<Integer> list, int n, int n2, int n3, int n4) {
        this.setPushTime(list, n, n2, n3, n4, null);
    }

    @Override
    public void requestNotificationPermission() {
        try {
            this.checkContext();
            this.bindMcsService(12313);
            return;
        }
        catch (Exception exception) {
            LogUtil.e("mcssdk---", exception);
            return;
        }
    }

    static /* synthetic */ Context access$100(PushManager pushManager) {
        return pushManager.mContext;
    }

    /* synthetic */ PushManager(d d2) {
        this();
    }
}

