/*
 * Decompiled with CFR 0.152.
 */
package org.android.spdy;

import android.content.Context;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.android.spdy.AccsSSLCallback;
import org.android.spdy.SessionCb;
import org.android.spdy.SessionInfo;
import org.android.spdy.SoInstallMgrSdk;
import org.android.spdy.SpdyByteArray;
import org.android.spdy.SpdyDataProvider;
import org.android.spdy.SpdyErrorException;
import org.android.spdy.SpdyRequest;
import org.android.spdy.SpdySession;
import org.android.spdy.SpdySessionKind;
import org.android.spdy.SpdyVersion;
import org.android.spdy.Spdycb;
import org.android.spdy.SslCertcb;
import org.android.spdy.SslPermData;
import org.android.spdy.SslVersion;
import org.android.spdy.SuperviseConnectInfo;
import org.android.spdy.SuperviseData;
import org.android.spdy.spduLog;

public final class SpdyAgent {
    public static ChangeQuickRedirect changeQuickRedirect;
    private static final int MAX_SPDY_SESSION_COUNT = 50;
    private AccsSSLCallback accsSSLCallback;
    static final int SPDY_SESSION_CREATE = 4096;
    static final int SPDY_DATA_CHUNK_RECV = 4097;
    static final int SPDY_DATA_RECV = 4098;
    static final int SPDY_DATA_SEND = 4099;
    static final int SPDY_STREAM_CLOSE = 4100;
    static final int SPDY_PING_RECV = 4101;
    static final int SPDY_REQUEST_RECV = 4102;
    static final int SPDY_SESSION_CLOSE = 4103;
    static final int SPDY_STREAM_RESPONSE_RECV = 4104;
    static final int SPDY_SESSION_FAILED_ERROR = 4105;
    static final int SPDY_CUSTOM_CONTROL_FRAME_RECV = 4106;
    static final int MODE_QUIC = 256;
    private HashMap<String, SpdySession> sessionMgr = new HashMap(5);
    private LinkedList<SpdySession> sessionQueue = new LinkedList();
    private long agentNativePtr;
    private AtomicBoolean closed = new AtomicBoolean();
    private String proxyUsername = null;
    private String proxyPassword = null;
    private static final String TNET_SO_VERSION = "tnet-3.1.14";
    public static volatile boolean enableDebug;
    public static volatile boolean enableTimeGaurd;
    private static final boolean HAVE_CLOSE = false;
    private static final ReentrantReadWriteLock rwLock;
    private static final Lock r;
    private static final Lock w;
    private static volatile boolean loadSucc;
    private static volatile SpdyAgent gSingleInstance;
    private static Object lock;
    private static Object domainHashLock;
    private static HashMap<String, Integer> domainHashMap;
    private static int totalDomain;
    private static final int KB8 = 8192;
    private static final int KB32 = 32768;
    private static final int MB5 = 0x500000;
    public static final int ACCS_TEST_SERVER = 0;
    public static final int ACCS_ONLINE_SERVER = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSpdySession(String string2, String string3, int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string2, string3, new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"e3781aea64846a5a98a1a0d5818d68ef");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (string2 != null) {
            w.lock();
            try {
                if (string2 != null) {
                    this.sessionMgr.remove(string2 + string3 + n2);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                w.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpdyAgent getInstance(Context context, SpdyVersion spdyVersion, SpdySessionKind spdySessionKind) throws UnsatisfiedLinkError, SpdyErrorException {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{context, spdyVersion, spdySessionKind}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"53f1c6b836dd4e428233a369f15f9b07");
        if (patchProxyResult.isSupported) {
            return (SpdyAgent)patchProxyResult.result;
        }
        if (gSingleInstance == null) {
            Object object = lock;
            synchronized (object) {
                if (gSingleInstance == null) {
                    gSingleInstance = new SpdyAgent(context, spdyVersion, spdySessionKind, null);
                }
            }
        }
        return gSingleInstance;
    }

    public static boolean checkLoadSucc() {
        return loadSucc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static SpdyAgent getInstance(Context context, SpdyVersion spdyVersion, SpdySessionKind spdySessionKind, AccsSSLCallback accsSSLCallback) throws UnsatisfiedLinkError, SpdyErrorException {
        if (gSingleInstance == null) {
            Object object = lock;
            synchronized (object) {
                if (gSingleInstance == null) {
                    gSingleInstance = new SpdyAgent(context, spdyVersion, spdySessionKind, accsSSLCallback);
                }
            }
        }
        return gSingleInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDomainHashIndex(String string2) {
        Integer n2;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string2}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"a9460772c9ffe3f0af9df695768e7b58");
        if (patchProxyResult.isSupported) {
            return (Integer)patchProxyResult.result;
        }
        Object object = domainHashLock;
        synchronized (object) {
            n2 = domainHashMap.get(string2);
            if (n2 == null) {
                domainHashMap.put(string2, ++totalDomain);
                n2 = totalDomain;
            }
        }
        return n2;
    }

    private SpdyAgent(Context context, SpdyVersion spdyVersion, SpdySessionKind spdySessionKind, AccsSSLCallback accsSSLCallback) throws UnsatisfiedLinkError {
        try {
            SoInstallMgrSdk.init(context);
            loadSucc = SoInstallMgrSdk.initSo(TNET_SO_VERSION, 1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            this.agentNativePtr = this.initAgent(spdyVersion.getInt(), spdySessionKind.getint(), SslVersion.SLIGHT_VERSION_V1.getint());
            this.accsSSLCallback = accsSSLCallback;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        this.closed.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLoadSo() throws SpdyErrorException {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"74c3addce58e2cfdd934e95024dc06e2");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (loadSucc) {
            return;
        }
        try {
            Object object = lock;
            synchronized (object) {
                if (loadSucc) {
                    return;
                }
                loadSucc = SoInstallMgrSdk.initSo(TNET_SO_VERSION, 1);
                this.agentNativePtr = this.initAgent(0, 0, 0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (!loadSucc) {
            throw new SpdyErrorException("TNET_JNI_ERR_LOAD_SO_FAIL", -1108);
        }
    }

    public void setProxyUsernamePassword(String string2, String string3) {
        this.proxyUsername = string2;
        this.proxyPassword = string3;
    }

    static void securityCheck(int n2, int n3) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), new Integer(n3)}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"0727e363f20a9e35e5de8706fe24a7f9");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (n2 >= 32768) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM:total=" + n2, -1102);
        }
        if (n3 >= 8192) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM:value=" + n3, -1102);
        }
    }

    static void tableListJudge(int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2)}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"8e81e8a524e0df5029d7bd35db06b51b");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (n2 >= 0x500000) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM:total=" + n2, -1102);
        }
    }

    static void InvlidCharJudge(byte[] byArray, byte[] byArray2) {
        int n2;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            if ((byArray[n2] & 0xFF) >= 32 && (byArray[n2] & 0xFF) <= 126) continue;
            byArray[n2] = 63;
        }
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            if ((byArray2[n2] & 0xFF) >= 32 && (byArray2[n2] & 0xFF) <= 126) continue;
            byArray2[n2] = 63;
        }
    }

    static void headJudge(Map<String, String> map) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{map}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"51007593049006979aecc4ca2e83bba3");
        if (patchProxyResult.isSupported) {
            return;
        }
        String string2 = null;
        String string3 = null;
        int n2 = 0;
        if (map != null) {
            Set<Map.Entry<String, String>> set = map.entrySet();
            Iterator<Map.Entry<String, String>> iterator = set.iterator();
            Map.Entry<String, String> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                string2 = entry.getKey();
                string3 = entry.getValue();
                SpdyAgent.InvlidCharJudge(string2.getBytes(), string3.getBytes());
                SpdyAgent.securityCheck(n2 += string2.length() + 1 + string3.length(), string3.length());
            }
        }
    }

    static String mapBodyToString(Map<String, String> map) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{map}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"c27ba30f5c95ce2b9e675f337a67b065");
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        int n2 = 0;
        String string2 = null;
        String string3 = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null) {
            Set<Map.Entry<String, String>> set = map.entrySet();
            Iterator<Map.Entry<String, String>> iterator = set.iterator();
            Map.Entry<String, String> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                string2 = entry.getKey();
                string3 = entry.getValue();
                stringBuilder.append(string2).append('=').append(string3).append('&');
                SpdyAgent.tableListJudge(n2 += string2.length() + 1 + string3.length());
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    static byte[] dataproviderToByteArray(SpdyRequest spdyRequest, SpdyDataProvider spdyDataProvider) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdyRequest, spdyDataProvider}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"af7969f075b34383490c749280d71e55");
        if (patchProxyResult.isSupported) {
            return (byte[])patchProxyResult.result;
        }
        byte[] byArray = null;
        String string2 = null;
        SpdyAgent.headJudge(spdyRequest.getHeaders());
        if (spdyDataProvider == null) {
            return null;
        }
        string2 = SpdyAgent.mapBodyToString(spdyDataProvider.postBody);
        byArray = string2 != null ? string2.getBytes() : spdyDataProvider.data;
        if (byArray != null && byArray.length >= 0x500000) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM:total=" + byArray.length, -1102);
        }
        return byArray;
    }

    @Deprecated
    public SpdySession createSession(String string2, Object object, SessionCb sessionCb, int n2) throws SpdyErrorException {
        return this.createSession(string2, "", object, sessionCb, null, n2, 0);
    }

    @Deprecated
    public SpdySession createSession(String string2, String string3, Object object, SessionCb sessionCb, int n2) throws SpdyErrorException {
        return this.createSession(string2, string3, object, sessionCb, null, n2, 0);
    }

    @Deprecated
    public SpdySession createSession(String string2, Object object, SessionCb sessionCb, SslCertcb sslCertcb, int n2) throws SpdyErrorException {
        return this.createSession(string2, "", object, sessionCb, sslCertcb, n2, 0);
    }

    public SpdySession createSession(SessionInfo sessionInfo) throws SpdyErrorException {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{sessionInfo}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"5a8196a0f79e6f197a235b99b6525106");
        if (patchProxyResult.isSupported) {
            return (SpdySession)patchProxyResult.result;
        }
        return this.createSession(sessionInfo.getAuthority(), sessionInfo.getDomain(), sessionInfo.getSessonUserData(), sessionInfo.getSessionCb(), null, sessionInfo.getMode(), sessionInfo.getPubKeySeqNum(), sessionInfo.getConnectionTimeoutMs(), sessionInfo.getCertHost());
    }

    @Deprecated
    public SpdySession createSession(String string2, String string3, Object object, SessionCb sessionCb, SslCertcb sslCertcb, int n2, int n3) throws SpdyErrorException {
        return this.createSession(string2, string3, object, sessionCb, sslCertcb, n2, n3, -1);
    }

    public SpdySession createSession(String string2, String string3, Object object, SessionCb sessionCb, SslCertcb sslCertcb, int n2, int n3, int n4) throws SpdyErrorException {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string2, string3, object, sessionCb, sslCertcb, new Integer(n2), new Integer(n3), new Integer(n4)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"a07faa517f0b5a38fa6ac1faf556eb78");
        if (patchProxyResult.isSupported) {
            return (SpdySession)patchProxyResult.result;
        }
        return this.createSession(string2, string3, object, sessionCb, sslCertcb, n2, n3, n4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpdySession createSession(String string2, String string3, Object object, SessionCb sessionCb, SslCertcb sslCertcb, int n2, int n3, int n4, String string4) throws SpdyErrorException {
        Object object2;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string2, string3, object, sessionCb, sslCertcb, new Integer(n2), new Integer(n3), new Integer(n4), string4}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"9264cf1a6822ffc8ad714a8433b7a808");
        if (patchProxyResult.isSupported) {
            return (SpdySession)patchProxyResult.result;
        }
        if (string2 == null) {
            throw new SpdyErrorException("SPDY_JNI_ERR_INVALID_PARAM", -1102);
        }
        String string5 = string2;
        String[] stringArray = string2.split("/");
        String[] stringArray2 = stringArray[0].split(":");
        byte[] byArray = "0.0.0.0".getBytes();
        char c2 = '\u0000';
        if (stringArray.length != 1) {
            object2 = stringArray[1].split(":");
            byArray = object2[0].getBytes();
            c2 = (char)Integer.parseInt(object2[1]);
        } else {
            string5 = string5 + "/0.0.0.0:0";
        }
        this.agentIsOpen();
        object2 = null;
        boolean bl2 = false;
        r.lock();
        try {
            object2 = this.sessionMgr.get(string5 + string3 + n2);
            if (this.sessionMgr.size() >= 50) {
                bl2 = true;
            }
        }
        finally {
            r.unlock();
        }
        if (bl2) {
            throw new SpdyErrorException("SPDY_SESSION_EXCEED_MAXED: session count exceed max", -1105);
        }
        if (object2 != null) {
            ((SpdySession)object2).increRefCount();
            return object2;
        }
        SpdySession spdySession = null;
        w.lock();
        try {
            object2 = this.sessionMgr.get(string5 + string3 + n2);
        }
        catch (Throwable throwable) {
            object2 = null;
        }
        if (object2 != null) {
            w.unlock();
            ((SpdySession)object2).increRefCount();
            return object2;
        }
        try {
            int n5;
            long l2;
            spdySession = new SpdySession(0L, this, string5, string3, sessionCb, n2, n3, object);
            byte[] byArray2 = string4 == null ? null : string4.getBytes();
            int n6 = this.getDomainHashIndex(string3 + n2);
            long l3 = this.proxyUsername != null && this.proxyPassword != null ? this.createSessionN(this.agentNativePtr, spdySession, n6, stringArray2[0].getBytes(), (char)Integer.parseInt(stringArray2[1]), byArray, c2, this.proxyUsername.getBytes(), this.proxyPassword.getBytes(), object, n2, n3, n4, byArray2) : this.createSessionN(this.agentNativePtr, spdySession, n6, stringArray2[0].getBytes(), (char)Integer.parseInt(stringArray2[1]), byArray, c2, null, null, object, n2, n3, n4, byArray2);
            spduLog.Logi("tnet-jni", " create new session: " + string2);
            if ((l3 & 1L) == 1L) {
                l2 = 0L;
                n5 = (int)(l3 >> 1);
            } else {
                l2 = l3;
                n5 = 0;
            }
            if (l2 != 0L) {
                spdySession.setSessionNativePtr(l2);
                this.sessionMgr.put(string5 + string3 + n2, spdySession);
                this.sessionQueue.add(spdySession);
            } else {
                if (n5 != 0) {
                    throw new SpdyErrorException("create session error: " + n5, n5);
                }
                spdySession = null;
            }
        }
        finally {
            w.unlock();
        }
        return spdySession;
    }

    @Deprecated
    public SpdySession submitRequest(SpdyRequest spdyRequest, SpdyDataProvider spdyDataProvider, Object object, Object object2, Spdycb spdycb, SessionCb sessionCb, SslCertcb sslCertcb, int n2) throws SpdyErrorException {
        SpdySession spdySession = this.createSession(spdyRequest.getAuthority(), spdyRequest.getDomain(), object, sessionCb, sslCertcb, n2, 0, spdyRequest.getConnectionTimeoutMs());
        spdySession.submitRequest(spdyRequest, spdyDataProvider, object2, spdycb);
        return spdySession;
    }

    @Deprecated
    public SpdySession submitRequest(SpdyRequest spdyRequest, SpdyDataProvider spdyDataProvider, Object object, Object object2, Spdycb spdycb, SessionCb sessionCb, SslCertcb sslCertcb, int n2, int n3) throws SpdyErrorException {
        SpdySession spdySession = this.createSession(spdyRequest.getAuthority(), spdyRequest.getDomain(), object, sessionCb, sslCertcb, n2, n3, spdyRequest.getConnectionTimeoutMs());
        spdySession.submitRequest(spdyRequest, spdyDataProvider, object2, spdycb);
        return spdySession;
    }

    public SpdySession submitRequest(SpdyRequest spdyRequest, SpdyDataProvider spdyDataProvider, Object object, Object object2, Spdycb spdycb, SessionCb sessionCb, int n2, int n3) throws SpdyErrorException {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdyRequest, spdyDataProvider, object, object2, spdycb, sessionCb, new Integer(n2), new Integer(n3)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"d2c59a38d22eeaac376c0ec878248a7c");
        if (patchProxyResult.isSupported) {
            return (SpdySession)patchProxyResult.result;
        }
        return this.submitRequest(spdyRequest, spdyDataProvider, object, object2, spdycb, sessionCb, null, n2, n3);
    }

    @Deprecated
    public SpdySession submitRequest(SpdyRequest spdyRequest, SpdyDataProvider spdyDataProvider, Object object, Object object2, Spdycb spdycb, SessionCb sessionCb, int n2) throws SpdyErrorException {
        return this.submitRequest(spdyRequest, spdyDataProvider, object, object2, spdycb, sessionCb, null, n2);
    }

    private void agentIsOpen() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"1b8096e570bf0e2bcb6064b7572f9bd5");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (this.closed.get()) {
            throw new SpdyErrorException("SPDY_JNI_ERR_ASYNC_CLOSE", -1104);
        }
        this.checkLoadSo();
    }

    public void close() {
    }

    void removeSession(SpdySession spdySession) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"8e67a68cf3affdc1a4524c7143e9eba3");
        if (patchProxyResult.isSupported) {
            return;
        }
        w.lock();
        try {
            this.sessionQueue.remove(spdySession);
        }
        finally {
            w.unlock();
        }
    }

    int closeSession(long l2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Long(l2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"d3fa9be4df7bed73f755ad099fda34be");
        if (patchProxyResult.isSupported) {
            return (Integer)patchProxyResult.result;
        }
        return this.closeSessionN(l2);
    }

    static String[] mapToByteArray(Map<String, String> map) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{map}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"42a893cdaa72e4e4aa5c08d0567e6ed5");
        if (patchProxyResult.isSupported) {
            return (String[])patchProxyResult.result;
        }
        if (map == null || map.size() <= 0) {
            return null;
        }
        int n2 = map.size() * 2;
        String[] stringArray = new String[n2];
        Set<Map.Entry<String, String>> set = map.entrySet();
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        Map.Entry<String, String> entry = null;
        int n3 = 0;
        while (iterator.hasNext()) {
            entry = iterator.next();
            stringArray[n3] = entry.getKey();
            stringArray[n3 + 1] = entry.getValue();
            n3 += 2;
        }
        return stringArray;
    }

    static Map<String, List<String>> stringArrayToMap(String[] stringArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{stringArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"b5b8ba5be5d2bae5d2fb7167acf22c9d");
        if (patchProxyResult.isSupported) {
            return (Map)patchProxyResult.result;
        }
        if (stringArray == null) {
            return null;
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(5);
        int n2 = 0;
        while (n2 + 2 <= stringArray.length) {
            if (stringArray[n2] == null || stringArray[n2 + 1] == null) {
                return null;
            }
            List<String> list = hashMap.get(stringArray[n2]);
            if (list == null) {
                list = new ArrayList<String>(1);
                hashMap.put(stringArray[n2], list);
            }
            list.add(stringArray[n2 + 1]);
            n2 += 2;
        }
        return hashMap;
    }

    @Deprecated
    public int setSessionKind(SpdySessionKind spdySessionKind) {
        int n2 = -1;
        this.agentIsOpen();
        try {
            n2 = this.setSessionKind(this.agentNativePtr, spdySessionKind.getint());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return n2;
    }

    @Deprecated
    public int setConnectTimeOut(int n2) {
        int n3 = 0;
        this.agentIsOpen();
        try {
            n3 = this.setConTimeout(this.agentNativePtr, n2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return n3;
    }

    public void setAccsSslCallback(AccsSSLCallback accsSSLCallback) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{accsSSLCallback}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"3f46933bbf7abdef1e40e5f4fd1af20f");
        if (patchProxyResult.isSupported) {
            return;
        }
        spduLog.Logi("tnet-jni", "[setAccsSslCallback] - " + accsSSLCallback.getClass());
        this.accsSSLCallback = accsSSLCallback;
    }

    private native int setConTimeout(long var1, int var3);

    private native long initAgent(int var1, int var2, int var3);

    private native int freeAgent(long var1);

    private native long getSession(long var1, byte[] var3, char var4);

    private native int closeSessionN(long var1);

    private native int setSessionKind(long var1, int var3);

    private native long createSessionN(long var1, SpdySession var3, int var4, byte[] var5, char var6, byte[] var7, char var8, byte[] var9, byte[] var10, Object var11, int var12, int var13, int var14, byte[] var15);

    private void spdySessionConnectCB(SpdySession spdySession, SuperviseConnectInfo superviseConnectInfo) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, superviseConnectInfo}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"579936225c2466b44e2c62cf495c112f");
        if (patchProxyResult.isSupported) {
            return;
        }
        spduLog.Logi("tnet-jni", "[spdySessionConnectCB] - ");
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdySessionConnectCB] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdySessionConnectCB] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdySessionConnectCB(spdySession, superviseConnectInfo);
        }
    }

    private void spdyDataChunkRecvCB(SpdySession spdySession, boolean bl2, int n2, SpdyByteArray spdyByteArray, int n3) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, new Byte((byte)(bl2 ? 1 : 0)), new Integer(n2), spdyByteArray, new Integer(n3)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"863d010ed1c75ba111a5df04fb4e3636");
        if (patchProxyResult.isSupported) {
            return;
        }
        spduLog.Logi("tnet-jni", "[spdyDataChunkRecvCB] - ");
        long l2 = (long)n2 & 0xFFFFFFFFL;
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyDataChunkRecvCB] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyDataChunkRecvCB] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyDataChunkRecvCB(spdySession, bl2, l2, spdyByteArray, n3);
        }
    }

    private void spdyDataRecvCallback(SpdySession spdySession, boolean bl2, int n2, int n3, int n4) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, new Byte((byte)(bl2 ? 1 : 0)), new Integer(n2), new Integer(n3), new Integer(n4)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"f1da25c469aaf37116b024c3595cc8ea");
        if (patchProxyResult.isSupported) {
            return;
        }
        spduLog.Logi("tnet-jni", "[spdyDataRecvCallback] - ");
        long l2 = (long)n2 & 0xFFFFFFFFL;
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyDataRecvCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyDataRecvCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyDataRecvCallback(spdySession, bl2, l2, n3, n4);
        }
    }

    private void spdyDataSendCallback(SpdySession spdySession, boolean bl2, int n2, int n3, int n4) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, new Byte((byte)(bl2 ? 1 : 0)), new Integer(n2), new Integer(n3), new Integer(n4)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"569611949fbee4f60c2a560abf4a3a55");
        if (patchProxyResult.isSupported) {
            return;
        }
        long l2 = (long)n2 & 0xFFFFFFFFL;
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyDataSendCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyDataSendCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyDataSendCallback(spdySession, bl2, l2, n3, n4);
        }
    }

    private void spdyStreamCloseCallback(SpdySession spdySession, int n2, int n3, int n4, SuperviseData superviseData) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, new Integer(n2), new Integer(n3), new Integer(n4), superviseData}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"eba8dcb5b03cd611a221506ea2dcf607");
        if (patchProxyResult.isSupported) {
            return;
        }
        spduLog.Logi("tnet-jni", "[spdyStreamCloseCallback] - ");
        long l2 = (long)n2 & 0xFFFFFFFFL;
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyStreamCloseCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyStreamCloseCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyStreamCloseCallback(spdySession, l2, n3, n4, superviseData);
        }
    }

    private void spdyPingRecvCallback(SpdySession spdySession, int n2, Object object) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, new Integer(n2), object}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"2c0f05a6c7ebc5b9cca57a74cbdfbbcc");
        if (patchProxyResult.isSupported) {
            return;
        }
        spduLog.Logi("tnet-jni", "[spdyPingRecvCallback] - ");
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyPingRecvCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyPingRecvCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyPingRecvCallback(spdySession, n2, object);
        }
    }

    private void spdyCustomControlFrameRecvCallback(SpdySession spdySession, Object object, int n2, int n3, int n4, int n5, byte[] byArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, object, new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), byArray}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"7d9f6c45cb3c903b4751af3568ff7b21");
        if (patchProxyResult.isSupported) {
            return;
        }
        spduLog.Logi("tnet-jni", "[spdyCustomControlFrameRecvCallback] - ");
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyCustomControlFrameRecvCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyCustomControlFrameRecvCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyCustomControlFrameRecvCallback(spdySession, object, n2, n3, n4, n5, byArray);
        }
    }

    private void spdyCustomControlFrameFailCallback(SpdySession spdySession, Object object, int n2, int n3) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, object, new Integer(n2), new Integer(n3)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"1e4edc825c01aad86c7b8efbf5dcf90a");
        if (patchProxyResult.isSupported) {
            return;
        }
        spduLog.Logi("tnet-jni", "[spdyCustomControlFrameFailCallback] - ");
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyCustomControlFrameFailCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyCustomControlFrameFailCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyCustomControlFrameFailCallback(spdySession, object, n2, n3);
        }
    }

    private void bioPingRecvCallback(SpdySession spdySession, int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"c4fa658c50e6581abb540c76cfdee2b0");
        if (patchProxyResult.isSupported) {
            return;
        }
        spduLog.Logi("tnet-jni", "[bioPingRecvCallback] - ");
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[bioPingRecvCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[bioPingRecvCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.bioPingRecvCallback(spdySession, n2);
        }
    }

    private void spdyRequestRecvCallback(SpdySession spdySession, int n2, int n3) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, new Integer(n2), new Integer(n3)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"274bf791e138b95236679071a08e8fee");
        if (patchProxyResult.isSupported) {
            return;
        }
        long l2 = (long)n2 & 0xFFFFFFFFL;
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyRequestRecvCallback] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyRequestRecvCallback] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyRequestRecvCallback(spdySession, l2, n3);
        }
    }

    private void spdyStreamResponseRecv(SpdySession spdySession, int n2, String[] stringArray, int n3) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, new Integer(n2), stringArray, new Integer(n3)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"4367455484a8422887aca5d505f8c6ec");
        if (patchProxyResult.isSupported) {
            return;
        }
        spduLog.Logi("tnet-jni", "[spdyStreamResponseRecv] - ");
        Map<String, List<String>> map = SpdyAgent.stringArrayToMap(stringArray);
        long l2 = (long)n2 & 0xFFFFFFFFL;
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdyStreamResponseRecv] - session is null");
        } else if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[spdyStreamResponseRecv] - session.intenalcb is null");
        } else {
            spdySession.intenalcb.spdyOnStreamResponse(spdySession, l2, map, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spdySessionCloseCallback(SpdySession spdySession, Object object, SuperviseConnectInfo superviseConnectInfo, int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, object, superviseConnectInfo, new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"67592e129a39f1d6510cba437f3eb257");
        if (patchProxyResult.isSupported) {
            return;
        }
        spduLog.Logi("tnet-jni", "[spdySessionCloseCallback] - errorCode = " + n2);
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdySessionCloseCallback] - session is null");
        } else {
            try {
                if (spdySession.intenalcb == null) {
                    spduLog.Logi("tnet-jni", "[spdySessionCloseCallback] - session.intenalcb is null");
                } else {
                    spdySession.intenalcb.spdySessionCloseCallback(spdySession, object, superviseConnectInfo, n2);
                }
            }
            finally {
                spdySession.cleanUp();
            }
        }
        spdySession.releasePptr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spdySessionFailedError(SpdySession spdySession, int n2, Object object) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, new Integer(n2), object}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"49ade57df55b191f2ed19c815945872e");
        if (patchProxyResult.isSupported) {
            return;
        }
        spduLog.Logi("tnet-jni", "[spdySessionFailedError] - ");
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdySessionFailedError] - session is null");
        } else {
            try {
                if (spdySession.intenalcb == null) {
                    spduLog.Logi("tnet-jni", "[spdySessionFailedError] - session.intenalcb is null");
                } else {
                    spdySession.intenalcb.spdySessionFailedError(spdySession, n2, object);
                }
            }
            finally {
                spdySession.cleanUp();
            }
        }
        spdySession.releasePptr();
    }

    private void spdySessionOnWritable(SpdySession spdySession, Object object, int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, object, new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"eb82df2eb8d4c74dd456e24f87e5c942");
        if (patchProxyResult.isSupported) {
            return;
        }
        spduLog.Logi("tnet-jni", "[spdySessionOnWritable] - ");
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[spdySessionOnWritable] - session is null");
        } else {
            try {
                if (spdySession.intenalcb == null) {
                    spduLog.Logi("tnet-jni", "[spdySessionOnWritable] - session.intenalcb is null");
                } else {
                    spdySession.intenalcb.spdySessionOnWritable(spdySession, object, n2);
                }
            }
            catch (Throwable throwable) {
                spduLog.Loge("tnet-jni", "[spdySessionOnWritable] - exception:" + throwable);
            }
        }
    }

    private byte[] getSSLPublicKey(int n2, byte[] byArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), byArray}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"3e7e36ad906762eb577483dc668902a5");
        if (patchProxyResult.isSupported) {
            return (byte[])patchProxyResult.result;
        }
        if (this.accsSSLCallback == null) {
            spduLog.Logd("tnet-jni", "[getSSLPublicKey] - accsSSLCallback is null.");
            return null;
        }
        return this.accsSSLCallback.getSSLPublicKey(n2, byArray);
    }

    private int putSSLMeta(SpdySession spdySession, byte[] byArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession, byArray}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"dab5b313f809940f713635509e2e3001");
        if (patchProxyResult.isSupported) {
            return (Integer)patchProxyResult.result;
        }
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[putSSLMeta] - session is null");
            return -1;
        }
        if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[putSSLMeta] - session.intenalcb is null");
            return -1;
        }
        return spdySession.intenalcb.putSSLMeta(spdySession, byArray);
    }

    private byte[] getSSLMeta(SpdySession spdySession) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{spdySession}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"3f796d9b19a6fbb2724ed5097c5f0b21");
        if (patchProxyResult.isSupported) {
            return (byte[])patchProxyResult.result;
        }
        if (spdySession == null) {
            spduLog.Logi("tnet-jni", "[getSSLMeta] - session is null");
            return null;
        }
        if (spdySession.intenalcb == null) {
            spduLog.Logi("tnet-jni", "[getSSLMeta] - session.intenalcb is null");
            return null;
        }
        return spdySession.intenalcb.getSSLMeta(spdySession);
    }

    private void getPerformance(SpdySession spdySession, SslPermData sslPermData) {
    }

    public HashMap<String, SpdySession> getAllSession() {
        return this.sessionMgr;
    }

    private static void crashReporter(int n2) {
    }

    public int configLogFile(String string2, int n2, int n3) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string2, new Integer(n2), new Integer(n3)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"21447bdc2a4fbf7053a0db25064f90a8");
        if (patchProxyResult.isSupported) {
            return (Integer)patchProxyResult.result;
        }
        return loadSucc ? this.configLogFileN(string2, n2, n3) : -1;
    }

    public int configLogFile(String string2, int n2, int n3, int n4) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string2, new Integer(n2), new Integer(n3), new Integer(n4)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"4649e5992b05d4c1d9b981d17877b13e");
        if (patchProxyResult.isSupported) {
            return (Integer)patchProxyResult.result;
        }
        return loadSucc ? this.configLogFileN(string2, n2, n3, n4) : -1;
    }

    public void logFileFlush() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"f958e692340b080e97a3f96e2b8086b3");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (loadSucc) {
            this.logFileFlushN();
        }
    }

    public void logFileClose() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"c765539c0544268bf24a49765df351bc");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (loadSucc) {
            this.logFileFlushN();
            this.logFileCloseN();
        }
    }

    private native int configLogFileN(String var1, int var2, int var3);

    private native int configLogFileN(String var1, int var2, int var3, int var4);

    private native void logFileFlushN();

    private native void logFileCloseN();

    @Deprecated
    public void switchAccsServer(int n2) {
    }

    @Deprecated
    public static void inspect(String string2) {
    }

    private static native int configIpStackModeN(int var0);

    public static int configIpStackMode(int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2)}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"90ae31b4e65c2667fdc2f4225d248cde");
        if (patchProxyResult.isSupported) {
            return (Integer)patchProxyResult.result;
        }
        spduLog.Logi("tnet-jni", "[configIpStackMode] - " + n2);
        return SpdyAgent.configIpStackModeN(n2);
    }

    static {
        enableDebug = false;
        enableTimeGaurd = false;
        rwLock = new ReentrantReadWriteLock();
        r = rwLock.readLock();
        w = rwLock.writeLock();
        loadSucc = false;
        gSingleInstance = null;
        lock = new Object();
        domainHashLock = new Object();
        domainHashMap = new HashMap();
        totalDomain = 0;
    }
}

