/*
 * Decompiled with CFR 0.152.
 */
package org.android.spdy;

import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;

public class NetSparseArray<E>
implements Cloneable {
    public static ChangeQuickRedirect changeQuickRedirect;
    private static final Object DELETED;
    private boolean mGarbage = false;
    private int[] mKeys;
    private Object[] mValues;
    private int mSize;

    public NetSparseArray() {
        this(10);
    }

    public NetSparseArray(int n2) {
        this.mKeys = new int[n2];
        this.mValues = new Object[n2];
        this.mSize = 0;
    }

    public E get(int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"8624051eda45596dd6f1b5bc94aacfd4");
        if (patchProxyResult.isSupported) {
            return (E)patchProxyResult.result;
        }
        return this.get(n2, null);
    }

    public E get(int n2, E e2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), e2}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"009d4565e3dcdf20250c03f3ece7d66d");
        if (patchProxyResult.isSupported) {
            return (E)patchProxyResult.result;
        }
        int n3 = NetSparseArray.binarySearch(this.mKeys, 0, this.mSize, n2);
        if (n3 < 0 || this.mValues[n3] == DELETED) {
            return e2;
        }
        return (E)this.mValues[n3];
    }

    public void delete(int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"4a202b50152f57a534274b1b3ad9af94");
        if (patchProxyResult.isSupported) {
            return;
        }
        int n3 = NetSparseArray.binarySearch(this.mKeys, 0, this.mSize, n2);
        if (n3 >= 0 && this.mValues[n3] != DELETED) {
            this.mValues[n3] = DELETED;
            this.mGarbage = true;
        }
    }

    public void remove(int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"13be5761ea0cf3372ef65a629adf25ac");
        if (patchProxyResult.isSupported) {
            return;
        }
        this.delete(n2);
    }

    public void removeAt(int n2) {
        if (this.mValues[n2] != DELETED) {
            this.mValues[n2] = DELETED;
            this.mGarbage = true;
        }
    }

    private void gc() {
        int n2 = this.mSize;
        int n3 = 0;
        int[] nArray = this.mKeys;
        Object[] objectArray = this.mValues;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (object == DELETED) continue;
            if (i2 != n3) {
                nArray[n3] = nArray[i2];
                objectArray[n3] = object;
                objectArray[i2] = null;
            }
            ++n3;
        }
        this.mGarbage = false;
        this.mSize = n3;
    }

    public void put(int n2, E e2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), e2}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"3e3b30adf548babc3d15e84feb1b2aab");
        if (patchProxyResult.isSupported) {
            return;
        }
        int n3 = NetSparseArray.binarySearch(this.mKeys, 0, this.mSize, n2);
        if (n3 >= 0) {
            this.mValues[n3] = e2;
        } else {
            if ((n3 ^= 0xFFFFFFFF) < this.mSize && this.mValues[n3] == DELETED) {
                this.mKeys[n3] = n2;
                this.mValues[n3] = e2;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mKeys.length) {
                this.gc();
                n3 = ~NetSparseArray.binarySearch(this.mKeys, 0, this.mSize, n2);
            }
            if (this.mSize >= this.mKeys.length) {
                int n4 = this.mSize + 20;
                int[] nArray = new int[n4];
                Object[] objectArray = new Object[n4];
                System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
                this.mKeys = nArray;
                this.mValues = objectArray;
            }
            if (this.mSize - n3 != 0) {
                System.arraycopy(this.mKeys, n3, this.mKeys, n3 + 1, this.mSize - n3);
                System.arraycopy(this.mValues, n3, this.mValues, n3 + 1, this.mSize - n3);
            }
            this.mKeys[n3] = n2;
            this.mValues[n3] = e2;
            ++this.mSize;
        }
    }

    public void toArray(E[] EArray) {
        for (int i2 = 0; i2 < EArray.length; ++i2) {
            EArray[i2] = this.mValues[i2];
        }
    }

    public int size() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"fabf104001afc86f608507393228b863");
        if (patchProxyResult.isSupported) {
            return (Integer)patchProxyResult.result;
        }
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public int keyAt(int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"eebc0da3d106665a285485b6305b66f1");
        if (patchProxyResult.isSupported) {
            return (Integer)patchProxyResult.result;
        }
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[n2];
    }

    public E valueAt(int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"2a76aea40f0fb82faa86cd191594dded");
        if (patchProxyResult.isSupported) {
            return (E)patchProxyResult.result;
        }
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[n2];
    }

    public void setValueAt(int n2, E e2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), e2}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"49e14bb553bb1476fb24c844b32c6c41");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[n2] = e2;
    }

    public int indexOfKey(int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"d14186649cc2a9ec1ad23335bc234259");
        if (patchProxyResult.isSupported) {
            return (Integer)patchProxyResult.result;
        }
        if (this.mGarbage) {
            this.gc();
        }
        return NetSparseArray.binarySearch(this.mKeys, 0, this.mSize, n2);
    }

    public int indexOfValue(E e2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{e2}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"485787457c0a6d72653ca92927639a03");
        if (patchProxyResult.isSupported) {
            return (Integer)patchProxyResult.result;
        }
        if (this.mGarbage) {
            this.gc();
        }
        for (int i2 = 0; i2 < this.mSize; ++i2) {
            if (this.mValues[i2] != e2) continue;
            return i2;
        }
        return -1;
    }

    public void clear() {
        int n2 = this.mSize;
        Object[] objectArray = this.mValues;
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void append(int n2, E e2) {
        int n3;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), e2}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"90b7cbb47897c3006be94e467d515058");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (this.mSize != 0 && n2 <= this.mKeys[this.mSize - 1]) {
            this.put(n2, e2);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((n3 = this.mSize) >= this.mKeys.length) {
            int n4 = n3 + 1;
            int[] nArray = new int[n4];
            Object[] objectArray = new Object[n4];
            System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
            this.mKeys = nArray;
            this.mValues = objectArray;
        }
        this.mKeys[n3] = n2;
        this.mValues[n3] = e2;
        this.mSize = n3 + 1;
    }

    private static int binarySearch(int[] nArray, int n2, int n3, int n4) {
        int n5 = n2 + n3;
        int n6 = n2 - 1;
        while (n5 - n6 > 1) {
            int n7 = (n5 + n6) / 2;
            if (nArray[n7] < n4) {
                n6 = n7;
                continue;
            }
            n5 = n7;
        }
        if (n5 == n2 + n3) {
            return ~(n2 + n3);
        }
        if (nArray[n5] == n4) {
            return n5;
        }
        return ~n5;
    }

    static {
        DELETED = new Object();
    }
}

