/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.commonsdk.statistics.internal;

import android.content.Context;
import android.content.SharedPreferences;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;
import com.umeng.commonsdk.statistics.common.MLog;
import com.umeng.commonsdk.statistics.internal.PreferenceWrapper;
import com.umeng.commonsdk.statistics.internal.b;

public class StatTracer
implements b {
    public static ChangeQuickRedirect changeQuickRedirect;
    private final int MAX_REQUEST_LIMIT = 3600000;
    public int mSuccessfulRequest;
    public int mFailedRequest;
    private int mLastRequestLatency;
    public long mLastSuccessfulRequestTime;
    private long lastRequestTime = 0L;
    private long firstActivateTime = 0L;
    private static final String KEY_CLIENT_REQUEST_SUCCESS = "successful_request";
    private static final String KEY_CLIENT_REQUEST_FAILED = "failed_requests ";
    private static final String KEY_CLIENT_REQUEST_LATENCY = "last_request_spent_ms";
    private static final String KEY_CLIENT_REQUEST_TIME = "last_request_time";
    private static final String KEY_FIRST_ACTIVATE_TIME = "first_activate_time";
    private static final String KEY_LAST_REQ = "last_req";
    private static Context mContext;

    private StatTracer() {
        this.init();
    }

    public static StatTracer getInstance(Context context) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{context}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"fd947a49b0d92d94f62ddb70b386f804");
        if (patchProxyResult.isSupported) {
            return (StatTracer)patchProxyResult.result;
        }
        if (mContext == null) {
            if (context != null) {
                mContext = context.getApplicationContext();
            } else {
                MLog.e("inside StatTracer. please check context. context must not be null!");
            }
        }
        return a.a;
    }

    private void init() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"d266b9ff27c4d29b3d5855bc69f4a2de");
        if (patchProxyResult.isSupported) {
            return;
        }
        SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(mContext);
        this.mSuccessfulRequest = sharedPreferences.getInt(KEY_CLIENT_REQUEST_SUCCESS, 0);
        this.mFailedRequest = sharedPreferences.getInt(KEY_CLIENT_REQUEST_FAILED, 0);
        this.mLastRequestLatency = sharedPreferences.getInt(KEY_CLIENT_REQUEST_LATENCY, 0);
        this.mLastSuccessfulRequestTime = sharedPreferences.getLong(KEY_CLIENT_REQUEST_TIME, 0L);
        this.lastRequestTime = sharedPreferences.getLong(KEY_LAST_REQ, 0L);
    }

    public int getLastRequestLatency() {
        return this.mLastRequestLatency > 3600000 ? 3600000 : this.mLastRequestLatency;
    }

    public boolean isFirstRequest() {
        boolean bl2 = this.mLastSuccessfulRequestTime == 0L;
        return bl2;
    }

    public void logSuccessfulRequest(boolean bl2) {
        ++this.mSuccessfulRequest;
        if (bl2) {
            this.mLastSuccessfulRequestTime = this.lastRequestTime;
        }
    }

    public void logFailedRequest() {
        ++this.mFailedRequest;
    }

    public void logRequestStart() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"76ba609e41c6d9d5fa4d3c5d8aae70e7");
        if (patchProxyResult.isSupported) {
            return;
        }
        this.lastRequestTime = System.currentTimeMillis();
    }

    public void logRequestEnd() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"8c98c388d13b541128187e32aa155ad9");
        if (patchProxyResult.isSupported) {
            return;
        }
        this.mLastRequestLatency = (int)(System.currentTimeMillis() - this.lastRequestTime);
    }

    public void saveSate() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"7cdbd98418881508c98edeae4a9a4091");
        if (patchProxyResult.isSupported) {
            return;
        }
        SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(mContext);
        sharedPreferences.edit().putInt(KEY_CLIENT_REQUEST_SUCCESS, this.mSuccessfulRequest).putInt(KEY_CLIENT_REQUEST_FAILED, this.mFailedRequest).putInt(KEY_CLIENT_REQUEST_LATENCY, this.mLastRequestLatency).putLong(KEY_LAST_REQ, this.lastRequestTime).putLong(KEY_CLIENT_REQUEST_TIME, this.mLastSuccessfulRequestTime).commit();
    }

    public long getFirstActivateTime() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"ef32a5f77daa0ea634bd8edd8985d71b");
        if (patchProxyResult.isSupported) {
            return (Long)patchProxyResult.result;
        }
        SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(mContext);
        this.firstActivateTime = PreferenceWrapper.getDefault(mContext).getLong(KEY_FIRST_ACTIVATE_TIME, 0L);
        if (this.firstActivateTime == 0L) {
            this.firstActivateTime = System.currentTimeMillis();
            sharedPreferences.edit().putLong(KEY_FIRST_ACTIVATE_TIME, this.firstActivateTime).commit();
        }
        return this.firstActivateTime;
    }

    public long getLastReqTime() {
        return this.lastRequestTime;
    }

    @Override
    public void onRequestStart() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"3402947a2fd2f5f11888730378679aff");
        if (patchProxyResult.isSupported) {
            return;
        }
        this.logRequestStart();
    }

    @Override
    public void onRequestEnd() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"a3abb5139bd52466fb6dab378422703e");
        if (patchProxyResult.isSupported) {
            return;
        }
        this.logRequestEnd();
    }

    @Override
    public void onRequestSucceed(boolean bl2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Byte((byte)(bl2 ? 1 : 0))}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"ebdcaa1440b59491d9dd6dc9c37e13e2");
        if (patchProxyResult.isSupported) {
            return;
        }
        this.logSuccessfulRequest(bl2);
    }

    @Override
    public void onRequestFailed() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"823bc3c98afe7113f5b39a0605325657");
        if (patchProxyResult.isSupported) {
            return;
        }
        this.logFailedRequest();
    }

    static {
        mContext = null;
    }

    public static class a {
        public static final StatTracer a = new StatTracer();

        private a() {
        }
    }
}

