/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.commonsdk.statistics.idtracking;

import android.content.Context;
import android.content.SharedPreferences;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;
import com.umeng.analytics.pro.aw;
import com.umeng.analytics.pro.bm;
import com.umeng.commonsdk.framework.UMEnvelopeBuild;
import com.umeng.commonsdk.internal.crash.UMCrashManager;
import com.umeng.commonsdk.statistics.common.DataHelper;
import com.umeng.commonsdk.statistics.common.HelperUtils;
import com.umeng.commonsdk.statistics.common.b;
import com.umeng.commonsdk.statistics.internal.PreferenceWrapper;
import com.umeng.commonsdk.utils.UMUtils;
import java.io.File;
import org.json.JSONObject;

public class Envelope {
    public static ChangeQuickRedirect changeQuickRedirect;
    private final byte[] SEED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private final int CODEX_ENCRYPT = 1;
    private final int CODEX_NORMAL = 0;
    private String mVersion = "1.0";
    private String mAddress = null;
    private byte[] mSignature = null;
    private byte[] mGuid = null;
    private byte[] mChecksum = null;
    private int mSerialNo = 0;
    private int mTimestamp = 0;
    private int mLength = 0;
    private byte[] mEntity = null;
    private byte[] identity = null;
    private boolean encrypt = false;
    private static final String dummyID1 = "1234567890987654321";
    private static final String dummyID2 = "02:00:00:00:00:00";

    private Envelope(byte[] byArray, String string2, byte[] byArray2) throws Exception {
        if (byArray == null || byArray.length == 0) {
            throw new Exception("entity is null or empty");
        }
        this.mAddress = string2;
        this.mLength = byArray.length;
        this.mEntity = b.a(byArray);
        this.mTimestamp = (int)(System.currentTimeMillis() / 1000L);
        this.identity = byArray2;
    }

    public static String getSignature(Context context) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{context}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"b8a37434aeff2ec27acf1371f9878332");
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(context);
        if (sharedPreferences == null) {
            return null;
        }
        return sharedPreferences.getString("signature", null);
    }

    public void setSignature(String string2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string2}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"9b58b04df67dc236d26444ad045dcd68");
        if (patchProxyResult.isSupported) {
            return;
        }
        this.mSignature = DataHelper.reverseHexString(string2);
    }

    public String getSignature() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"3ba0d688742fe7ee56b4a28f9b930315");
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        return DataHelper.toHexString(this.mSignature);
    }

    public void setSerialNumber(int n2) {
        this.mSerialNo = n2;
    }

    public void setEncrypt(boolean bl2) {
        this.encrypt = bl2;
    }

    public static Envelope genEnvelope(Context context, String string2, byte[] byArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{context, string2, byArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"46b4ccba010a9e0b78fb4116f83e433c");
        if (patchProxyResult.isSupported) {
            return (Envelope)patchProxyResult.result;
        }
        try {
            SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(context);
            String string3 = sharedPreferences.getString("signature", null);
            int n2 = sharedPreferences.getInt("serial", 1);
            Envelope envelope = new Envelope(byArray, string2, "123456789098765432102:00:00:00:00:00".getBytes());
            envelope.setSignature(string3);
            envelope.setSerialNumber(n2);
            envelope.seal();
            sharedPreferences.edit().putInt("serial", n2 + 1).putString("signature", envelope.getSignature()).commit();
            envelope.export(context);
            return envelope;
        }
        catch (Exception exception) {
            UMCrashManager.reportCrash(context, exception);
            return null;
        }
    }

    public static Envelope genEncryptEnvelope(Context context, String string2, byte[] byArray) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{context, string2, byArray}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"ca2104c83164c6124929d27316df3430");
        if (patchProxyResult.isSupported) {
            return (Envelope)patchProxyResult.result;
        }
        try {
            SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(context);
            String string3 = sharedPreferences.getString("signature", null);
            int n2 = sharedPreferences.getInt("serial", 1);
            Envelope envelope = new Envelope(byArray, string2, "123456789098765432102:00:00:00:00:00".getBytes());
            envelope.setEncrypt(true);
            envelope.setSignature(string3);
            envelope.setSerialNumber(n2);
            envelope.seal();
            sharedPreferences.edit().putInt("serial", n2 + 1).putString("signature", envelope.getSignature()).commit();
            envelope.export(context);
            return envelope;
        }
        catch (Exception exception) {
            UMCrashManager.reportCrash(context, exception);
            return null;
        }
    }

    public void seal() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"71cb8395a34968186e3f307e05036dee");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (this.mSignature == null) {
            this.mSignature = this.genSignature();
        }
        if (this.encrypt) {
            byte[] byArray = new byte[16];
            try {
                System.arraycopy(this.mSignature, 1, byArray, 0, 16);
                this.mEntity = DataHelper.encrypt(this.mEntity, byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mGuid = this.genGuid(this.mSignature, this.mTimestamp);
        this.mChecksum = this.genCheckSum();
    }

    private byte[] genGuid(byte[] byArray, int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{byArray, new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"6371cfd7db8c3f85092e0560d7653c74");
        if (patchProxyResult.isSupported) {
            return (byte[])patchProxyResult.result;
        }
        byte[] byArray2 = DataHelper.hash(this.identity);
        byte[] byArray3 = DataHelper.hash(this.mEntity);
        int n3 = byArray2.length;
        byte[] byArray4 = new byte[n3 * 2];
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray4[i2 * 2] = byArray3[i2];
            byArray4[i2 * 2 + 1] = byArray2[i2];
        }
        byte[] byArray5 = byArray;
        for (int i3 = 0; i3 < 2; ++i3) {
            byArray4[i3] = byArray5[i3];
            byArray4[byArray4.length - i3 - 1] = byArray5[byArray5.length - i3 - 1];
        }
        byte[] byArray6 = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >>> 24)};
        for (int i4 = 0; i4 < byArray4.length; ++i4) {
            byArray4[i4] = (byte)(byArray4[i4] ^ byArray6[i4 % 4]);
        }
        return byArray4;
    }

    private byte[] genSignature() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"1ab19e9d60378dd8384ff39ae43d13f0");
        if (patchProxyResult.isSupported) {
            return (byte[])patchProxyResult.result;
        }
        return this.genGuid(this.SEED, (int)(System.currentTimeMillis() / 1000L));
    }

    private byte[] genCheckSum() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"cfa801f0147d376c1b900c5bb7927727");
        if (patchProxyResult.isSupported) {
            return (byte[])patchProxyResult.result;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DataHelper.toHexString(this.mSignature));
        stringBuilder.append(this.mSerialNo);
        stringBuilder.append(this.mTimestamp);
        stringBuilder.append(this.mLength);
        stringBuilder.append(DataHelper.toHexString(this.mGuid));
        return DataHelper.hash(stringBuilder.toString().getBytes());
    }

    public byte[] toBinary() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"3787b6ac6dde32742fd7d183a030f060");
        if (patchProxyResult.isSupported) {
            return (byte[])patchProxyResult.result;
        }
        aw aw2 = new aw();
        aw2.a(this.mVersion);
        aw2.b(this.mAddress);
        aw2.c(DataHelper.toHexString(this.mSignature));
        aw2.a(this.mSerialNo);
        aw2.b(this.mTimestamp);
        aw2.c(this.mLength);
        aw2.a(this.mEntity);
        aw2.d(this.encrypt ? 1 : 0);
        aw2.d(DataHelper.toHexString(this.mGuid));
        aw2.e(DataHelper.toHexString(this.mChecksum));
        try {
            return new bm().a(aw2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void export(Context context) {
        JSONObject jSONObject;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{context}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"c5fb3b8ce51358762b4e303b2d476fe2");
        if (patchProxyResult.isSupported) {
            return;
        }
        String string2 = this.mAddress;
        String string3 = UMEnvelopeBuild.imprintProperty(context, "umid", null);
        String string4 = DataHelper.toHexString(this.mSignature);
        byte[] byArray = new byte[16];
        System.arraycopy(this.mSignature, 2, byArray, 0, 16);
        String string5 = DataHelper.toHexString(DataHelper.hash(byArray));
        try {
            jSONObject = new JSONObject();
            jSONObject.put("appkey", (Object)string2);
            if (string3 != null) {
                jSONObject.put("umid", (Object)string3);
            }
            jSONObject.put("signature", (Object)string4);
            jSONObject.put("checksum", (Object)string5);
            File file = new File(context.getFilesDir(), ".umeng");
            if (!file.exists()) {
                file.mkdir();
            }
            HelperUtils.writeFile(new File(file, "exchangeIdentity.json"), jSONObject.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            jSONObject = new JSONObject();
            jSONObject.put("appkey", (Object)string2);
            jSONObject.put("channel", (Object)UMUtils.getChannel(context));
            if (string3 != null) {
                jSONObject.put("umid", (Object)HelperUtils.getUmengMD5(string3));
            }
            HelperUtils.writeFile(new File(context.getFilesDir(), "exid.dat"), jSONObject.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String toString() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"ab74e0809e472cd3556497306af45107");
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("version : %s\n", this.mVersion));
        stringBuilder.append(String.format("address : %s\n", this.mAddress));
        stringBuilder.append(String.format("signature : %s\n", DataHelper.toHexString(this.mSignature)));
        stringBuilder.append(String.format("serial : %s\n", this.mSerialNo));
        stringBuilder.append(String.format("timestamp : %d\n", this.mTimestamp));
        stringBuilder.append(String.format("length : %d\n", this.mLength));
        stringBuilder.append(String.format("guid : %s\n", DataHelper.toHexString(this.mGuid)));
        stringBuilder.append(String.format("checksum : %s ", DataHelper.toHexString(this.mChecksum)));
        stringBuilder.append(String.format("codex : %d", this.encrypt ? 1 : 0));
        return stringBuilder.toString();
    }
}

