/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.commonsdk.statistics.common;

import android.content.Context;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;
import com.umeng.commonsdk.framework.UMEnvelopeBuild;
import com.umeng.commonsdk.framework.UMModuleRegister;
import com.umeng.commonsdk.statistics.common.DeviceConfig;
import com.umeng.commonsdk.statistics.internal.StatTracer;
import com.umeng.commonsdk.statistics.noise.Defcon;

public class ReportPolicy {
    public static ChangeQuickRedirect changeQuickRedirect;
    public static final int REALTIME = 0;
    public static final int BATCH_AT_LAUNCH = 1;
    static final int BATCH_AT_TERMINATE = 2;
    static final int IMMEDIATE = 3;
    public static final int DAILY = 4;
    public static final int WIFIONLY = 5;
    public static final int BATCH_BY_INTERVAL = 6;
    public static final int SMART_POLICY = 8;
    public static final int QUASI_REALTIME_POLICY = 11;

    public static boolean isValid(int n2) {
        boolean bl2 = false;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                bl2 = true;
                break;
            }
            default: {
                bl2 = false;
            }
        }
        return bl2;
    }

    public static class DebugPolicy
    extends ReportStrategy {
        public static ChangeQuickRedirect changeQuickRedirect;
        private final long ReportInterval = 15000L;
        private StatTracer mTracer;

        public DebugPolicy(StatTracer statTracer) {
            this.mTracer = statTracer;
        }

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Byte((byte)(bl2 ? 1 : 0))}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"47989b3fd61cf1c6cbe6e3d1c8996ee5");
            if (patchProxyResult.isSupported) {
                return (Boolean)patchProxyResult.result;
            }
            return System.currentTimeMillis() - UMEnvelopeBuild.getLastSuccessfulBuildTime(UMModuleRegister.getAppContext()) >= 15000L;
        }
    }

    public static class SmartPolicy
    extends ReportStrategy {
        public static ChangeQuickRedirect changeQuickRedirect;
        private final long ReportInterval = 10800000L;
        private StatTracer mTracer;

        public SmartPolicy(StatTracer statTracer) {
            this.mTracer = statTracer;
        }

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Byte((byte)(bl2 ? 1 : 0))}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"b417560b0c5ef8b6788fa9c5b9eedbbc");
            if (patchProxyResult.isSupported) {
                return (Boolean)patchProxyResult.result;
            }
            return System.currentTimeMillis() - UMEnvelopeBuild.getLastSuccessfulBuildTime(UMModuleRegister.getAppContext()) >= 10800000L;
        }
    }

    public static class LatentPolicy
    extends ReportStrategy {
        public static ChangeQuickRedirect changeQuickRedirect;
        private long latency;
        private long start = 0L;

        public LatentPolicy(int n2) {
            this.latency = n2;
            this.start = System.currentTimeMillis();
        }

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Byte((byte)(bl2 ? 1 : 0))}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"f3cb5e0e825b2c41294800d4ed9cabd9");
            if (patchProxyResult.isSupported) {
                return (Boolean)patchProxyResult.result;
            }
            return System.currentTimeMillis() - this.start >= this.latency;
        }

        @Override
        public boolean isValid() {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"ba7f27920f8482b370fe89df832beae6");
            if (patchProxyResult.isSupported) {
                return (Boolean)patchProxyResult.result;
            }
            return System.currentTimeMillis() - this.start < this.latency;
        }
    }

    public static class DefconPolicy
    extends ReportStrategy {
        public static ChangeQuickRedirect changeQuickRedirect;
        private Defcon defcon;
        private StatTracer tracer;

        public DefconPolicy(StatTracer statTracer, Defcon defcon) {
            this.tracer = statTracer;
            this.defcon = defcon;
        }

        public boolean shouldSendMessageByInstant() {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"eb4cbb695860f6694ecc30418ef3dcdc");
            if (patchProxyResult.isSupported) {
                return (Boolean)patchProxyResult.result;
            }
            long l2 = System.currentTimeMillis();
            long l3 = this.defcon.getReqInterval();
            return l2 - UMEnvelopeBuild.getLastInstantBuildTime(UMModuleRegister.getAppContext()) >= l3;
        }

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Byte((byte)(bl2 ? 1 : 0))}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"1d7c362be5d969ffb5083c21364ab545");
            if (patchProxyResult.isSupported) {
                return (Boolean)patchProxyResult.result;
            }
            long l2 = System.currentTimeMillis();
            long l3 = this.defcon.getReqInterval();
            return l2 - UMEnvelopeBuild.getLastSuccessfulBuildTime(UMModuleRegister.getAppContext()) >= l3;
        }

        @Override
        public boolean isValid() {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"ba83a1883d70b3a0e3ff3da7f578f4fe");
            if (patchProxyResult.isSupported) {
                return (Boolean)patchProxyResult.result;
            }
            return this.defcon.isOpen();
        }
    }

    public static class ReportWifiOnly
    extends ReportStrategy {
        public static ChangeQuickRedirect changeQuickRedirect;
        private Context mContext = null;

        public ReportWifiOnly(Context context) {
            this.mContext = context;
        }

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Byte((byte)(bl2 ? 1 : 0))}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"e76593e5f12e7b0e9c7c8ef3b9f293c8");
            if (patchProxyResult.isSupported) {
                return (Boolean)patchProxyResult.result;
            }
            return DeviceConfig.isWiFiAvailable(this.mContext);
        }
    }

    public static class ReportDaily
    extends ReportStrategy {
        public static ChangeQuickRedirect changeQuickRedirect;
        private long HOURS_DAY = 86400000L;
        private StatTracer mTracer;

        public ReportDaily(StatTracer statTracer) {
            this.mTracer = statTracer;
        }

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Byte((byte)(bl2 ? 1 : 0))}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"b578c1defaaa7729958eb61c86dbfc40");
            if (patchProxyResult.isSupported) {
                return (Boolean)patchProxyResult.result;
            }
            return System.currentTimeMillis() - UMEnvelopeBuild.getLastSuccessfulBuildTime(UMModuleRegister.getAppContext()) >= this.HOURS_DAY;
        }
    }

    public static class ReportByInterval
    extends ReportStrategy {
        public static ChangeQuickRedirect changeQuickRedirect;
        private static long MIN_REPORT_INTERVAL;
        private static long MAX_REPORT_INTERVAL;
        private long mReportInterval;
        private StatTracer mTracer;

        public ReportByInterval(StatTracer statTracer, long l2) {
            this.mTracer = statTracer;
            this.setReportInterval(l2);
        }

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Byte((byte)(bl2 ? 1 : 0))}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"eea62a715769deaf722d4bff180c389b");
            if (patchProxyResult.isSupported) {
                return (Boolean)patchProxyResult.result;
            }
            if (bl2) {
                return true;
            }
            return System.currentTimeMillis() - UMEnvelopeBuild.getLastSuccessfulBuildTime(UMModuleRegister.getAppContext()) >= this.mReportInterval;
        }

        public void setReportInterval(long l2) {
            this.mReportInterval = l2 >= MIN_REPORT_INTERVAL && l2 <= MAX_REPORT_INTERVAL ? l2 : MIN_REPORT_INTERVAL;
        }

        public long getReportInterval() {
            return this.mReportInterval;
        }

        public static boolean isValidValue(int n2) {
            return (long)n2 >= MIN_REPORT_INTERVAL;
        }

        static {
            MIN_REPORT_INTERVAL = 90000L;
            MAX_REPORT_INTERVAL = 86400000L;
        }
    }

    public static class ReportAtLaunch
    extends ReportStrategy {
        public static ChangeQuickRedirect changeQuickRedirect;

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            return bl2;
        }
    }

    public static class ReportRealtime
    extends ReportStrategy {
        public static ChangeQuickRedirect changeQuickRedirect;

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            return true;
        }
    }

    public static class ReportQuasiRealtime
    extends ReportStrategy {
        public static ChangeQuickRedirect changeQuickRedirect;
        private static long DEFAULT_REPORT_INTERVAL;
        private static long MIN_REPORT_INTERVAL;
        private static long MAX_REPORT_INTERVAL;
        private long mReportInterval;

        @Override
        public boolean shouldSendMessage(boolean bl2) {
            return true;
        }

        public long getReportInterval() {
            return this.mReportInterval;
        }

        public void setReportInterval(long l2) {
            this.mReportInterval = l2 >= MIN_REPORT_INTERVAL && l2 <= MAX_REPORT_INTERVAL ? l2 : DEFAULT_REPORT_INTERVAL;
        }

        static {
            DEFAULT_REPORT_INTERVAL = 15000L;
            MIN_REPORT_INTERVAL = 3000L;
            MAX_REPORT_INTERVAL = 90000L;
        }
    }

    public static class ReportStrategy {
        public static ChangeQuickRedirect changeQuickRedirect;

        public boolean shouldSendMessage(boolean bl2) {
            return true;
        }

        public boolean isValid() {
            return true;
        }
    }
}

