/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.utils;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;
import com.taobao.aranger.ARanger;
import com.taobao.aranger.exception.IPCException;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public class IPCUtils {
    public static ChangeQuickRedirect changeQuickRedirect;
    private static Set<String> providerInfoSet;
    private static List<ProviderInfo> providerInfoList;
    private static String sCurrentProcessName;

    public static String getProcessNameFromUri(Uri uri) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{uri}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"7a962966b063d596695c1efcdcd2940f");
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        for (ProviderInfo providerInfo : providerInfoList) {
            if (!IPCUtils.getContentAuthorities(providerInfo.authority).equals((Object)uri)) continue;
            return providerInfo.processName;
        }
        return null;
    }

    public static int getUserIdFromAuthority(String string2, int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string2, new Integer(n2)}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"6a6c12e7e865edfe1f86177bc2b47923");
        if (patchProxyResult.isSupported) {
            return (Integer)patchProxyResult.result;
        }
        if (string2 == null) {
            return n2;
        }
        int n3 = string2.lastIndexOf(64);
        if (n3 == -1) {
            return n2;
        }
        String string3 = string2.substring(0, n3);
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -10000;
        }
    }

    public static String getAuthorityWithoutUserId(String string2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"1a87ed12111883e5b4fcf63ce639e074");
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        if (string2 == null) {
            return null;
        }
        int n2 = string2.lastIndexOf(64);
        return string2.substring(n2 + 1);
    }

    private static Uri getContentAuthorities(String string2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"6980bc8e74fad54b2e3d7ba1e22d9690");
        if (patchProxyResult.isSupported) {
            return (Uri)patchProxyResult.result;
        }
        return Uri.parse((String)("content://" + string2));
    }

    public static Uri queryContentAuthorityFromProvider(ComponentName componentName) throws IPCException {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{componentName}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"bc5ae6909e4b3c03b884f7a71e31c4f2");
        if (patchProxyResult.isSupported) {
            return (Uri)patchProxyResult.result;
        }
        try {
            if (!providerInfoSet.contains(componentName.getPackageName())) {
                providerInfoSet.add(componentName.getPackageName());
                Collections.addAll(providerInfoList, ARanger.getContext().getPackageManager().getPackageInfo((String)componentName.getPackageName(), (int)8).providers);
            }
            for (ProviderInfo providerInfo : providerInfoList) {
                if (!providerInfo.name.equals(componentName.getClassName())) continue;
                return IPCUtils.getContentAuthorities(providerInfo.authority);
            }
        }
        catch (Exception exception) {
            throw new IPCException(30, (Throwable)exception);
        }
        throw new IPCException(29, "can't find authorities in the " + componentName.getClass() + ", please check the provider is correct.");
    }

    public static boolean isProcessAlive(ComponentName componentName) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{componentName}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"aee793a30c8b82b7129056b36efe346b");
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        String string2 = "";
        try {
            if (!providerInfoSet.contains(componentName.getPackageName())) {
                providerInfoSet.add(componentName.getPackageName());
                Collections.addAll(providerInfoList, ARanger.getContext().getPackageManager().getPackageInfo((String)componentName.getPackageName(), (int)8).providers);
            }
            for (ProviderInfo object2 : providerInfoList) {
                if (!object2.name.equals(componentName.getClassName())) continue;
                string2 = object2.processName;
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        ActivityManager activityManager = (ActivityManager)ARanger.getContext().getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        if (list == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            if (!runningAppProcessInfo.processName.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static String getCurrentProcessName() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"3f18a3bc01e24814832d18f1723e624a");
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        if (sCurrentProcessName == null || sCurrentProcessName.length() == 0) {
            sCurrentProcessName = IPCUtils.getProcessName(Process.myPid());
        }
        return sCurrentProcessName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessName(int n2) {
        Object object;
        Object object2;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2)}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"f19e7d959ce567c4ac4c7470c80bbba7");
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        ActivityManager activityManager = (ActivityManager)ARanger.getContext().getSystemService("activity");
        if (activityManager != null && (object2 = activityManager.getRunningAppProcesses()) != null && !object2.isEmpty()) {
            object = object2.iterator();
            while (object.hasNext()) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                if (runningAppProcessInfo == null || runningAppProcessInfo.pid != n2) continue;
                return runningAppProcessInfo.processName;
            }
        }
        object2 = new byte[128];
        object = null;
        try {
            object = new FileInputStream("/proc/" + n2 + "/cmdline");
            int n3 = ((FileInputStream)object).read((byte[])object2);
            if (n3 <= 0) {
                String string2 = null;
                return string2;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                if (object2[i2] > 0) {
                    continue;
                }
                n3 = i2;
                break;
            }
            String string3 = new String((byte[])object2, 0, n3);
            return string3;
        }
        catch (Exception exception) {
            String string4 = null;
            return string4;
        }
        finally {
            try {
                if (object != null) {
                    ((FileInputStream)object).close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static {
        providerInfoSet = new CopyOnWriteArraySet<String>();
        providerInfoList = new CopyOnWriteArrayList<ProviderInfo>();
    }
}

