/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.ipc.channel;

import android.app.ActivityThread;
import android.content.ContentResolver;
import android.content.IContentProvider;
import android.content.Intent;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.text.TextUtils;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;
import com.taobao.aranger.ARanger;
import com.taobao.aranger.core.entity.Call;
import com.taobao.aranger.core.entity.Reply;
import com.taobao.aranger.core.ipc.channel.BaseRemoteChannel;
import com.taobao.aranger.core.ipc.proxy.RemoteServiceProxy;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.intf.IRemoteService;
import com.taobao.aranger.logs.IPCLog;
import com.taobao.aranger.utils.IPCUtils;
import com.taobao.aranger.utils.ReflectUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class QuickRemoteChannel
extends BaseRemoteChannel {
    public static ChangeQuickRedirect changeQuickRedirect;
    private static final String TAG;
    private final ContentResolver mContentResolver;
    private final ActivityThread mActivityThread;
    private final Uri mRemoteProviderUri;
    private final String mProcessName;
    private Method acquireMethod;
    private IRemoteService remoteService;
    private static final Set<String> sProcessDeathSet;

    QuickRemoteChannel(Uri uri) {
        this.mRemoteProviderUri = uri;
        this.mActivityThread = ActivityThread.currentActivityThread();
        this.mProcessName = IPCUtils.getProcessNameFromUri(uri);
        this.mContentResolver = ARanger.getContext().getContentResolver();
    }

    @Override
    public Reply internalSendCall(Call call) throws IPCException {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{call}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"842ea4a2b0d54f3d8f3c399ff233352f");
        if (patchProxyResult.isSupported) {
            return (Reply)patchProxyResult.result;
        }
        try {
            return this.getRemoteService(this.mRemoteProviderUri).sendCall(call);
        }
        catch (Exception exception) {
            if (exception instanceof IPCException) {
                throw (IPCException)exception;
            }
            if (exception instanceof RemoteException) {
                throw new IPCException(1, (Throwable)exception);
            }
            throw new IPCException(9, (Throwable)exception);
        }
    }

    @Override
    public void internalConnect() throws IPCException {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"1dadca21c2852370d07cda34535c16e3");
        if (patchProxyResult.isSupported) {
            return;
        }
        try {
            this.getRemoteService(this.mRemoteProviderUri).connect();
        }
        catch (Exception exception) {
            if (exception instanceof IPCException) {
                throw (IPCException)exception;
            }
            if (exception instanceof RemoteException) {
                throw new IPCException(1, (Throwable)exception);
            }
            throw new IPCException(9, (Throwable)exception);
        }
    }

    @Override
    public void internalRecycle(List<String> list) throws IPCException {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{list}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"9501296776f270d56e2e1e37a7cc1ddb");
        if (patchProxyResult.isSupported) {
            return;
        }
        try {
            this.getRemoteService(this.mRemoteProviderUri).recycle(list);
        }
        catch (Exception exception) {
            if (exception instanceof IPCException) {
                throw (IPCException)exception;
            }
            if (exception instanceof RemoteException) {
                throw new IPCException(1, (Throwable)exception);
            }
            throw new IPCException(9, (Throwable)exception);
        }
    }

    private IRemoteService getRemoteService(Uri uri) throws Exception {
        IContentProvider iContentProvider;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{uri}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"738d78d90a1e57f00200fbe8f0b3f3dc");
        if (patchProxyResult.isSupported) {
            return (IRemoteService)patchProxyResult.result;
        }
        if (this.remoteService == null || this.remoteService.isRemote() && !this.remoteService.asBinder().isBinderAlive()) {
            try {
                try {
                    if (this.acquireMethod == null) {
                        this.acquireMethod = ReflectUtils.getHideMethod(ContentResolver.class, "acquireUnstableProvider", Uri.class);
                    }
                    iContentProvider = (IContentProvider)this.acquireMethod.invoke((Object)this.mContentResolver, uri);
                }
                catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException exception) {
                    iContentProvider = Build.VERSION.SDK_INT <= 16 ? this.mActivityThread.acquireProvider(ARanger.getContext(), uri.getAuthority(), false) : (Build.VERSION.SDK_INT < 21 ? this.mActivityThread.acquireProvider(ARanger.getContext(), uri.getAuthority(), Binder.getCallingUid() / 100000, false) : this.mActivityThread.acquireProvider(ARanger.getContext(), IPCUtils.getAuthorityWithoutUserId(uri.getAuthority()), IPCUtils.getUserIdFromAuthority(uri.getAuthority(), Process.myUserHandle().hashCode()), false));
                }
                if (iContentProvider == null) {
                    throw new IPCException(19, "can't get content provider");
                }
                this.remoteService = RemoteServiceProxy.getProxy(iContentProvider.asBinder());
            }
            catch (Exception exception) {
                throw new IPCException(19, (Throwable)exception);
            }
        }
        if (this.remoteService.isRemote() && !sProcessDeathSet.contains(this.mProcessName)) {
            sProcessDeathSet.add(this.mProcessName);
            iContentProvider = this.remoteService.asBinder();
            try {
                iContentProvider.linkToDeath(new IBinder.DeathRecipient((IBinder)iContentProvider){
                    public static ChangeQuickRedirect changeQuickRedirect;
                    final /* synthetic */ IBinder val$iBinder;
                    {
                        this.val$iBinder = iBinder;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void binderDied() {
                        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"e203c0e78a0d50129a5a9a8d6f52c7f1");
                        if (patchProxyResult.isSupported) {
                            return;
                        }
                        this.val$iBinder.unlinkToDeath((IBinder.DeathRecipient)this, 0);
                        Class<QuickRemoteChannel> clazz = QuickRemoteChannel.class;
                        synchronized (QuickRemoteChannel.class) {
                            if (!TextUtils.isEmpty((CharSequence)QuickRemoteChannel.this.mProcessName) && sProcessDeathSet.contains(QuickRemoteChannel.this.mProcessName)) {
                                Intent intent = new Intent();
                                intent.setAction("com.taobao.aranger.DISCONNECT");
                                intent.putExtra("processName", QuickRemoteChannel.this.mProcessName);
                                ARanger.getContext().sendBroadcast(intent);
                                sProcessDeathSet.remove(QuickRemoteChannel.this.mProcessName);
                            }
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                    }
                }, 0);
            }
            catch (RemoteException remoteException) {
                IPCLog.e(TAG, "[getRemoteService][linkToDeath]", remoteException, new Object[0]);
            }
        }
        return this.remoteService;
    }

    static {
        TAG = QuickRemoteChannel.class.getSimpleName();
        sProcessDeathSet = new CopyOnWriteArraySet<String>();
    }
}

