/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs;

import android.content.Context;
import android.text.TextUtils;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;
import com.taobao.accs.AccsException;
import com.taobao.accs.utl.ALog;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AccsClientConfig
implements Serializable {
    public static ChangeQuickRedirect changeQuickRedirect;
    private static final String TAG = "AccsClientConfig";
    public static final int SECURITY_TAOBAO = 0;
    public static final int SECURITY_OPEN = 1;
    public static final int SECURITY_OFF = 2;
    public static final String DEFAULT_CONFIGTAG = "default";
    public static final String[] DEFAULT_CENTER_HOSTS;
    private static final String[] DEFAULT_CHANNEL_HOSTS;
    private static Context mContext;
    public static boolean loadedStaticConfig;
    @ENV
    public static int mEnv;
    public static Map<String, AccsClientConfig> mReleaseConfigs;
    public static Map<String, AccsClientConfig> mPreviewConfigs;
    public static Map<String, AccsClientConfig> mDebugConfigs;
    private String mAppKey;
    private String mAppSecret;
    private String mInappHost;
    private String mChannelHost;
    private String mStoreId;
    private int mSecurity;
    private String mAuthCode;
    private int mInappPubKey;
    private int mChannelPubKey;
    private boolean mKeepalive;
    private boolean mAutoUnit;
    private String mTag;
    private int mConfigEnv;
    private boolean mDisableChannel;
    private boolean mQuickReconnect;
    private boolean mAccsHeartbeatEnable;
    private boolean mPullUpEnable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context getContext() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"c12bb8154baa69da86b391f86ad55354");
        if (patchProxyResult.isSupported) {
            return (Context)patchProxyResult.result;
        }
        if (mContext != null) {
            return mContext;
        }
        Class<AccsClientConfig> clazz = AccsClientConfig.class;
        synchronized (AccsClientConfig.class) {
            if (mContext != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return mContext;
            }
            try {
                Class<?> clazz2 = Class.forName("android.app.ActivityThread");
                Object object = clazz2.getMethod("currentActivityThread", new Class[0]).invoke(clazz2, new Object[0]);
                mContext = (Context)object.getClass().getMethod("getApplication", new Class[0]).invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return mContext;
        }
    }

    protected AccsClientConfig() {
    }

    @Deprecated
    public static AccsClientConfig getConfig(String string2) {
        Map<String, AccsClientConfig> map;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"cf44c165b6c3985ab426e51aadd065a5");
        if (patchProxyResult.isSupported) {
            return (AccsClientConfig)patchProxyResult.result;
        }
        switch (mEnv) {
            case 1: {
                map = mPreviewConfigs;
                break;
            }
            case 2: {
                map = mDebugConfigs;
                break;
            }
            default: {
                map = mReleaseConfigs;
            }
        }
        for (AccsClientConfig accsClientConfig : map.values()) {
            if (!accsClientConfig.mAppKey.equals(string2) || accsClientConfig.mConfigEnv != mEnv) continue;
            return accsClientConfig;
        }
        ALog.e(TAG, "getConfigByTag return null", "appkey", string2);
        return null;
    }

    public static AccsClientConfig getConfigByTag(String string2) {
        AccsClientConfig accsClientConfig;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"c1d0c0aa5498f64e3aa028bd7c900e13");
        if (patchProxyResult.isSupported) {
            return (AccsClientConfig)patchProxyResult.result;
        }
        switch (mEnv) {
            case 1: {
                accsClientConfig = mPreviewConfigs.get(string2);
                break;
            }
            case 2: {
                accsClientConfig = mDebugConfigs.get(string2);
                break;
            }
            case 0: {
                accsClientConfig = mReleaseConfigs.get(string2);
                break;
            }
            default: {
                accsClientConfig = mReleaseConfigs.get(string2);
            }
        }
        if (accsClientConfig == null) {
            ALog.e(TAG, "getConfigByTag return null", "configTag", string2);
        }
        return accsClientConfig;
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public String getAppSecret() {
        return this.mAppSecret;
    }

    public String getInappHost() {
        return this.mInappHost;
    }

    public String getChannelHost() {
        return this.mChannelHost;
    }

    public int getSecurity() {
        return this.mSecurity;
    }

    public String getAuthCode() {
        return this.mAuthCode;
    }

    public int getInappPubKey() {
        return this.mInappPubKey;
    }

    public int getChannelPubKey() {
        return this.mChannelPubKey;
    }

    public boolean isKeepalive() {
        return this.mKeepalive;
    }

    public boolean isAutoUnit() {
        return this.mAutoUnit;
    }

    public String getTag() {
        return this.mTag;
    }

    public int getConfigEnv() {
        return this.mConfigEnv;
    }

    public boolean getDisableChannel() {
        return this.mDisableChannel;
    }

    public boolean isQuickReconnect() {
        return this.mQuickReconnect;
    }

    public String getStoreId() {
        return this.mStoreId;
    }

    public boolean isAccsHeartbeatEnable() {
        return this.mAccsHeartbeatEnable;
    }

    public boolean isPullUpEnable() {
        return this.mPullUpEnable;
    }

    public String toString() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"fabdf1363e89fdf4b6acb51faccb5955");
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        return "AccsClientConfig{" + "Tag=" + this.mTag + ", ConfigEnv=" + this.mConfigEnv + ", AppKey=" + this.mAppKey + ", AppSecret=" + this.mAppSecret + ", InappHost=" + this.mInappHost + ", ChannelHost=" + this.mChannelHost + ", Security=" + this.mSecurity + ", AuthCode=" + this.mAuthCode + ", InappPubKey=" + this.mInappPubKey + ", ChannelPubKey=" + this.mChannelPubKey + ", Keepalive=" + this.mKeepalive + ", AutoUnit=" + this.mAutoUnit + ", DisableChannel=" + this.mDisableChannel + ", QuickReconnect=" + this.mQuickReconnect + "}";
    }

    public boolean equals(Object object) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{object}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"85b9a83b88d8d3256bf3fdbb9703e8b5");
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccsClientConfig)) {
            return false;
        }
        AccsClientConfig accsClientConfig = (AccsClientConfig)object;
        return this.mSecurity == accsClientConfig.mSecurity && this.mInappPubKey == accsClientConfig.mInappPubKey && this.mChannelPubKey == accsClientConfig.mChannelPubKey && this.mKeepalive == accsClientConfig.mKeepalive && this.mAutoUnit == accsClientConfig.mAutoUnit && this.mConfigEnv == accsClientConfig.mConfigEnv && this.mDisableChannel == accsClientConfig.mDisableChannel && this.mQuickReconnect == accsClientConfig.mQuickReconnect && this.mAccsHeartbeatEnable == accsClientConfig.mAccsHeartbeatEnable && this.mAppKey.equals(accsClientConfig.mAppKey) && this.mAppSecret.equals(accsClientConfig.mAppSecret) && this.mInappHost.equals(accsClientConfig.mInappHost) && this.mChannelHost.equals(accsClientConfig.mChannelHost) && this.mStoreId.equals(accsClientConfig.mStoreId) && this.mAuthCode.equals(accsClientConfig.mAuthCode) && this.mTag.equals(accsClientConfig.mTag);
    }

    public static void setAccsConfig(int n2, AccsClientConfig accsClientConfig) {
        Map<String, AccsClientConfig> map;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), accsClientConfig}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"2fad34b6896cc92f089bc958d39b1de7");
        if (patchProxyResult.isSupported) {
            return;
        }
        switch (n2) {
            case 1: {
                map = mPreviewConfigs;
                break;
            }
            case 2: {
                map = mDebugConfigs;
                break;
            }
            default: {
                map = mReleaseConfigs;
            }
        }
        AccsClientConfig accsClientConfig2 = map.get(accsClientConfig.getTag());
        if (accsClientConfig2 != null) {
            ALog.w(TAG, "build conver", "old config", accsClientConfig2);
        }
        map.put(accsClientConfig.getTag(), accsClientConfig);
    }

    static {
        DEFAULT_CENTER_HOSTS = new String[]{"msgacs.m.taobao.com", "msgacs.wapa.taobao.com", "msgacs.waptest.taobao.com"};
        DEFAULT_CHANNEL_HOSTS = new String[]{"accscdn.m.taobao.com", "acs.wapa.taobao.com", "acs.waptest.taobao.com"};
        loadedStaticConfig = false;
        mEnv = 0;
        mReleaseConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
        mPreviewConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
        mDebugConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
    }

    public static class Builder {
        public static ChangeQuickRedirect changeQuickRedirect;
        private String mAppKey = "";
        private String mTag = "";
        private String mAppSecret = "";
        private String mInappHost = "";
        private String mChannelHost = "";
        private String mAuthCode = "";
        private String mStoreId = "";
        private int mInappPubKey = -1;
        private int mChannelPubKey = -1;
        private boolean mKeepalive = true;
        private boolean mAutoUnit = true;
        private int mConfigEnv = -1;
        private boolean mDisableChannel = false;
        private boolean mQuickReconnect = false;
        private boolean mAccsHeartbeatEnable = false;
        private boolean mPullUpEnable = true;

        public Builder setAppKey(String string2) {
            this.mAppKey = string2;
            return this;
        }

        public Builder setAppSecret(String string2) {
            this.mAppSecret = string2;
            return this;
        }

        public Builder setInappHost(String string2) {
            this.mInappHost = string2;
            return this;
        }

        public Builder setChannelHost(String string2) {
            this.mChannelHost = string2;
            return this;
        }

        public Builder setAutoCode(String string2) {
            this.mAuthCode = string2;
            return this;
        }

        public Builder setInappPubKey(int n2) {
            this.mInappPubKey = n2;
            return this;
        }

        public Builder setChannelPubKey(int n2) {
            this.mChannelPubKey = n2;
            return this;
        }

        public Builder setKeepAlive(boolean bl2) {
            this.mKeepalive = bl2;
            return this;
        }

        public Builder setAutoUnit(boolean bl2) {
            this.mAutoUnit = bl2;
            return this;
        }

        public Builder setConfigEnv(@ENV int n2) {
            this.mConfigEnv = n2;
            return this;
        }

        public Builder setStoreId(String string2) {
            this.mStoreId = string2;
            return this;
        }

        public Builder setTag(String string2) {
            this.mTag = string2;
            return this;
        }

        public Builder setDisableChannel(boolean bl2) {
            this.mDisableChannel = bl2;
            return this;
        }

        public Builder setQuickReconnect(boolean bl2) {
            this.mQuickReconnect = bl2;
            return this;
        }

        public Builder setAccsHeartbeatEnable(boolean bl2) {
            this.mAccsHeartbeatEnable = bl2;
            return this;
        }

        public Builder setPullUpEnable(boolean bl2) {
            this.mPullUpEnable = bl2;
            return this;
        }

        public AccsClientConfig build() throws AccsException {
            Map<String, AccsClientConfig> map;
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"6c26b7f9677af54937a169f04b8eff1a");
            if (patchProxyResult.isSupported) {
                return (AccsClientConfig)patchProxyResult.result;
            }
            if (TextUtils.isEmpty((CharSequence)this.mAppKey)) {
                throw new AccsException("appkey null");
            }
            AccsClientConfig accsClientConfig = new AccsClientConfig();
            accsClientConfig.mAppKey = this.mAppKey;
            accsClientConfig.mAppSecret = this.mAppSecret;
            accsClientConfig.mAuthCode = this.mAuthCode;
            accsClientConfig.mKeepalive = this.mKeepalive;
            accsClientConfig.mAutoUnit = this.mAutoUnit;
            accsClientConfig.mInappPubKey = this.mInappPubKey;
            accsClientConfig.mChannelPubKey = this.mChannelPubKey;
            accsClientConfig.mInappHost = this.mInappHost;
            accsClientConfig.mChannelHost = this.mChannelHost;
            accsClientConfig.mTag = this.mTag;
            accsClientConfig.mStoreId = this.mStoreId;
            accsClientConfig.mConfigEnv = this.mConfigEnv;
            accsClientConfig.mDisableChannel = this.mDisableChannel;
            accsClientConfig.mQuickReconnect = this.mQuickReconnect;
            accsClientConfig.mAccsHeartbeatEnable = this.mAccsHeartbeatEnable;
            accsClientConfig.mPullUpEnable = this.mPullUpEnable;
            if (accsClientConfig.mConfigEnv < 0) {
                accsClientConfig.mConfigEnv = mEnv;
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mAppSecret)) {
                accsClientConfig.mSecurity = 0;
            } else {
                accsClientConfig.mSecurity = 2;
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mInappHost)) {
                accsClientConfig.mInappHost = DEFAULT_CENTER_HOSTS[accsClientConfig.mConfigEnv];
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mChannelHost)) {
                accsClientConfig.mChannelHost = DEFAULT_CHANNEL_HOSTS[accsClientConfig.mConfigEnv];
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mTag)) {
                accsClientConfig.mTag = accsClientConfig.mAppKey;
            }
            switch (accsClientConfig.mConfigEnv) {
                case 1: {
                    map = mPreviewConfigs;
                    break;
                }
                case 2: {
                    map = mDebugConfigs;
                    break;
                }
                default: {
                    map = mReleaseConfigs;
                }
            }
            ALog.d(AccsClientConfig.TAG, "build", "config", accsClientConfig);
            AccsClientConfig accsClientConfig2 = map.get(accsClientConfig.getTag());
            if (accsClientConfig2 != null) {
                ALog.w(AccsClientConfig.TAG, "build conver", "old config", accsClientConfig2);
            }
            map.put(accsClientConfig.getTag(), accsClientConfig);
            return accsClientConfig;
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ENV {
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface SECURITY_TYPE {
    }
}

