/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.android.hms.agent.common;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import com.huawei.android.hms.agent.common.ActivityMgr;
import com.huawei.android.hms.agent.common.EmptyConnectCallback;
import com.huawei.android.hms.agent.common.HMSAgentActivity;
import com.huawei.android.hms.agent.common.HMSAgentLog;
import com.huawei.android.hms.agent.common.IActivityDestroyedCallback;
import com.huawei.android.hms.agent.common.IActivityPauseCallback;
import com.huawei.android.hms.agent.common.IActivityResumeCallback;
import com.huawei.android.hms.agent.common.IClientConnectCallback;
import com.huawei.android.hms.agent.common.StrUtils;
import com.huawei.android.hms.agent.common.ThreadUtil;
import com.huawei.android.hms.agent.common.UIUtils;
import com.huawei.hms.activity.BridgeActivity;
import com.huawei.hms.api.ConnectionResult;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.api.HuaweiApiClient;
import com.huawei.hms.support.api.push.HuaweiPush;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;
import java.util.ArrayList;
import java.util.List;

public final class ApiClientMgr
implements IActivityDestroyedCallback,
IActivityPauseCallback,
IActivityResumeCallback,
HuaweiApiClient.ConnectionCallbacks,
HuaweiApiClient.OnConnectionFailedListener {
    public static ChangeQuickRedirect changeQuickRedirect;
    public static final ApiClientMgr INST;
    private static final String PACKAGE_NAME_HIAPP = "com.huawei.appmarket";
    private static final Object CALLBACK_LOCK;
    private static final Object STATIC_CALLBACK_LOCK;
    private static final Object APICLIENT_LOCK;
    private static final int APICLIENT_CONNECT_TIMEOUT = 30000;
    private static final int UPDATE_OVER_ACTIVITY_CHECK_TIMEOUT = 3000;
    private static final int APICLIENT_STARTACTIVITY_TIMEOUT = 3000;
    private static final int APICLIENT_TIMEOUT_HANDLE_MSG = 3;
    private static final int APICLIENT_STARTACTIVITY_TIMEOUT_HANDLE_MSG = 4;
    private static final int UPDATE_OVER_ACTIVITY_CHECK_TIMEOUT_HANDLE_MSG = 5;
    private static final int MAX_RESOLVE_TIMES = 3;
    private Context context;
    private String curAppPackageName;
    private HuaweiApiClient apiClient;
    private boolean allowResolveConnectError = false;
    private boolean isResolving;
    private BridgeActivity resolveActivity;
    private boolean hasOverActivity = false;
    private int curLeftResolveTimes = 3;
    private List<IClientConnectCallback> connCallbacks = new ArrayList<IClientConnectCallback>();
    private List<IClientConnectCallback> staticCallbacks = new ArrayList<IClientConnectCallback>();
    private Handler timeoutHandler = new Handler(new Handler.Callback(){
        public static ChangeQuickRedirect changeQuickRedirect;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Message message) {
            boolean bl2;
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{message}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"9ec7ee42242c42d84b5552ac23a7eb19");
            if (patchProxyResult.isSupported) {
                return (Boolean)patchProxyResult.result;
            }
            Object object = CALLBACK_LOCK;
            synchronized (object) {
                bl2 = !ApiClientMgr.this.connCallbacks.isEmpty();
            }
            if (message != null && message.what == 3 && bl2) {
                HMSAgentLog.d("connect time out");
                ApiClientMgr.access$200(ApiClientMgr.this);
                ApiClientMgr.access$300(ApiClientMgr.this, -1007);
                return true;
            }
            if (message != null && message.what == 4 && bl2) {
                HMSAgentLog.d("start activity time out");
                ApiClientMgr.access$300(ApiClientMgr.this, -1007);
                return true;
            }
            if (message != null && message.what == 5 && bl2) {
                HMSAgentLog.d("Discarded update dispose:hasOverActivity=" + ApiClientMgr.this.hasOverActivity + " resolveActivity=" + StrUtils.objDesc((Object)ApiClientMgr.this.resolveActivity));
                if (ApiClientMgr.this.hasOverActivity && ApiClientMgr.this.resolveActivity != null && !ApiClientMgr.this.resolveActivity.isFinishing()) {
                    ApiClientMgr.this.onResolveErrorRst(13);
                }
                return true;
            }
            return false;
        }
    });

    private ApiClientMgr() {
    }

    public void init(Application application) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{application}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"756398cc428a16d6d13beaa7a1f6b208");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("init");
        this.context = application.getApplicationContext();
        this.curAppPackageName = application.getPackageName();
        ActivityMgr.INST.unRegisterActivitResumeEvent(this);
        ActivityMgr.INST.registerActivitResumeEvent(this);
        ActivityMgr.INST.unRegisterActivitPauseEvent(this);
        ActivityMgr.INST.registerActivitPauseEvent(this);
        ActivityMgr.INST.unRegisterActivitDestroyedEvent(this);
        ActivityMgr.INST.registerActivitDestroyedEvent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"6277d94a7639a1175b6a020d5d50abf7");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("release");
        this.isResolving = false;
        this.resolveActivity = null;
        this.hasOverActivity = false;
        HuaweiApiClient huaweiApiClient = this.getApiClient();
        if (huaweiApiClient != null) {
            huaweiApiClient.disconnect();
        }
        Object object = APICLIENT_LOCK;
        synchronized (object) {
            this.apiClient = null;
        }
        object = STATIC_CALLBACK_LOCK;
        synchronized (object) {
            this.staticCallbacks.clear();
        }
        object = CALLBACK_LOCK;
        synchronized (object) {
            this.connCallbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HuaweiApiClient getApiClient() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"60f78fecdbc28ff838e1fd21668b9861");
        if (patchProxyResult.isSupported) {
            return (HuaweiApiClient)patchProxyResult.result;
        }
        Object object = APICLIENT_LOCK;
        synchronized (object) {
            return this.apiClient != null ? this.apiClient : this.resetApiClient();
        }
    }

    public boolean isConnect(HuaweiApiClient huaweiApiClient) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{huaweiApiClient}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"fc47db335fd874ea5c38dee948e5f157");
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        return huaweiApiClient != null && huaweiApiClient.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClientConnect(IClientConnectCallback iClientConnectCallback) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{iClientConnectCallback}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"377003eeb29372a5697fbc3753dbaec2");
        if (patchProxyResult.isSupported) {
            return;
        }
        Object object = STATIC_CALLBACK_LOCK;
        synchronized (object) {
            this.staticCallbacks.add(iClientConnectCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientConnectCallback(IClientConnectCallback iClientConnectCallback) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{iClientConnectCallback}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"e08e248108f907368c80aa0e3ed9105b");
        if (patchProxyResult.isSupported) {
            return;
        }
        Object object = STATIC_CALLBACK_LOCK;
        synchronized (object) {
            this.staticCallbacks.remove(iClientConnectCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HuaweiApiClient resetApiClient() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"f846c2983a5fec1b9b08a42b145fa711");
        if (patchProxyResult.isSupported) {
            return (HuaweiApiClient)patchProxyResult.result;
        }
        if (this.context == null) {
            HMSAgentLog.e("HMSAgent not init");
            return null;
        }
        Object object = APICLIENT_LOCK;
        synchronized (object) {
            if (this.apiClient != null) {
                ApiClientMgr.disConnectClientDelay(this.apiClient, 60000);
            }
            HMSAgentLog.d("reset client");
            this.apiClient = new HuaweiApiClient.Builder(this.context).addApi(HuaweiPush.PUSH_API).addConnectionCallbacks(INST).addOnConnectionFailedListener(INST).build();
            return this.apiClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(IClientConnectCallback iClientConnectCallback, boolean bl2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{iClientConnectCallback, new Byte((byte)(bl2 ? 1 : 0))}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"b053312982d2898faa231e7cbe43bcc1");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (this.context == null) {
            this.aSysnCallback(-1000, iClientConnectCallback);
            return;
        }
        HuaweiApiClient huaweiApiClient = this.getApiClient();
        if (huaweiApiClient != null && huaweiApiClient.isConnected()) {
            HMSAgentLog.d("client is valid");
            this.aSysnCallback(0, iClientConnectCallback);
            return;
        }
        Object object = CALLBACK_LOCK;
        synchronized (object) {
            HMSAgentLog.d("client is invalid\uff1asize=" + this.connCallbacks.size());
            boolean bl3 = this.allowResolveConnectError = this.allowResolveConnectError || bl2;
            if (this.connCallbacks.isEmpty()) {
                this.connCallbacks.add(iClientConnectCallback);
                this.curLeftResolveTimes = 3;
                this.startConnect();
            } else {
                this.connCallbacks.add(iClientConnectCallback);
            }
        }
    }

    private void startConnect() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"3d725196e07e8e952c84de7a0bc1974b");
        if (patchProxyResult.isSupported) {
            return;
        }
        --this.curLeftResolveTimes;
        HMSAgentLog.d("start thread to connect");
        ThreadUtil.INST.excute(new Runnable(){
            public static ChangeQuickRedirect changeQuickRedirect;

            @Override
            public void run() {
                PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"09359c67678d879f0804e7f799e9d55c");
                if (patchProxyResult.isSupported) {
                    return;
                }
                HuaweiApiClient huaweiApiClient = ApiClientMgr.this.getApiClient();
                if (huaweiApiClient != null) {
                    HMSAgentLog.d("connect");
                    Activity activity = ActivityMgr.INST.getLastActivity();
                    ApiClientMgr.this.timeoutHandler.sendEmptyMessageDelayed(3, 30000L);
                    huaweiApiClient.connect(activity);
                } else {
                    HMSAgentLog.d("client is generate error");
                    ApiClientMgr.access$300(ApiClientMgr.this, -1002);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectEnd(int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"378331379bdc2a7a506a3b187bf058f0");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("connect end:" + n2);
        Object object = CALLBACK_LOCK;
        synchronized (object) {
            for (IClientConnectCallback iClientConnectCallback : this.connCallbacks) {
                this.aSysnCallback(n2, iClientConnectCallback);
            }
            this.connCallbacks.clear();
            this.allowResolveConnectError = false;
        }
        object = STATIC_CALLBACK_LOCK;
        synchronized (object) {
            for (IClientConnectCallback iClientConnectCallback : this.staticCallbacks) {
                this.aSysnCallback(n2, iClientConnectCallback);
            }
            this.staticCallbacks.clear();
        }
    }

    private void aSysnCallback(final int n2, final IClientConnectCallback iClientConnectCallback) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), iClientConnectCallback}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"7a23f2d6bbf78c55493b73467fa2e327");
        if (patchProxyResult.isSupported) {
            return;
        }
        ThreadUtil.INST.excute(new Runnable(){
            public static ChangeQuickRedirect changeQuickRedirect;

            @Override
            public void run() {
                PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"e92a30654670f8ebe994b222c8149bb8");
                if (patchProxyResult.isSupported) {
                    return;
                }
                HuaweiApiClient huaweiApiClient = ApiClientMgr.this.getApiClient();
                HMSAgentLog.d("callback connect: rst=" + n2 + " apiClient=" + huaweiApiClient);
                iClientConnectCallback.onConnect(n2, huaweiApiClient);
            }
        });
    }

    @Override
    public void onActivityResume(Activity activity) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{activity}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"f2777e31a82cc2ebfcad6fd83516e633");
        if (patchProxyResult.isSupported) {
            return;
        }
        HuaweiApiClient huaweiApiClient = this.getApiClient();
        if (huaweiApiClient != null) {
            HMSAgentLog.d("tell hmssdk: onResume");
            huaweiApiClient.onResume(activity);
        }
        HMSAgentLog.d("is resolving:" + this.isResolving);
        if (this.isResolving && !PACKAGE_NAME_HIAPP.equals(this.curAppPackageName)) {
            if (activity instanceof BridgeActivity) {
                this.resolveActivity = (BridgeActivity)activity;
                this.hasOverActivity = false;
                HMSAgentLog.d("received bridgeActivity:" + StrUtils.objDesc((Object)this.resolveActivity));
            } else if (this.resolveActivity != null && !this.resolveActivity.isFinishing()) {
                this.hasOverActivity = true;
                HMSAgentLog.d("received other Activity:" + StrUtils.objDesc((Object)this.resolveActivity));
            }
            this.timeoutHandler.removeMessages(5);
            this.timeoutHandler.sendEmptyMessageDelayed(5, 3000L);
        }
    }

    @Override
    public void onActivityPause(Activity activity) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{activity}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"f94a377996d2c1807c446776cc06ef9c");
        if (patchProxyResult.isSupported) {
            return;
        }
        HuaweiApiClient huaweiApiClient = this.getApiClient();
        if (huaweiApiClient != null) {
            huaweiApiClient.onPause(activity);
        }
    }

    @Override
    public void onActivityDestroyed(Activity activity, Activity activity2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{activity, activity2}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"9be509b0125885db242c4c96e05d7080");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (activity2 == null) {
            this.resetApiClient();
        }
    }

    void onResolveErrorRst(int n2) {
        HuaweiApiClient huaweiApiClient;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"d24dd2abd9c7c3b2717fb3041b38e520");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("result=" + n2);
        this.isResolving = false;
        this.resolveActivity = null;
        this.hasOverActivity = false;
        if (n2 == 0 && (huaweiApiClient = this.getApiClient()) != null && !huaweiApiClient.isConnecting() && !huaweiApiClient.isConnected() && this.curLeftResolveTimes > 0) {
            this.startConnect();
            return;
        }
        this.onConnectEnd(n2);
    }

    void onActivityLunched() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"06974bc674b024646d69cbeeca4a531f");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("resolve onActivityLunched");
        this.timeoutHandler.removeMessages(4);
        this.isResolving = true;
    }

    @Override
    public void onConnected() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"d72bd77cac6bf647d4658582791e229b");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("connect success");
        this.timeoutHandler.removeMessages(3);
        this.onConnectEnd(0);
    }

    @Override
    public void onConnectionSuspended(int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"3b1ca64276c6e58a9a02b47ad811a3e0");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("connect suspended");
        this.connect(new EmptyConnectCallback("onConnectionSuspended try end:"), true);
    }

    @Override
    public void onConnectionFailed(ConnectionResult connectionResult) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{connectionResult}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"ce624e0d89544c72dcb0f38e60887585");
        if (patchProxyResult.isSupported) {
            return;
        }
        this.timeoutHandler.removeMessages(3);
        if (connectionResult == null) {
            HMSAgentLog.e("result is null");
            this.onConnectEnd(-1002);
            return;
        }
        int n2 = connectionResult.getErrorCode();
        HMSAgentLog.d("errCode=" + n2 + " allowResolve=" + this.allowResolveConnectError);
        if (HuaweiApiAvailability.getInstance().isUserResolvableError(n2) && this.allowResolveConnectError) {
            Activity activity = ActivityMgr.INST.getLastActivity();
            if (activity != null) {
                try {
                    this.timeoutHandler.sendEmptyMessageDelayed(4, 3000L);
                    Intent intent = new Intent((Context)activity, HMSAgentActivity.class);
                    intent.putExtra("HMSConnectionErrorCode", n2);
                    intent.putExtra("should_be_fullscreen", UIUtils.isActivityFullscreen(activity));
                    activity.startActivity(intent);
                    return;
                }
                catch (Exception exception) {
                    HMSAgentLog.e("start HMSAgentActivity exception:" + exception.getMessage());
                    this.timeoutHandler.removeMessages(4);
                    this.onConnectEnd(-1004);
                    return;
                }
            }
            HMSAgentLog.d("no activity");
            this.onConnectEnd(-1001);
            return;
        }
        this.onConnectEnd(n2);
    }

    private static void disConnectClientDelay(final HuaweiApiClient huaweiApiClient, int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{huaweiApiClient, new Integer(n2)}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"647ed2a177cbd819c4bf2a33d30a2d8d");
        if (patchProxyResult.isSupported) {
            return;
        }
        new Handler().postDelayed(new Runnable(){
            public static ChangeQuickRedirect changeQuickRedirect;

            @Override
            public void run() {
                PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"9adec4cc6fb31149468bdbecf58ad097");
                if (patchProxyResult.isSupported) {
                    return;
                }
                huaweiApiClient.disconnect();
            }
        }, (long)n2);
    }

    static /* synthetic */ HuaweiApiClient access$200(ApiClientMgr apiClientMgr) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{apiClientMgr}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"766b727ecb211a15834b87c9591935d5");
        if (patchProxyResult.isSupported) {
            return (HuaweiApiClient)patchProxyResult.result;
        }
        return apiClientMgr.resetApiClient();
    }

    static /* synthetic */ void access$300(ApiClientMgr apiClientMgr, int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{apiClientMgr, new Integer(n2)}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"33857036a641d49b0fd5f23e1f6037ee");
        if (patchProxyResult.isSupported) {
            return;
        }
        apiClientMgr.onConnectEnd(n2);
    }

    static {
        INST = new ApiClientMgr();
        CALLBACK_LOCK = new Object();
        STATIC_CALLBACK_LOCK = new Object();
        APICLIENT_LOCK = new Object();
    }
}

