/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.android.hms.agent.common;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.huawei.android.hms.agent.common.HMSAgentLog;
import com.huawei.android.hms.agent.common.IActivityDestroyedCallback;
import com.huawei.android.hms.agent.common.IActivityPauseCallback;
import com.huawei.android.hms.agent.common.IActivityResumeCallback;
import com.huawei.android.hms.agent.common.StrUtils;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;
import java.util.ArrayList;
import java.util.List;

public final class ActivityMgr
implements Application.ActivityLifecycleCallbacks {
    public static ChangeQuickRedirect changeQuickRedirect;
    public static final ActivityMgr INST;
    private static final Object LOCK_LASTACTIVITIES;
    private Application application;
    private List<Activity> curActivities = new ArrayList<Activity>();
    private List<IActivityResumeCallback> resumeCallbacks = new ArrayList<IActivityResumeCallback>();
    private List<IActivityPauseCallback> pauseCallbacks = new ArrayList<IActivityPauseCallback>();
    private List<IActivityDestroyedCallback> destroyedCallbacks = new ArrayList<IActivityDestroyedCallback>();

    private ActivityMgr() {
    }

    public void init(Application application, Activity activity) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{application, activity}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"e9be1936cfd4e46ce6ddf3260c61dd89");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("init");
        if (this.application != null) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
        this.application = application;
        this.setCurActivity(activity);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public void release() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"86fab414fdd372bbd1831711cc7c23ba");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("release");
        if (this.application != null) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
        this.clearCurActivities();
        this.clearActivitResumeCallbacks();
        this.clearActivitPauseCallbacks();
        this.application = null;
    }

    public void registerActivitResumeEvent(IActivityResumeCallback iActivityResumeCallback) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{iActivityResumeCallback}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"531296fd3ee75f794cc951427674fcf3");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("registerOnResume:" + StrUtils.objDesc(iActivityResumeCallback));
        this.resumeCallbacks.add(iActivityResumeCallback);
    }

    public void unRegisterActivitResumeEvent(IActivityResumeCallback iActivityResumeCallback) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{iActivityResumeCallback}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"48f26f83c62bdc481b9a57a1e62c9e3b");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("unRegisterOnResume:" + StrUtils.objDesc(iActivityResumeCallback));
        this.resumeCallbacks.remove(iActivityResumeCallback);
    }

    public void registerActivitPauseEvent(IActivityPauseCallback iActivityPauseCallback) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{iActivityPauseCallback}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"3a5478f48327b11598a81fc974ef4ba9");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("registerOnPause:" + StrUtils.objDesc(iActivityPauseCallback));
        this.pauseCallbacks.add(iActivityPauseCallback);
    }

    public void unRegisterActivitPauseEvent(IActivityPauseCallback iActivityPauseCallback) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{iActivityPauseCallback}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"c2008bdd4be043a5ef59d02dbe910f3b");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("unRegisterOnPause:" + StrUtils.objDesc(iActivityPauseCallback));
        this.pauseCallbacks.remove(iActivityPauseCallback);
    }

    public void registerActivitDestroyedEvent(IActivityDestroyedCallback iActivityDestroyedCallback) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{iActivityDestroyedCallback}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"d93f6adfc49dac1877fd035d33123afc");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("registerOnDestroyed:" + StrUtils.objDesc(iActivityDestroyedCallback));
        this.destroyedCallbacks.add(iActivityDestroyedCallback);
    }

    public void unRegisterActivitDestroyedEvent(IActivityDestroyedCallback iActivityDestroyedCallback) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{iActivityDestroyedCallback}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"568aaf053a8f0c1274ad50d598c3863f");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("unRegisterOnDestroyed:" + StrUtils.objDesc(iActivityDestroyedCallback));
        this.destroyedCallbacks.remove(iActivityDestroyedCallback);
    }

    public void clearActivitResumeCallbacks() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"b8e56c9967acf8568a1e398e2042d915");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("clearOnResumeCallback");
        this.resumeCallbacks.clear();
    }

    public void clearActivitPauseCallbacks() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"3e2c3c0d3d2bda8438d4cb1117643162");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("clearOnPauseCallback");
        this.pauseCallbacks.clear();
    }

    public Activity getLastActivity() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"88237e0c462c693db19a63b59debf0ec");
        if (patchProxyResult.isSupported) {
            return (Activity)patchProxyResult.result;
        }
        return this.getLastActivityInner();
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{activity, bundle}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"548739decaf1068bd028c98700ed9382");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("onCreated:" + StrUtils.objDesc(activity));
        this.setCurActivity(activity);
    }

    public void onActivityStarted(Activity activity) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{activity}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"04f8ab0a65dd43f3c4ac3297fdf8e08d");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("onStarted:" + StrUtils.objDesc(activity));
        this.setCurActivity(activity);
    }

    public void onActivityResumed(Activity activity) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{activity}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"0a1505a501baa9b41dbe7bc09dc779b9");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("onResumed:" + StrUtils.objDesc(activity));
        this.setCurActivity(activity);
        ArrayList<IActivityResumeCallback> arrayList = new ArrayList<IActivityResumeCallback>(this.resumeCallbacks);
        for (IActivityResumeCallback iActivityResumeCallback : arrayList) {
            iActivityResumeCallback.onActivityResume(activity);
        }
    }

    public void onActivityPaused(Activity activity) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{activity}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"7c97cfb79e3ddbc4bf73f3ac24d4ed77");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("onPaused:" + StrUtils.objDesc(activity));
        ArrayList<IActivityPauseCallback> arrayList = new ArrayList<IActivityPauseCallback>(this.pauseCallbacks);
        for (IActivityPauseCallback iActivityPauseCallback : arrayList) {
            iActivityPauseCallback.onActivityPause(activity);
        }
    }

    public void onActivityStopped(Activity activity) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{activity}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"5e0bf5c43174ac2b5c14337cb4add633");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("onStopped:" + StrUtils.objDesc(activity));
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{activity}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"13f6df66fc163fc15052312f541285bb");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.d("onDestroyed:" + StrUtils.objDesc(activity));
        this.removeActivity(activity);
        ArrayList<IActivityDestroyedCallback> arrayList = new ArrayList<IActivityDestroyedCallback>(this.destroyedCallbacks);
        for (IActivityDestroyedCallback iActivityDestroyedCallback : arrayList) {
            iActivityDestroyedCallback.onActivityDestroyed(activity, this.getLastActivityInner());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeActivity(Activity activity) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{activity}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"f12832325b78824f5c2be3f95deea28d");
        if (patchProxyResult.isSupported) {
            return;
        }
        Object object = LOCK_LASTACTIVITIES;
        synchronized (object) {
            this.curActivities.remove(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurActivity(Activity activity) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{activity}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"c4cf52121cf7d5b6373ff4b15e7f98fc");
        if (patchProxyResult.isSupported) {
            return;
        }
        Object object = LOCK_LASTACTIVITIES;
        synchronized (object) {
            int n2 = this.curActivities.indexOf(activity);
            if (n2 == -1) {
                this.curActivities.add(activity);
            } else if (n2 < this.curActivities.size() - 1) {
                this.curActivities.remove(activity);
                this.curActivities.add(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Activity getLastActivityInner() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"816734bb855fda03cd93ed6cb2019f34");
        if (patchProxyResult.isSupported) {
            return (Activity)patchProxyResult.result;
        }
        Object object = LOCK_LASTACTIVITIES;
        synchronized (object) {
            if (this.curActivities.size() > 0) {
                return this.curActivities.get(this.curActivities.size() - 1);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCurActivities() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"7a4d02a155fb8359c74e00439ec8120f");
        if (patchProxyResult.isSupported) {
            return;
        }
        Object object = LOCK_LASTACTIVITIES;
        synchronized (object) {
            this.curActivities.clear();
        }
    }

    static {
        INST = new ActivityMgr();
        LOCK_LASTACTIVITIES = new Object();
    }
}

