/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.android.hms.agent;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;
import com.huawei.android.hms.agent.common.ActivityMgr;
import com.huawei.android.hms.agent.common.ApiClientMgr;
import com.huawei.android.hms.agent.common.CheckUpdateApi;
import com.huawei.android.hms.agent.common.HMSAgentLog;
import com.huawei.android.hms.agent.common.IClientConnectCallback;
import com.huawei.android.hms.agent.common.INoProguard;
import com.huawei.android.hms.agent.common.handler.CheckUpdateHandler;
import com.huawei.android.hms.agent.common.handler.ConnectHandler;
import com.huawei.android.hms.agent.push.DeleteTokenApi;
import com.huawei.android.hms.agent.push.EnableReceiveNormalMsgApi;
import com.huawei.android.hms.agent.push.EnableReceiveNotifyMsgApi;
import com.huawei.android.hms.agent.push.GetPushStateApi;
import com.huawei.android.hms.agent.push.GetTokenApi;
import com.huawei.android.hms.agent.push.QueryAgreementApi;
import com.huawei.android.hms.agent.push.handler.DeleteTokenHandler;
import com.huawei.android.hms.agent.push.handler.EnableReceiveNormalMsgHandler;
import com.huawei.android.hms.agent.push.handler.EnableReceiveNotifyMsgHandler;
import com.huawei.android.hms.agent.push.handler.GetPushStateHandler;
import com.huawei.android.hms.agent.push.handler.GetTokenHandler;
import com.huawei.android.hms.agent.push.handler.QueryAgreementHandler;
import com.huawei.hms.api.HuaweiApiClient;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;

public final class HMSAgent
implements INoProguard {
    public static ChangeQuickRedirect changeQuickRedirect;
    private static final String VER_020503001 = "020503001";
    private static final String VER_020600001 = "020600001";
    private static final String VER_020600200 = "020600200";
    private static final String VER_020601002 = "020601002";
    private static final String VER_020601302 = "020601302";
    private static final String VER_020603306 = "020603306";
    public static final String CURVER = "020603306";

    private HMSAgent() {
    }

    private static boolean checkSDKVersion(Context context) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{context}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"d65f240d531ccb3688a87c34cefe29ce");
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        long l2 = 20603L;
        long l3 = Long.parseLong("020603306") / 1000L;
        if (l2 != l3) {
            String string2 = "error: HMSAgent major version code (" + l3 + ") does not match HMSSDK major version code (" + l2 + ")";
            HMSAgentLog.e(string2);
            Toast.makeText((Context)context, (CharSequence)string2, (int)1).show();
            return false;
        }
        return true;
    }

    public static boolean init(Activity activity) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{activity}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"9138f212b74663ea82a35129c699f425");
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        return HMSAgent.init(null, activity);
    }

    public static boolean init(Application application) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{application}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"7a629e987d995841600bce6396428090");
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        return HMSAgent.init(application, null);
    }

    public static boolean init(Application application, Activity activity) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{application, activity}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"6903ab3a1ea798af086bf38843074797");
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        Application application2 = application;
        Activity activity2 = activity;
        if (application2 == null && activity2 == null) {
            HMSAgentLog.e("the param of method HMSAgent.init can not be null !!!");
            return false;
        }
        if (application2 == null) {
            application2 = activity2.getApplication();
        }
        if (application2 == null) {
            HMSAgentLog.e("the param of method HMSAgent.init app can not be null !!!");
            return false;
        }
        if (activity2 != null && activity2.isFinishing()) {
            activity2 = null;
        }
        if (!HMSAgent.checkSDKVersion((Context)application2)) {
            return false;
        }
        HMSAgentLog.i("init HMSAgent 020603306 with hmssdkver 20603306");
        ActivityMgr.INST.init(application2, activity2);
        ApiClientMgr.INST.init(application2);
        return true;
    }

    public static void destroy() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"a059e7d37f7c45eb6860bb99aceb6900");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.i("destroy HMSAgent");
        ActivityMgr.INST.release();
        ApiClientMgr.INST.release();
    }

    public static void connect(Activity activity, final ConnectHandler connectHandler) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{activity, connectHandler}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"f3dff6b6c0e6e685f0e93713a25dfb17");
        if (patchProxyResult.isSupported) {
            return;
        }
        HMSAgentLog.i("start connect");
        ApiClientMgr.INST.connect(new IClientConnectCallback(){
            public static ChangeQuickRedirect changeQuickRedirect;

            @Override
            public void onConnect(final int n2, HuaweiApiClient huaweiApiClient) {
                PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Integer(n2), huaweiApiClient}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"a2128f7fba5d7ce9123b828bde0eb635");
                if (patchProxyResult.isSupported) {
                    return;
                }
                if (connectHandler != null) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){
                        public static ChangeQuickRedirect changeQuickRedirect;

                        @Override
                        public void run() {
                            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"234a3eb60195c12d48f787f9d57a7331");
                            if (patchProxyResult.isSupported) {
                                return;
                            }
                            connectHandler.onConnect(n2);
                        }
                    });
                }
            }
        }, true);
    }

    public static void checkUpdate(Activity activity, CheckUpdateHandler checkUpdateHandler) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{activity, checkUpdateHandler}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"4ec3eb9642935ac358de9d12e3993e08");
        if (patchProxyResult.isSupported) {
            return;
        }
        new CheckUpdateApi().checkUpdate(activity, checkUpdateHandler);
    }

    public static final class Push {
        public static ChangeQuickRedirect changeQuickRedirect;

        public static void getToken(GetTokenHandler getTokenHandler) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{getTokenHandler}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"d68b289ca0eb26dd68ff2d5d264f0dfa");
            if (patchProxyResult.isSupported) {
                return;
            }
            new GetTokenApi().getToken(getTokenHandler);
        }

        public static void deleteToken(String string2, DeleteTokenHandler deleteTokenHandler) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string2, deleteTokenHandler}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"acee7841090c2154967c601ff55bab25");
            if (patchProxyResult.isSupported) {
                return;
            }
            new DeleteTokenApi().deleteToken(string2, deleteTokenHandler);
        }

        public static void getPushState(GetPushStateHandler getPushStateHandler) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{getPushStateHandler}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"0c20ed4259e44e9fb08982511fe89b0d");
            if (patchProxyResult.isSupported) {
                return;
            }
            new GetPushStateApi().getPushState(getPushStateHandler);
        }

        public static void enableReceiveNotifyMsg(boolean bl2, EnableReceiveNotifyMsgHandler enableReceiveNotifyMsgHandler) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Byte((byte)(bl2 ? 1 : 0)), enableReceiveNotifyMsgHandler}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"1f668cacb73d8925fafbf696513b3650");
            if (patchProxyResult.isSupported) {
                return;
            }
            new EnableReceiveNotifyMsgApi().enableReceiveNotifyMsg(bl2, enableReceiveNotifyMsgHandler);
        }

        public static void enableReceiveNormalMsg(boolean bl2, EnableReceiveNormalMsgHandler enableReceiveNormalMsgHandler) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Byte((byte)(bl2 ? 1 : 0)), enableReceiveNormalMsgHandler}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"7f992f0c2bcb03abba29f1bdabaf8034");
            if (patchProxyResult.isSupported) {
                return;
            }
            new EnableReceiveNormalMsgApi().enableReceiveNormalMsg(bl2, enableReceiveNormalMsgHandler);
        }

        public static void queryAgreement(QueryAgreementHandler queryAgreementHandler) {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{queryAgreementHandler}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"470891ccf3b800a13806a770e9465f9b");
            if (patchProxyResult.isSupported) {
                return;
            }
            new QueryAgreementApi().queryAgreement(queryAgreementHandler);
        }
    }

    public static final class AgentResultCode {
        public static final int HMSAGENT_SUCCESS = 0;
        public static final int HMSAGENT_NO_INIT = -1000;
        public static final int NO_ACTIVITY_FOR_USE = -1001;
        public static final int RESULT_IS_NULL = -1002;
        public static final int STATUS_IS_NULL = -1003;
        public static final int START_ACTIVITY_ERROR = -1004;
        public static final int ON_ACTIVITY_RESULT_ERROR = -1005;
        public static final int REQUEST_REPEATED = -1006;
        public static final int APICLIENT_TIMEOUT = -1007;
        public static final int CALL_EXCEPTION = -1008;
        public static final int EMPTY_PARAM = -1009;
    }
}

