/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.util;

import android.text.TextUtils;
import anet.channel.strategy.StrategyCenter;
import anet.channel.strategy.utils.c;
import anet.channel.util.StringUtils;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;
import java.net.MalformedURLException;
import java.net.URL;

public class HttpUrl {
    public static ChangeQuickRedirect changeQuickRedirect;
    private String scheme;
    private String host;
    private String path;
    private int port;
    private String url;
    private String simpleUrl;
    private volatile boolean isSchemeLocked = false;

    private HttpUrl() {
    }

    public HttpUrl(HttpUrl httpUrl) {
        this.scheme = httpUrl.scheme;
        this.host = httpUrl.host;
        this.path = httpUrl.path;
        this.url = httpUrl.url;
        this.simpleUrl = httpUrl.simpleUrl;
        this.isSchemeLocked = httpUrl.isSchemeLocked;
    }

    public static HttpUrl parse(String string) {
        char c2;
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"48164f66fd32381223429f3bd9d2293d");
        if (patchProxyResult.isSupported) {
            return (HttpUrl)patchProxyResult.result;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        string = string.trim();
        HttpUrl httpUrl = new HttpUrl();
        httpUrl.url = string;
        int n2 = 0;
        if (string.startsWith("//")) {
            httpUrl.scheme = null;
        } else if (string.regionMatches(true, n2, "https:", 0, 6)) {
            httpUrl.scheme = "https";
            n2 += 6;
        } else if (string.regionMatches(true, n2, "http:", 0, 5)) {
            httpUrl.scheme = "http";
            n2 += 5;
        } else {
            return null;
        }
        int n3 = string.length();
        int n4 = n2 += 2;
        boolean bl2 = false;
        while (n2 < n3) {
            c2 = string.charAt(n2);
            if (c2 == '[') {
                bl2 = true;
            } else if (c2 == ']') {
                bl2 = false;
            } else if (c2 == '/' || c2 == '?' || c2 == '#' || c2 == ':' && !bl2) {
                httpUrl.host = string.substring(n4, n2);
                break;
            }
            ++n2;
        }
        if (n2 == n3) {
            httpUrl.host = string.substring(n4);
        }
        int n5 = 0;
        int n6 = n3;
        while (n2 < n3) {
            c2 = string.charAt(n2);
            if (c2 == ':' && n5 == 0) {
                n5 = n2 + 1;
            } else if (c2 == '/' || c2 == '#' || c2 == '?') {
                n6 = n2;
                break;
            }
            ++n2;
        }
        if (n5 != 0) {
            String string2 = string.substring(n5, n6);
            try {
                httpUrl.port = Integer.parseInt(string2);
                if (httpUrl.port <= 0 || httpUrl.port > 65535) {
                    return null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        int n7 = 0;
        int n8 = n3;
        while (n2 < n3) {
            c2 = string.charAt(n2);
            if (c2 == '/' && n7 == 0) {
                n7 = n2;
            } else if (c2 == '?' || c2 == '#') {
                if (n7 == 0) break;
                n8 = n2;
                break;
            }
            ++n2;
        }
        httpUrl.path = n7 != 0 ? string.substring(n7, n8) : null;
        if (httpUrl.scheme == null) {
            httpUrl.scheme = httpUrl.port == 80 ? "http" : (httpUrl.port == 443 ? "https" : StrategyCenter.getInstance().getSchemeByHost(httpUrl.host, null));
        }
        StringBuilder stringBuilder = new StringBuilder(httpUrl.scheme).append("://").append(httpUrl.host);
        if (httpUrl.containsNonDefaultPort()) {
            stringBuilder.append(":").append(httpUrl.port);
        }
        if (httpUrl.path != null) {
            stringBuilder.append(httpUrl.path);
        } else if (n2 != n3) {
            stringBuilder.append("/");
        }
        httpUrl.simpleUrl = stringBuilder.toString();
        stringBuilder.append(string.substring(n2));
        httpUrl.url = stringBuilder.toString();
        return httpUrl;
    }

    public String scheme() {
        return this.scheme;
    }

    public String host() {
        return this.host;
    }

    public String path() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public String urlString() {
        return this.url;
    }

    public String simpleUrlString() {
        return this.simpleUrl;
    }

    public URL toURL() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"eb651305c474ecd2c0aab7a7f85a2d22");
        if (patchProxyResult.isSupported) {
            return (URL)patchProxyResult.result;
        }
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public boolean containsNonDefaultPort() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"580ad7979406a2ff72a720073eeb263a");
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        return this.port != 0 && ("http".equals(this.scheme) && this.port != 80 || "https".equals(this.scheme) && this.port != 443);
    }

    public void downgradeSchemeAndLock() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"99a0f71caaa77e87825a1a5f90349f93");
        if (patchProxyResult.isSupported) {
            return;
        }
        this.isSchemeLocked = true;
        if (!"http".equals(this.scheme)) {
            this.scheme = "http";
            this.url = StringUtils.concatString(this.scheme, ":", this.url.substring(this.url.indexOf("//")));
        }
    }

    public boolean isSchemeLocked() {
        return this.isSchemeLocked;
    }

    public void lockScheme() {
        this.isSchemeLocked = true;
    }

    public void setScheme(String string) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"31d3b3778db8dafb541fb2417633aa20");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (!this.isSchemeLocked && !string.equalsIgnoreCase(this.scheme)) {
            this.scheme = string;
            this.url = StringUtils.concatString(string, ":", this.url.substring(this.url.indexOf("//")));
            this.simpleUrl = StringUtils.concatString(string, ":", this.simpleUrl.substring(this.url.indexOf("//")));
        }
    }

    public void replaceIpAndPort(String string, int n2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{string, new Integer(n2)}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"217063d1f9c0602defb5f299d35946f5");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (string != null) {
            int n3;
            for (n3 = this.url.indexOf("//") + 2; n3 < this.url.length() && this.url.charAt(n3) != '/'; ++n3) {
            }
            boolean bl2 = c.b(string);
            StringBuilder stringBuilder = new StringBuilder(this.url.length() + string.length());
            stringBuilder.append(this.scheme).append("://");
            if (bl2) {
                stringBuilder.append('[');
            }
            stringBuilder.append(string);
            if (bl2) {
                stringBuilder.append(']');
            }
            if (n2 != 0) {
                stringBuilder.append(':').append(n2);
            } else if (this.port != 0) {
                stringBuilder.append(':').append(this.port);
            }
            stringBuilder.append(this.url.substring(n3));
            this.url = stringBuilder.toString();
        }
    }

    public String toString() {
        return this.url;
    }
}

