/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.status;

import android.content.Context;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Pair;
import anet.channel.status.a;
import anet.channel.status.b;
import anet.channel.thread.ThreadPoolExecutorFactory;
import anet.channel.util.ALog;
import anet.channel.util.h;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;
import java.util.concurrent.CopyOnWriteArraySet;

public class NetworkStatusHelper {
    public static ChangeQuickRedirect changeQuickRedirect;
    private static final String TAG = "awcn.NetworkStatusHelper";
    static CopyOnWriteArraySet<INetworkStatusChangeListener> listeners;

    public static synchronized void startListener(Context context) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{context}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"15eeb4437d81372d8c5f805f7053d958");
        if (patchProxyResult.isSupported) {
            return;
        }
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        b.a = context;
        b.a();
        b.c();
    }

    public void stopListener(Context context) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{context}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"9f61e90e8ed042c447ea0c2927ca5b4d");
        if (patchProxyResult.isSupported) {
            return;
        }
        b.b();
    }

    public static void addStatusChangeListener(INetworkStatusChangeListener iNetworkStatusChangeListener) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{iNetworkStatusChangeListener}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"850da5c0881f30bb67aad0bc873876d0");
        if (patchProxyResult.isSupported) {
            return;
        }
        listeners.add(iNetworkStatusChangeListener);
    }

    public static void removeStatusChangeListener(INetworkStatusChangeListener iNetworkStatusChangeListener) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{iNetworkStatusChangeListener}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"2f765c675d67807f6631edbdd5c1a960");
        if (patchProxyResult.isSupported) {
            return;
        }
        listeners.remove(iNetworkStatusChangeListener);
    }

    static void notifyStatusChanged(NetworkStatus networkStatus) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{networkStatus}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"8c3b4230928328d101e03cc554a831d2");
        if (patchProxyResult.isSupported) {
            return;
        }
        ThreadPoolExecutorFactory.submitScheduledTask(new a(networkStatus));
    }

    public static NetworkStatus getStatus() {
        return b.c;
    }

    public static String getNetworkSubType() {
        return b.d;
    }

    public static String getApn() {
        return b.e;
    }

    public static String getCarrier() {
        return b.h;
    }

    public static String getSimOp() {
        return b.i;
    }

    public static boolean isRoaming() {
        return b.k;
    }

    public static String getWifiBSSID() {
        return b.g;
    }

    public static String getWifiSSID() {
        return b.f;
    }

    public static String getDnsServerAddress() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"6c57d4e9dd48f2e3c1c21aa574839d37");
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        if (!b.l.isEmpty()) {
            return b.l.get(0).getHostAddress();
        }
        return b.f();
    }

    public static boolean isConnected() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"2d011ebbf6b0bd1a03f49a9db77f0ccd");
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        if (Build.VERSION.SDK_INT >= 24 ? b.b : b.c != NetworkStatus.NO) {
            return true;
        }
        try {
            NetworkInfo networkInfo = b.e();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isProxy() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"1f913ef4017008deebb230f30f69b715");
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        NetworkStatus networkStatus = b.c;
        String string = b.e;
        return networkStatus == NetworkStatus.WIFI && NetworkStatusHelper.getWifiProxy() != null || networkStatus.isMobile() && (string.contains("wap") || h.a() != null);
    }

    public static String getProxyType() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"f7ca5c7461943e80d791bdf5afceab94");
        if (patchProxyResult.isSupported) {
            return (String)patchProxyResult.result;
        }
        NetworkStatus networkStatus = b.c;
        if (networkStatus == NetworkStatus.WIFI && NetworkStatusHelper.getWifiProxy() != null) {
            return "proxy";
        }
        if (networkStatus.isMobile() && b.e.contains("wap")) {
            return "wap";
        }
        if (networkStatus.isMobile() && h.a() != null) {
            return "auth";
        }
        return "";
    }

    public static Pair<String, Integer> getWifiProxy() {
        if (b.c != NetworkStatus.WIFI) {
            return null;
        }
        return b.j;
    }

    public static void printNetworkDetail() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"68c83caed288e4373a80d22fcc0bf551");
        if (patchProxyResult.isSupported) {
            return;
        }
        try {
            NetworkStatus networkStatus = NetworkStatusHelper.getStatus();
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("\nNetwork detail*******************************\n");
            stringBuilder.append("Status: ").append(networkStatus.getType()).append('\n');
            stringBuilder.append("Subtype: ").append(NetworkStatusHelper.getNetworkSubType()).append('\n');
            if (networkStatus != NetworkStatus.NO) {
                if (networkStatus.isMobile()) {
                    stringBuilder.append("Apn: ").append(NetworkStatusHelper.getApn()).append('\n');
                    stringBuilder.append("Carrier: ").append(NetworkStatusHelper.getCarrier()).append('\n');
                } else {
                    stringBuilder.append("BSSID: ").append(NetworkStatusHelper.getWifiBSSID()).append('\n');
                    stringBuilder.append("SSID: ").append(NetworkStatusHelper.getWifiSSID()).append('\n');
                }
            }
            if (NetworkStatusHelper.isProxy()) {
                stringBuilder.append("Proxy: ").append(NetworkStatusHelper.getProxyType()).append('\n');
                Pair<String, Integer> pair = NetworkStatusHelper.getWifiProxy();
                if (pair != null) {
                    stringBuilder.append("ProxyHost: ").append((String)pair.first).append('\n');
                    stringBuilder.append("ProxyPort: ").append(pair.second).append('\n');
                }
            }
            stringBuilder.append("*********************************************");
            ALog.i(TAG, stringBuilder.toString(), null, new Object[0]);
        }
        catch (Exception exception) {}
    }

    static {
        listeners = new CopyOnWriteArraySet();
    }

    public static interface INetworkStatusChangeListener {
        public void onNetworkStatusChanged(NetworkStatus var1);
    }

    public static enum NetworkStatus {
        NONE,
        NO,
        G2,
        G3,
        G4,
        WIFI;

        public static ChangeQuickRedirect changeQuickRedirect;

        public boolean isMobile() {
            return this == G2 || this == G3 || this == G4;
        }

        public boolean isWifi() {
            return this == WIFI;
        }

        public String getType() {
            PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)((Object)this), (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"e38e9c75db93e3adb3c8b3ad172fef0a");
            if (patchProxyResult.isSupported) {
                return (String)patchProxyResult.result;
            }
            if (this == G2) {
                return "2G";
            }
            if (this == G3) {
                return "3G";
            }
            if (this == G4) {
                return "4G";
            }
            return this.toString();
        }
    }
}

