/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.entity;

import android.text.TextUtils;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.entity.ENV;
import anet.channel.entity.c;
import anet.channel.strategy.ConnProtocol;
import com.meituan.robust.ChangeQuickRedirect;
import com.meituan.robust.PatchProxy;
import com.meituan.robust.PatchProxyResult;
import java.util.HashMap;
import java.util.Map;

public class ConnType {
    public static ChangeQuickRedirect changeQuickRedirect;
    public static final String SPDY = "spdy";
    public static final String HTTP2 = "http2";
    public static final String H2S = "h2s";
    public static final String QUIC = "quic";
    public static final String QUIC_PLAIN = "quicplain";
    public static final String RTT_0 = "0rtt";
    public static final String RTT_1 = "1rtt";
    public static final String PK_ACS = "acs";
    public static final String PK_CDN = "cdn";
    public static final String PK_OPEN = "open";
    public static final String PK_AUTO = "auto";
    public static ConnType HTTP;
    public static ConnType HTTPS;
    private static Map<ConnProtocol, ConnType> connTypeMap;
    private int spdyProtocol;
    private String publicKey;
    private String name = "";

    private ConnType(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnType valueOf(ConnProtocol connProtocol) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{connProtocol}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"f7fe25eed29ab55a5e4a028f46594698");
        if (patchProxyResult.isSupported) {
            return (ConnType)patchProxyResult.result;
        }
        if (connProtocol == null) {
            return null;
        }
        if ("http".equalsIgnoreCase(connProtocol.protocol)) {
            return HTTP;
        }
        if ("https".equalsIgnoreCase(connProtocol.protocol)) {
            return HTTPS;
        }
        Map<ConnProtocol, ConnType> map = connTypeMap;
        synchronized (map) {
            if (connTypeMap.containsKey(connProtocol)) {
                return connTypeMap.get(connProtocol);
            }
            ConnType connType = new ConnType(connProtocol.toString());
            connType.publicKey = connProtocol.publicKey;
            if (HTTP2.equalsIgnoreCase(connProtocol.protocol)) {
                connType.spdyProtocol |= 8;
            } else if (SPDY.equalsIgnoreCase(connProtocol.protocol)) {
                connType.spdyProtocol |= 2;
            } else if (H2S.equals(connProtocol.protocol)) {
                connType.spdyProtocol = 40;
            } else if (QUIC.equalsIgnoreCase(connProtocol.protocol)) {
                connType.spdyProtocol = 12;
            } else if (QUIC_PLAIN.equalsIgnoreCase(connProtocol.protocol)) {
                connType.spdyProtocol = 32780;
            }
            if (connType.spdyProtocol == 0) {
                return null;
            }
            if (!TextUtils.isEmpty((CharSequence)connProtocol.publicKey)) {
                connType.spdyProtocol |= 0x80;
                if (RTT_1.equalsIgnoreCase(connProtocol.rtt)) {
                    connType.spdyProtocol |= 0x2000;
                } else if (RTT_0.equalsIgnoreCase(connProtocol.rtt)) {
                    connType.spdyProtocol |= 0x1000;
                } else {
                    return null;
                }
            }
            connTypeMap.put(connProtocol, connType);
            return connType;
        }
    }

    public int getTnetConType() {
        return this.spdyProtocol;
    }

    public int getTnetPublicKey(boolean bl2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{new Byte((byte)(bl2 ? 1 : 0))}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"bc20ac0293f124335068d7c1c7545fe3");
        if (patchProxyResult.isSupported) {
            return (Integer)patchProxyResult.result;
        }
        int n2 = -1;
        if (PK_CDN.equals(this.publicKey)) {
            n2 = bl2 ? 1 : 1;
        } else if (GlobalAppRuntimeInfo.getEnv() == ENV.TEST) {
            n2 = 0;
        } else if (PK_OPEN.equals(this.publicKey)) {
            n2 = bl2 ? 11 : 10;
        } else if (PK_ACS.equals(this.publicKey)) {
            n2 = bl2 ? 4 : 3;
        }
        return n2;
    }

    public boolean isPublicKeyAuto() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"b03e650e009c6af3fe69427135f13d71");
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        return PK_AUTO.equals(this.publicKey);
    }

    public boolean isH2S() {
        return this.spdyProtocol == 40;
    }

    public boolean isQuic() {
        return (this.spdyProtocol & 4) != 0;
    }

    public boolean isHttpType() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"7ede0e4d065541897f94609e4e296a80");
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        return this.equals(HTTP) || this.equals(HTTPS);
    }

    public boolean isSSL() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"fd3a04fe6d358674d1c155be090fc25f");
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        return (this.spdyProtocol & 0x80) != 0 || (this.spdyProtocol & 0x20) != 0 || this.spdyProtocol == 12 || this.equals(HTTPS);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{object}, (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"2b0fa89d7e79cebf922cb08bd563a707");
        if (patchProxyResult.isSupported) {
            return (Boolean)patchProxyResult.result;
        }
        if (object == null || !(object instanceof ConnType)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.name.equals(((ConnType)object).name);
    }

    @Deprecated
    public TypeLevel getTypeLevel() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"9a2eca0cd8e98d3971a70f4640dc116b");
        if (patchProxyResult.isSupported) {
            return (TypeLevel)((Object)patchProxyResult.result);
        }
        if (this.isHttpType()) {
            return TypeLevel.HTTP;
        }
        return TypeLevel.SPDY;
    }

    public int getType() {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[0], (Object)this, (ChangeQuickRedirect)changeQuickRedirect, (boolean)false, (String)"5cbe773e407c2046338264e45c714fa1");
        if (patchProxyResult.isSupported) {
            return (Integer)patchProxyResult.result;
        }
        if (this.equals(HTTP) || this.equals(HTTPS)) {
            return c.b;
        }
        return c.a;
    }

    private int getPriority() {
        if ((this.spdyProtocol & 8) != 0) {
            return 0;
        }
        if ((this.spdyProtocol & 2) != 0) {
            return 1;
        }
        return 2;
    }

    public static int compare(ConnType connType, ConnType connType2) {
        PatchProxyResult patchProxyResult = PatchProxy.proxy((Object[])new Object[]{connType, connType2}, null, (ChangeQuickRedirect)changeQuickRedirect, (boolean)true, (String)"e77e6cca7435fce087d91442350843ab");
        if (patchProxyResult.isSupported) {
            return (Integer)patchProxyResult.result;
        }
        return connType.getPriority() - connType2.getPriority();
    }

    static {
        HTTP = new ConnType("http");
        HTTPS = new ConnType("https");
        connTypeMap = new HashMap<ConnProtocol, ConnType>();
    }

    @Deprecated
    public static enum TypeLevel {
        SPDY,
        HTTP;

        public static ChangeQuickRedirect changeQuickRedirect;
    }
}

